// CheckStyle: start generated
package com.oracle.truffle.runtime;

import com.oracle.truffle.api.TruffleOptionDescriptors;
import com.oracle.truffle.api.dsl.GeneratedBy;
import java.util.Arrays;
import java.util.Iterator;
import org.graalvm.options.OptionCategory;
import org.graalvm.options.OptionDescriptor;
import org.graalvm.options.OptionStability;
import org.graalvm.polyglot.SandboxPolicy;

@GeneratedBy(OptimizedRuntimeOptions.class)
final class OptimizedRuntimeOptionsOptionDescriptors implements TruffleOptionDescriptors {

    @Override
    public OptionDescriptor get(String optionName) {
        switch (optionName) {
            case "engine.ArgumentTypeSpeculation" :
                return OptionDescriptor.newBuilder(OptimizedRuntimeOptions.ArgumentTypeSpeculation, "engine.ArgumentTypeSpeculation").deprecated(false).help("Speculate on arguments types at call sites (default: true)").usageSyntax("true|false").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.BackgroundCompilation" :
                return OptionDescriptor.newBuilder(OptimizedRuntimeOptions.BackgroundCompilation, "engine.BackgroundCompilation").deprecated(false).help("Enable asynchronous truffle compilation in background threads (default: true)").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.Compilation" :
                return OptionDescriptor.newBuilder(OptimizedRuntimeOptions.Compilation, "engine.Compilation").deprecated(false).help("Enable or disable Truffle compilation.").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.CompilationFailureAction" :
                return OptionDescriptor.newBuilder(OptimizedRuntimeOptions.CompilationFailureAction, "engine.CompilationFailureAction").deprecated(false).help(String.format("Specifies the action to take when Truffle compilation fails.%nThe accepted values are:%n    Silent - Print nothing to the console.%n     Print - Print the exception to the console.%n     Throw - Throw the exception to caller.%n  Diagnose - Retry compilation with extra diagnostics enabled.%n    ExitVM - Exit the VM process.")).usageSyntax("Silent|Print|Throw|Diagnose|ExitVM").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.CompilationStatisticDetails" :
                return OptionDescriptor.newBuilder(OptimizedRuntimeOptions.CompilationStatisticDetails, "engine.CompilationStatisticDetails").deprecated(false).help("Print additional more verbose Truffle compilation statistics at the end of a run.").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.CompilationStatistics" :
                return OptionDescriptor.newBuilder(OptimizedRuntimeOptions.CompilationStatistics, "engine.CompilationStatistics").deprecated(false).help("Print Truffle compilation statistics at the end of a run.").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.CompileAOTOnCreate" :
                return OptionDescriptor.newBuilder(OptimizedRuntimeOptions.CompileAOTOnCreate, "engine.CompileAOTOnCreate").deprecated(false).help("Compiles created call targets immediately with last tier. Disables background compilation if enabled.").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.CompileImmediately" :
                return OptionDescriptor.newBuilder(OptimizedRuntimeOptions.CompileImmediately, "engine.CompileImmediately").deprecated(false).help("Compile immediately to test Truffle compilation").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.CompileOnly" :
                return OptionDescriptor.newBuilder(OptimizedRuntimeOptions.CompileOnly, "engine.CompileOnly").deprecated(false).help("Restrict compilation to ','-separated list of includes (or excludes prefixed with '~'). No restriction by default.").usageSyntax("<name>,<name>,...").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.CompilerIdleDelay" :
                return OptionDescriptor.newBuilder(OptimizedRuntimeOptions.CompilerIdleDelay, "engine.CompilerIdleDelay").deprecated(false).help("Set the time in milliseconds an idle Truffle compiler thread will wait for new tasks before terminating. New compiler threads will be started once new compilation tasks are submitted. Select '0' to never terminate the Truffle compiler thread. The option is not supported by all Truffle runtimes. On the runtime which doesn't support it the option has no effect. default: 10000").usageSyntax("<ms>").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.CompilerThreads" :
                return OptionDescriptor.newBuilder(OptimizedRuntimeOptions.CompilerThreads, "engine.CompilerThreads").deprecated(false).help("Manually set the number of compiler threads. By default, the number of compiler threads is scaled with the number of available cores on the CPU.").usageSyntax("[1, inf)").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.DynamicCompilationThresholds" :
                return OptionDescriptor.newBuilder(OptimizedRuntimeOptions.DynamicCompilationThresholds, "engine.DynamicCompilationThresholds").deprecated(false).help("Reduce or increase the compilation threshold depending on the size of the compilation queue (default: true).").usageSyntax("true|false").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.DynamicCompilationThresholdsMaxNormalLoad" :
                return OptionDescriptor.newBuilder(OptimizedRuntimeOptions.DynamicCompilationThresholdsMaxNormalLoad, "engine.DynamicCompilationThresholdsMaxNormalLoad").deprecated(false).help("The desired maximum compilation queue load. When the load rises above this value, the compilation thresholds are increased. The load is scaled by the number of compiler threads.  (default: 10)").usageSyntax("[1, inf)").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.DynamicCompilationThresholdsMinNormalLoad" :
                return OptionDescriptor.newBuilder(OptimizedRuntimeOptions.DynamicCompilationThresholdsMinNormalLoad, "engine.DynamicCompilationThresholdsMinNormalLoad").deprecated(false).help("The desired minimum compilation queue load. When the load falls bellow this value, the compilation thresholds are decreased. The load is scaled by the number of compiler threads (default: 10).").usageSyntax("[1, inf)").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.DynamicCompilationThresholdsMinScale" :
                return OptionDescriptor.newBuilder(OptimizedRuntimeOptions.DynamicCompilationThresholdsMinScale, "engine.DynamicCompilationThresholdsMinScale").deprecated(false).help("The minimal scale the compilation thresholds can be reduced to (default: 0.1).").usageSyntax("[0.0, inf)").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.EncodedGraphCachePurgeDelay" :
                return OptionDescriptor.newBuilder(OptimizedRuntimeOptions.EncodedGraphCachePurgeDelay, "engine.EncodedGraphCachePurgeDelay").deprecated(false).help("Delay, in milliseconds, after which the encoded graph cache is dropped when a Truffle compiler thread becomes idle (default: 10000).").usageSyntax("<ms>").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.FirstTierBackedgeCounts" :
                return OptionDescriptor.newBuilder(OptimizedRuntimeOptions.FirstTierBackedgeCounts, "engine.FirstTierBackedgeCounts").deprecated(false).help("Whether to emit look-back-edge counters in the first-tier compilations. (default: true)").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.FirstTierCompilationThreshold" :
                return OptionDescriptor.newBuilder(OptimizedRuntimeOptions.FirstTierCompilationThreshold, "engine.FirstTierCompilationThreshold").deprecated(false).help("Number of invocations or loop iterations needed to compile a guest language root in first tier under normal compilation load.Might be reduced/increased when compilation load is low/high if DynamicCompilationThresholds is enabled. (default: 400).").usageSyntax("[1, inf)").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.FirstTierMinInvokeThreshold" :
                return OptionDescriptor.newBuilder(OptimizedRuntimeOptions.FirstTierMinInvokeThreshold, "engine.FirstTierMinInvokeThreshold").deprecated(false).help("Minimum number of calls before a call target is compiled in the first tier (default: 1)").usageSyntax("[1, inf)").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.LastTierCompilationThreshold" :
                return OptionDescriptor.newBuilder(OptimizedRuntimeOptions.LastTierCompilationThreshold, "engine.LastTierCompilationThreshold").deprecated(false).help("Number of invocations or loop iterations needed to compile a guest language root in first tier under normal compilation load.Might be reduced/increased when compilation load is low/high if DynamicCompilationThresholds is enabled. (default: 10000).").usageSyntax("[1, inf)").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.MinInvokeThreshold" :
                return OptionDescriptor.newBuilder(OptimizedRuntimeOptions.MinInvokeThreshold, "engine.MinInvokeThreshold").deprecated(false).help("Minimum number of calls before a call target is compiled (default: 3).").usageSyntax("[1, inf)").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.Mode" :
                return OptionDescriptor.newBuilder(OptimizedRuntimeOptions.Mode, "engine.Mode").deprecated(false).help("Configures the execution mode of the engine. Available modes are 'latency' and 'throughput'. The default value balances between the two.").usageSyntax("latency|throughput").category(OptionCategory.EXPERT).stability(OptionStability.STABLE).build();
            case "engine.MultiTier" :
                return OptionDescriptor.newBuilder(OptimizedRuntimeOptions.MultiTier, "engine.MultiTier").deprecated(false).help("Whether to use multiple Truffle compilation tiers by default. (default: true)").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.OSR" :
                return OptionDescriptor.newBuilder(OptimizedRuntimeOptions.OSR, "engine.OSR").deprecated(false).help("Enable automatic on-stack-replacement of loops (default: true).").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.OSRCompilationThreshold" :
                return OptionDescriptor.newBuilder(OptimizedRuntimeOptions.OSRCompilationThreshold, "engine.OSRCompilationThreshold").deprecated(false).help("Number of loop iterations until on-stack-replacement compilation is triggered (default 100352).").usageSyntax("[1, inf)").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.OSRMaxCompilationReAttempts" :
                return OptionDescriptor.newBuilder(OptimizedRuntimeOptions.OSRMaxCompilationReAttempts, "engine.OSRMaxCompilationReAttempts").deprecated(false).help("Number of compilation re-attempts before bailing out of OSR compilation for a given method (default 30). This number is an approximation of the acceptable number of deopts.").usageSyntax("[0, inf)").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.PartialBlockCompilation" :
                return OptionDescriptor.newBuilder(OptimizedRuntimeOptions.PartialBlockCompilation, "engine.PartialBlockCompilation").deprecated(false).help("Enable partial compilation for BlockNode (default: true).").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.PartialBlockCompilationSize" :
                return OptionDescriptor.newBuilder(OptimizedRuntimeOptions.PartialBlockCompilationSize, "engine.PartialBlockCompilationSize").deprecated(false).help("Sets the target non-trivial Truffle node size for partial compilation of BlockNode nodes (default: 3000).").usageSyntax("[1, inf)").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.PartialBlockMaximumSize" :
                return OptionDescriptor.newBuilder(OptimizedRuntimeOptions.PartialBlockMaximumSize, "engine.PartialBlockMaximumSize").deprecated(false).help("Sets the maximum non-trivial Truffle node size for partial compilation of BlockNode nodes (default: 10000).").usageSyntax("[1, inf)").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.PriorityQueue" :
                return OptionDescriptor.newBuilder(OptimizedRuntimeOptions.PriorityQueue, "engine.PriorityQueue").deprecated(false).help("Use the priority of compilation jobs in the compilation queue (default: true).").usageSyntax("true|false").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.Profiling" :
                return OptionDescriptor.newBuilder(OptimizedRuntimeOptions.Profiling, "engine.Profiling").deprecated(false).help("Enable/disable builtin profiles in com.oracle.truffle.api.profiles. (default: true)").usageSyntax("true|false").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.PropagateLoopCountToLexicalSingleCaller" :
                return OptionDescriptor.newBuilder(OptimizedRuntimeOptions.PropagateLoopCountToLexicalSingleCaller, "engine.PropagateLoopCountToLexicalSingleCaller").deprecated(false).help("Enables hotness propagation to lexical parent to lexically parent single callers.").usageSyntax("true|false").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.PropagateLoopCountToLexicalSingleCallerMaxDepth" :
                return OptionDescriptor.newBuilder(OptimizedRuntimeOptions.PropagateLoopCountToLexicalSingleCallerMaxDepth, "engine.PropagateLoopCountToLexicalSingleCallerMaxDepth").deprecated(false).help("How high to propagate call and loop count (hotness proxy) up a single caller chain to lexical scope parent.").usageSyntax("[0, inf)").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.ReturnTypeSpeculation" :
                return OptionDescriptor.newBuilder(OptimizedRuntimeOptions.ReturnTypeSpeculation, "engine.ReturnTypeSpeculation").deprecated(false).help("Speculate on return types at call sites (default: true)").usageSyntax("true|false").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.SingleTierCompilationThreshold" :
                return OptionDescriptor.newBuilder(OptimizedRuntimeOptions.SingleTierCompilationThreshold, "engine.SingleTierCompilationThreshold").deprecated(false).help("Minimum number of invocations or loop iterations needed to compile a guest language root when not using multi tier (default: 1000).").usageSyntax("[1, inf)").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.Splitting" :
                return OptionDescriptor.newBuilder(OptimizedRuntimeOptions.Splitting, "engine.Splitting").deprecated(false).help("Enable automatic duplication of compilation profiles (splitting) (default: true).").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.SplittingAllowForcedSplits" :
                return OptionDescriptor.newBuilder(OptimizedRuntimeOptions.SplittingAllowForcedSplits, "engine.SplittingAllowForcedSplits").deprecated(false).help("Should forced splits be allowed (default: true)").usageSyntax("true|false").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.SplittingDumpDecisions" :
                return OptionDescriptor.newBuilder(OptimizedRuntimeOptions.SplittingDumpDecisions, "engine.SplittingDumpDecisions").deprecated(false).help("Dumps to IGV information on polymorphic events").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.SplittingGrowthLimit" :
                return OptionDescriptor.newBuilder(OptimizedRuntimeOptions.SplittingGrowthLimit, "engine.SplittingGrowthLimit").deprecated(false).help("Disable call target splitting if the number of nodes created by splitting exceeds this factor times node count (default: 1.5).").usageSyntax("[0.0, inf)").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.SplittingMaxCalleeSize" :
                return OptionDescriptor.newBuilder(OptimizedRuntimeOptions.SplittingMaxCalleeSize, "engine.SplittingMaxCalleeSize").deprecated(false).help("Disable call target splitting if tree size exceeds this limit (default: 100)").usageSyntax("[1, inf)").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.SplittingMaxPropagationDepth" :
                return OptionDescriptor.newBuilder(OptimizedRuntimeOptions.SplittingMaxPropagationDepth, "engine.SplittingMaxPropagationDepth").deprecated(false).help("Propagate info about a polymorphic specialize through maximum this many call targets (default: 5)").usageSyntax("[1, inf)").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.SplittingTraceEvents" :
                return OptionDescriptor.newBuilder(OptimizedRuntimeOptions.SplittingTraceEvents, "engine.SplittingTraceEvents").deprecated(false).help("Trace details of splitting events and decisions.").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.ThrowOnMaxOSRCompilationReAttemptsReached" :
                return OptionDescriptor.newBuilder(OptimizedRuntimeOptions.ThrowOnMaxOSRCompilationReAttemptsReached, "engine.ThrowOnMaxOSRCompilationReAttemptsReached").deprecated(false).help("Whether an AssertionError is thrown when the maximum number of OSR compilation attempts is reached for a given method (default 'false'). This should only be set to 'true' in testing environments.").usageSyntax("true|false").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.TraceAssumptions" :
                return OptionDescriptor.newBuilder(OptimizedRuntimeOptions.TraceAssumptions, "engine.TraceAssumptions").deprecated(false).help("Print stack trace on assumption invalidation").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.TraceCompilation" :
                return OptionDescriptor.newBuilder(OptimizedRuntimeOptions.TraceCompilation, "engine.TraceCompilation").deprecated(false).help("Print information for compilation results.").usageSyntax("").category(OptionCategory.EXPERT).stability(OptionStability.STABLE).build();
            case "engine.TraceCompilationAST" :
                return OptionDescriptor.newBuilder(OptimizedRuntimeOptions.TraceCompilationAST, "engine.TraceCompilationAST").deprecated(false).help("Print the entire AST after each compilation").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.TraceCompilationDetails" :
                return OptionDescriptor.newBuilder(OptimizedRuntimeOptions.TraceCompilationDetails, "engine.TraceCompilationDetails").deprecated(false).help("Print information for compilation queuing.").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.TraceCompilationPolymorphism" :
                return OptionDescriptor.newBuilder(OptimizedRuntimeOptions.TraceCompilationPolymorphism, "engine.TraceCompilationPolymorphism").deprecated(false).help("Print all polymorphic and generic nodes after each compilation").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.TraceDeoptimizeFrame" :
                return OptionDescriptor.newBuilder(OptimizedRuntimeOptions.TraceDeoptimizeFrame, "engine.TraceDeoptimizeFrame").deprecated(false).help("Print stack trace when deoptimizing a frame from the stack with `FrameInstance#getFrame(READ_WRITE|MATERIALIZE)`.").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.TraceSplitting" :
                return OptionDescriptor.newBuilder(OptimizedRuntimeOptions.TraceSplitting, "engine.TraceSplitting").deprecated(false).help("Print information for splitting decisions.").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.TraceSplittingSummary" :
                return OptionDescriptor.newBuilder(OptimizedRuntimeOptions.TraceSplittingSummary, "engine.TraceSplittingSummary").deprecated(false).help("Used for debugging the splitting implementation. Prints splitting summary directly to stdout on shutdown").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.TraceStackTraceLimit" :
                return OptionDescriptor.newBuilder(OptimizedRuntimeOptions.TraceStackTraceLimit, "engine.TraceStackTraceLimit").deprecated(false).help("Number of stack trace elements printed by TraceTruffleTransferToInterpreter, TraceTruffleAssumptions and TraceDeoptimizeFrame (default: 20).").usageSyntax("[1, inf)").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.TraceTransferToInterpreter" :
                return OptionDescriptor.newBuilder(OptimizedRuntimeOptions.TraceTransferToInterpreter, "engine.TraceTransferToInterpreter").deprecated(false).help("Print stack trace on transfer to interpreter.").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.TraversingCompilationQueue" :
                return OptionDescriptor.newBuilder(OptimizedRuntimeOptions.TraversingCompilationQueue, "engine.TraversingCompilationQueue").deprecated(false).help("Use a traversing compilation queue. (default: true)").usageSyntax("true|false").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.TraversingQueueFirstTierBonus" :
                return OptionDescriptor.newBuilder(OptimizedRuntimeOptions.TraversingQueueFirstTierBonus, "engine.TraversingQueueFirstTierBonus").deprecated(false).help("Controls how much of a priority should be given to first tier compilations (default 15.0).").usageSyntax("[0.0, inf)").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.TraversingQueueFirstTierPriority" :
                return OptionDescriptor.newBuilder(OptimizedRuntimeOptions.TraversingQueueFirstTierPriority, "engine.TraversingQueueFirstTierPriority").deprecated(false).help("Traversing queue gives first tier compilations priority.").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.TraversingQueueWeightingBothTiers" :
                return OptionDescriptor.newBuilder(OptimizedRuntimeOptions.TraversingQueueWeightingBothTiers, "engine.TraversingQueueWeightingBothTiers").deprecated(false).help("Traversing queue uses rate as priority for both tier. (default: true)").usageSyntax("true|false").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
        }
        return null;
    }

    @Override
    public SandboxPolicy getSandboxPolicy(String optionName) {
        assert get(optionName) != null : "Unknown option " + optionName;
        switch (optionName) {
            case "engine.Mode" :
                return SandboxPolicy.UNTRUSTED;
            default :
                return SandboxPolicy.TRUSTED;
        }
    }

    @Override
    public Iterator<OptionDescriptor> iterator() {
        return Arrays.asList(
            OptionDescriptor.newBuilder(OptimizedRuntimeOptions.ArgumentTypeSpeculation, "engine.ArgumentTypeSpeculation").deprecated(false).help("Speculate on arguments types at call sites (default: true)").usageSyntax("true|false").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(OptimizedRuntimeOptions.BackgroundCompilation, "engine.BackgroundCompilation").deprecated(false).help("Enable asynchronous truffle compilation in background threads (default: true)").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(OptimizedRuntimeOptions.Compilation, "engine.Compilation").deprecated(false).help("Enable or disable Truffle compilation.").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(OptimizedRuntimeOptions.CompilationFailureAction, "engine.CompilationFailureAction").deprecated(false).help(String.format("Specifies the action to take when Truffle compilation fails.%nThe accepted values are:%n    Silent - Print nothing to the console.%n     Print - Print the exception to the console.%n     Throw - Throw the exception to caller.%n  Diagnose - Retry compilation with extra diagnostics enabled.%n    ExitVM - Exit the VM process.")).usageSyntax("Silent|Print|Throw|Diagnose|ExitVM").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(OptimizedRuntimeOptions.CompilationStatisticDetails, "engine.CompilationStatisticDetails").deprecated(false).help("Print additional more verbose Truffle compilation statistics at the end of a run.").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(OptimizedRuntimeOptions.CompilationStatistics, "engine.CompilationStatistics").deprecated(false).help("Print Truffle compilation statistics at the end of a run.").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(OptimizedRuntimeOptions.CompileAOTOnCreate, "engine.CompileAOTOnCreate").deprecated(false).help("Compiles created call targets immediately with last tier. Disables background compilation if enabled.").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(OptimizedRuntimeOptions.CompileImmediately, "engine.CompileImmediately").deprecated(false).help("Compile immediately to test Truffle compilation").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(OptimizedRuntimeOptions.CompileOnly, "engine.CompileOnly").deprecated(false).help("Restrict compilation to ','-separated list of includes (or excludes prefixed with '~'). No restriction by default.").usageSyntax("<name>,<name>,...").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(OptimizedRuntimeOptions.CompilerIdleDelay, "engine.CompilerIdleDelay").deprecated(false).help("Set the time in milliseconds an idle Truffle compiler thread will wait for new tasks before terminating. New compiler threads will be started once new compilation tasks are submitted. Select '0' to never terminate the Truffle compiler thread. The option is not supported by all Truffle runtimes. On the runtime which doesn't support it the option has no effect. default: 10000").usageSyntax("<ms>").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(OptimizedRuntimeOptions.CompilerThreads, "engine.CompilerThreads").deprecated(false).help("Manually set the number of compiler threads. By default, the number of compiler threads is scaled with the number of available cores on the CPU.").usageSyntax("[1, inf)").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(OptimizedRuntimeOptions.DynamicCompilationThresholds, "engine.DynamicCompilationThresholds").deprecated(false).help("Reduce or increase the compilation threshold depending on the size of the compilation queue (default: true).").usageSyntax("true|false").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(OptimizedRuntimeOptions.DynamicCompilationThresholdsMaxNormalLoad, "engine.DynamicCompilationThresholdsMaxNormalLoad").deprecated(false).help("The desired maximum compilation queue load. When the load rises above this value, the compilation thresholds are increased. The load is scaled by the number of compiler threads.  (default: 10)").usageSyntax("[1, inf)").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(OptimizedRuntimeOptions.DynamicCompilationThresholdsMinNormalLoad, "engine.DynamicCompilationThresholdsMinNormalLoad").deprecated(false).help("The desired minimum compilation queue load. When the load falls bellow this value, the compilation thresholds are decreased. The load is scaled by the number of compiler threads (default: 10).").usageSyntax("[1, inf)").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(OptimizedRuntimeOptions.DynamicCompilationThresholdsMinScale, "engine.DynamicCompilationThresholdsMinScale").deprecated(false).help("The minimal scale the compilation thresholds can be reduced to (default: 0.1).").usageSyntax("[0.0, inf)").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(OptimizedRuntimeOptions.EncodedGraphCachePurgeDelay, "engine.EncodedGraphCachePurgeDelay").deprecated(false).help("Delay, in milliseconds, after which the encoded graph cache is dropped when a Truffle compiler thread becomes idle (default: 10000).").usageSyntax("<ms>").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(OptimizedRuntimeOptions.FirstTierBackedgeCounts, "engine.FirstTierBackedgeCounts").deprecated(false).help("Whether to emit look-back-edge counters in the first-tier compilations. (default: true)").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(OptimizedRuntimeOptions.FirstTierCompilationThreshold, "engine.FirstTierCompilationThreshold").deprecated(false).help("Number of invocations or loop iterations needed to compile a guest language root in first tier under normal compilation load.Might be reduced/increased when compilation load is low/high if DynamicCompilationThresholds is enabled. (default: 400).").usageSyntax("[1, inf)").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(OptimizedRuntimeOptions.FirstTierMinInvokeThreshold, "engine.FirstTierMinInvokeThreshold").deprecated(false).help("Minimum number of calls before a call target is compiled in the first tier (default: 1)").usageSyntax("[1, inf)").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(OptimizedRuntimeOptions.LastTierCompilationThreshold, "engine.LastTierCompilationThreshold").deprecated(false).help("Number of invocations or loop iterations needed to compile a guest language root in first tier under normal compilation load.Might be reduced/increased when compilation load is low/high if DynamicCompilationThresholds is enabled. (default: 10000).").usageSyntax("[1, inf)").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(OptimizedRuntimeOptions.MinInvokeThreshold, "engine.MinInvokeThreshold").deprecated(false).help("Minimum number of calls before a call target is compiled (default: 3).").usageSyntax("[1, inf)").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(OptimizedRuntimeOptions.Mode, "engine.Mode").deprecated(false).help("Configures the execution mode of the engine. Available modes are 'latency' and 'throughput'. The default value balances between the two.").usageSyntax("latency|throughput").category(OptionCategory.EXPERT).stability(OptionStability.STABLE).build(),
            OptionDescriptor.newBuilder(OptimizedRuntimeOptions.MultiTier, "engine.MultiTier").deprecated(false).help("Whether to use multiple Truffle compilation tiers by default. (default: true)").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(OptimizedRuntimeOptions.OSR, "engine.OSR").deprecated(false).help("Enable automatic on-stack-replacement of loops (default: true).").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(OptimizedRuntimeOptions.OSRCompilationThreshold, "engine.OSRCompilationThreshold").deprecated(false).help("Number of loop iterations until on-stack-replacement compilation is triggered (default 100352).").usageSyntax("[1, inf)").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(OptimizedRuntimeOptions.OSRMaxCompilationReAttempts, "engine.OSRMaxCompilationReAttempts").deprecated(false).help("Number of compilation re-attempts before bailing out of OSR compilation for a given method (default 30). This number is an approximation of the acceptable number of deopts.").usageSyntax("[0, inf)").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(OptimizedRuntimeOptions.PartialBlockCompilation, "engine.PartialBlockCompilation").deprecated(false).help("Enable partial compilation for BlockNode (default: true).").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(OptimizedRuntimeOptions.PartialBlockCompilationSize, "engine.PartialBlockCompilationSize").deprecated(false).help("Sets the target non-trivial Truffle node size for partial compilation of BlockNode nodes (default: 3000).").usageSyntax("[1, inf)").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(OptimizedRuntimeOptions.PartialBlockMaximumSize, "engine.PartialBlockMaximumSize").deprecated(false).help("Sets the maximum non-trivial Truffle node size for partial compilation of BlockNode nodes (default: 10000).").usageSyntax("[1, inf)").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(OptimizedRuntimeOptions.PriorityQueue, "engine.PriorityQueue").deprecated(false).help("Use the priority of compilation jobs in the compilation queue (default: true).").usageSyntax("true|false").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(OptimizedRuntimeOptions.Profiling, "engine.Profiling").deprecated(false).help("Enable/disable builtin profiles in com.oracle.truffle.api.profiles. (default: true)").usageSyntax("true|false").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(OptimizedRuntimeOptions.PropagateLoopCountToLexicalSingleCaller, "engine.PropagateLoopCountToLexicalSingleCaller").deprecated(false).help("Enables hotness propagation to lexical parent to lexically parent single callers.").usageSyntax("true|false").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(OptimizedRuntimeOptions.PropagateLoopCountToLexicalSingleCallerMaxDepth, "engine.PropagateLoopCountToLexicalSingleCallerMaxDepth").deprecated(false).help("How high to propagate call and loop count (hotness proxy) up a single caller chain to lexical scope parent.").usageSyntax("[0, inf)").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(OptimizedRuntimeOptions.ReturnTypeSpeculation, "engine.ReturnTypeSpeculation").deprecated(false).help("Speculate on return types at call sites (default: true)").usageSyntax("true|false").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(OptimizedRuntimeOptions.SingleTierCompilationThreshold, "engine.SingleTierCompilationThreshold").deprecated(false).help("Minimum number of invocations or loop iterations needed to compile a guest language root when not using multi tier (default: 1000).").usageSyntax("[1, inf)").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(OptimizedRuntimeOptions.Splitting, "engine.Splitting").deprecated(false).help("Enable automatic duplication of compilation profiles (splitting) (default: true).").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(OptimizedRuntimeOptions.SplittingAllowForcedSplits, "engine.SplittingAllowForcedSplits").deprecated(false).help("Should forced splits be allowed (default: true)").usageSyntax("true|false").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(OptimizedRuntimeOptions.SplittingDumpDecisions, "engine.SplittingDumpDecisions").deprecated(false).help("Dumps to IGV information on polymorphic events").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(OptimizedRuntimeOptions.SplittingGrowthLimit, "engine.SplittingGrowthLimit").deprecated(false).help("Disable call target splitting if the number of nodes created by splitting exceeds this factor times node count (default: 1.5).").usageSyntax("[0.0, inf)").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(OptimizedRuntimeOptions.SplittingMaxCalleeSize, "engine.SplittingMaxCalleeSize").deprecated(false).help("Disable call target splitting if tree size exceeds this limit (default: 100)").usageSyntax("[1, inf)").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(OptimizedRuntimeOptions.SplittingMaxPropagationDepth, "engine.SplittingMaxPropagationDepth").deprecated(false).help("Propagate info about a polymorphic specialize through maximum this many call targets (default: 5)").usageSyntax("[1, inf)").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(OptimizedRuntimeOptions.SplittingTraceEvents, "engine.SplittingTraceEvents").deprecated(false).help("Trace details of splitting events and decisions.").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(OptimizedRuntimeOptions.ThrowOnMaxOSRCompilationReAttemptsReached, "engine.ThrowOnMaxOSRCompilationReAttemptsReached").deprecated(false).help("Whether an AssertionError is thrown when the maximum number of OSR compilation attempts is reached for a given method (default 'false'). This should only be set to 'true' in testing environments.").usageSyntax("true|false").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(OptimizedRuntimeOptions.TraceAssumptions, "engine.TraceAssumptions").deprecated(false).help("Print stack trace on assumption invalidation").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(OptimizedRuntimeOptions.TraceCompilation, "engine.TraceCompilation").deprecated(false).help("Print information for compilation results.").usageSyntax("").category(OptionCategory.EXPERT).stability(OptionStability.STABLE).build(),
            OptionDescriptor.newBuilder(OptimizedRuntimeOptions.TraceCompilationAST, "engine.TraceCompilationAST").deprecated(false).help("Print the entire AST after each compilation").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(OptimizedRuntimeOptions.TraceCompilationDetails, "engine.TraceCompilationDetails").deprecated(false).help("Print information for compilation queuing.").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(OptimizedRuntimeOptions.TraceCompilationPolymorphism, "engine.TraceCompilationPolymorphism").deprecated(false).help("Print all polymorphic and generic nodes after each compilation").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(OptimizedRuntimeOptions.TraceDeoptimizeFrame, "engine.TraceDeoptimizeFrame").deprecated(false).help("Print stack trace when deoptimizing a frame from the stack with `FrameInstance#getFrame(READ_WRITE|MATERIALIZE)`.").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(OptimizedRuntimeOptions.TraceSplitting, "engine.TraceSplitting").deprecated(false).help("Print information for splitting decisions.").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(OptimizedRuntimeOptions.TraceSplittingSummary, "engine.TraceSplittingSummary").deprecated(false).help("Used for debugging the splitting implementation. Prints splitting summary directly to stdout on shutdown").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(OptimizedRuntimeOptions.TraceStackTraceLimit, "engine.TraceStackTraceLimit").deprecated(false).help("Number of stack trace elements printed by TraceTruffleTransferToInterpreter, TraceTruffleAssumptions and TraceDeoptimizeFrame (default: 20).").usageSyntax("[1, inf)").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(OptimizedRuntimeOptions.TraceTransferToInterpreter, "engine.TraceTransferToInterpreter").deprecated(false).help("Print stack trace on transfer to interpreter.").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(OptimizedRuntimeOptions.TraversingCompilationQueue, "engine.TraversingCompilationQueue").deprecated(false).help("Use a traversing compilation queue. (default: true)").usageSyntax("true|false").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(OptimizedRuntimeOptions.TraversingQueueFirstTierBonus, "engine.TraversingQueueFirstTierBonus").deprecated(false).help("Controls how much of a priority should be given to first tier compilations (default 15.0).").usageSyntax("[0.0, inf)").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(OptimizedRuntimeOptions.TraversingQueueFirstTierPriority, "engine.TraversingQueueFirstTierPriority").deprecated(false).help("Traversing queue gives first tier compilations priority.").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(OptimizedRuntimeOptions.TraversingQueueWeightingBothTiers, "engine.TraversingQueueWeightingBothTiers").deprecated(false).help("Traversing queue uses rate as priority for both tier. (default: true)").usageSyntax("true|false").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build())
        .iterator();
    }

}
