/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.commons.metaclass;

import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import groovy.lang.MetaProperty;
import groovy.util.MapEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LazyMetaPropertyMap
implements Map {
    private MetaClass metaClass;
    private Object instance;
    private static List EXCLUDES = new ArrayList(){
        {
            this.add("properties");
        }
    };

    public LazyMetaPropertyMap(Object o) {
        if (o == null) {
            throw new IllegalArgumentException("Object cannot be null");
        }
        this.instance = o;
        this.metaClass = GroovySystem.getMetaClassRegistry().getMetaClass(o.getClass());
    }

    public int size() {
        return this.keySet().size();
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean containsKey(Object propertyName) {
        if (propertyName instanceof CharSequence) {
            propertyName = propertyName.toString();
        }
        if (!(propertyName instanceof String)) {
            throw new IllegalArgumentException("This map implementation only supports String based keys!");
        }
        if (EXCLUDES.contains(propertyName)) {
            return false;
        }
        return this.metaClass.getMetaProperty((String)propertyName) != null;
    }

    public boolean containsValue(Object o) {
        return this.values().contains(o);
    }

    public Object get(Object propertyName) {
        if (propertyName instanceof CharSequence) {
            propertyName = propertyName.toString();
        }
        if (propertyName instanceof List) {
            HashMap submap = new HashMap();
            List propertyNames = (List)propertyName;
            for (Object currentName : propertyNames) {
                if (currentName == null || !this.containsKey(currentName = currentName.toString())) continue;
                submap.put(currentName, this.get(currentName));
            }
            return submap;
        }
        if (EXCLUDES.contains(propertyName)) {
            return null;
        }
        Object val = null;
        MetaProperty mp = this.metaClass.getMetaProperty((String)propertyName);
        if (mp != null) {
            val = mp.getProperty(this.instance);
        }
        return val;
    }

    public Object put(Object propertyName, Object propertyValue) {
        if (propertyName instanceof CharSequence) {
            propertyName = propertyName.toString();
        }
        Object old = null;
        MetaProperty mp = this.metaClass.getMetaProperty((String)propertyName);
        if (mp != null) {
            old = mp.getProperty(this.instance);
            mp.setProperty(this.instance, propertyValue);
        }
        return old;
    }

    public Object remove(Object o) {
        throw new UnsupportedOperationException("Method remove(Object o) is not supported by this implementation");
    }

    public void putAll(Map map) {
        Iterator i = map.keySet().iterator();
        while (i.hasNext()) {
            Object key = i.next();
            this.put(key, map.get(i));
        }
    }

    public void clear() {
        throw new UnsupportedOperationException("Method clear() is not supported by this implementation");
    }

    public Set keySet() {
        List properties = this.metaClass.getProperties();
        HashSet<String> names = new HashSet<String>();
        for (MetaProperty mp : properties) {
            if (EXCLUDES.contains(mp.getName())) continue;
            names.add(mp.getName());
        }
        return names;
    }

    public Collection values() {
        List properties = this.metaClass.getProperties();
        ArrayList<Object> values = new ArrayList<Object>();
        for (MetaProperty mp : properties) {
            if (EXCLUDES.contains(mp.getName())) continue;
            values.add(mp.getProperty(this.instance));
        }
        return values;
    }

    public int hashCode() {
        return this.instance.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof LazyMetaPropertyMap) {
            LazyMetaPropertyMap other = (LazyMetaPropertyMap)o;
            return this.instance.equals(other.getInstance());
        }
        return false;
    }

    public Object getInstance() {
        return this.instance;
    }

    public Set entrySet() {
        List properties = this.metaClass.getProperties();
        HashSet<MapEntry> entries = new HashSet<MapEntry>();
        for (MetaProperty mp : properties) {
            if (EXCLUDES.contains(mp.getName())) continue;
            entries.add(new MapEntry((Object)mp.getName(), mp.getProperty(this.instance)));
        }
        return entries;
    }
}

