/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.compiler.injection;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.classgen.GeneratorContext;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.ProcessingUnit;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.grails.commons.GrailsResourceUtils;
import org.codehaus.groovy.grails.compiler.injection.GrailsDomainClassInjector;
import org.codehaus.groovy.grails.compiler.support.GrailsResourceLoader;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class GrailsInjectionOperation
extends CompilationUnit.PrimaryClassNodeOperation
implements ApplicationContextAware {
    private ApplicationContext applicationContext;
    private GrailsResourceLoader resourceLoader;
    private static final Log LOG = LogFactory.getLog(GrailsInjectionOperation.class);

    public void call(SourceUnit source, GeneratorContext context, ClassNode classNode) throws CompilationFailedException {
        if (this.applicationContext != null && this.resourceLoader != null) {
            try {
                URL url = GrailsResourceUtils.isGrailsPath(source.getName()) ? this.resourceLoader.loadGroovySource(GrailsResourceUtils.getClassName(source.getName())) : this.resourceLoader.loadGroovySource(source.getName());
                if (GrailsResourceUtils.isDomainClass(url)) {
                    Map injectors = this.applicationContext.getBeansOfType(GrailsDomainClassInjector.class);
                    for (GrailsDomainClassInjector injector : injectors.values()) {
                        injector.performInjection(source, context, classNode);
                    }
                }
            }
            catch (MalformedURLException e) {
                LOG.error((Object)("Error loading URL during addition of compile time properties: " + e.getMessage()), (Throwable)e);
                throw new CompilationFailedException(3, (ProcessingUnit)source, (Throwable)e);
            }
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setResourceLoader(GrailsResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }
}

