/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.validation;

import java.lang.reflect.Array;
import java.util.Collection;
import org.codehaus.groovy.grails.validation.AbstractConstraint;
import org.springframework.validation.Errors;

class MaxSizeConstraint
extends AbstractConstraint {
    private int maxSize;

    MaxSizeConstraint() {
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setParameter(Object constraintParameter) {
        if (!(constraintParameter instanceof Integer)) {
            throw new IllegalArgumentException("Parameter for constraint [maxSize] of property [" + this.constraintPropertyName + "] of class [" + this.constraintOwningClass + "] must be a of type [java.lang.Integer]");
        }
        this.maxSize = (Integer)constraintParameter;
        super.setParameter(constraintParameter);
    }

    public String getName() {
        return "maxSize";
    }

    public boolean supports(Class type) {
        return type != null && (String.class.isAssignableFrom(type) || Collection.class.isAssignableFrom(type) || type.isArray());
    }

    protected void processValidate(Object target, Object propertyValue, Errors errors) {
        Object[] args = new Object[]{this.constraintPropertyName, this.constraintOwningClass, propertyValue, new Integer(this.maxSize)};
        if (propertyValue.getClass().isArray()) {
            int length = Array.getLength(propertyValue);
            if (length > this.maxSize) {
                super.rejectValue(target, errors, "default.invalid.max.size.message", "maxSize.exceeded", args);
            }
        } else if (propertyValue instanceof Collection) {
            if (((Collection)propertyValue).size() > this.maxSize) {
                super.rejectValue(target, errors, "default.invalid.max.size.message", "maxSize.exceeded", args);
            }
        } else if (propertyValue instanceof String && ((String)propertyValue).length() > this.maxSize) {
            super.rejectValue(target, errors, "default.invalid.max.size.message", "maxSize.exceeded", args);
        }
    }
}

