/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.validation;

import java.lang.reflect.Array;
import java.util.Collection;
import org.codehaus.groovy.grails.validation.AbstractConstraint;
import org.springframework.validation.Errors;

class MinSizeConstraint
extends AbstractConstraint {
    private int minSize;

    MinSizeConstraint() {
    }

    public int getMinSize() {
        return this.minSize;
    }

    public void setParameter(Object constraintParameter) {
        if (!(constraintParameter instanceof Integer)) {
            throw new IllegalArgumentException("Parameter for constraint [minSize] of property [" + this.constraintPropertyName + "] of class [" + this.constraintOwningClass + "] must be a of type [java.lang.Integer]");
        }
        this.minSize = (Integer)constraintParameter;
        super.setParameter(constraintParameter);
    }

    public String getName() {
        return "minSize";
    }

    public boolean supports(Class type) {
        return type != null && (String.class.isAssignableFrom(type) || Collection.class.isAssignableFrom(type) || type.isArray());
    }

    protected void processValidate(Object target, Object propertyValue, Errors errors) {
        Object[] args = new Object[]{this.constraintPropertyName, this.constraintOwningClass, propertyValue, new Integer(this.minSize)};
        if (propertyValue.getClass().isArray()) {
            int length = Array.getLength(propertyValue);
            if (length < this.minSize) {
                super.rejectValue(target, errors, "default.invalid.min.size.message", "minSize.notmet", args);
            }
        } else if (propertyValue instanceof Collection) {
            if (((Collection)propertyValue).size() < this.minSize) {
                super.rejectValue(target, errors, "default.invalid.min.size.message", "minSize.notmet", args);
            }
        } else if (propertyValue instanceof String && ((String)propertyValue).length() < this.minSize) {
            super.rejectValue(target, errors, "default.invalid.min.size.message", "minSize.notmet", args);
        }
    }
}

