/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.validation;

import org.codehaus.groovy.grails.validation.AbstractVetoingConstraint;
import org.springframework.validation.Errors;

class NullableConstraint
extends AbstractVetoingConstraint {
    private boolean nullable;

    NullableConstraint() {
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public boolean supports(Class type) {
        return type != null && !type.isPrimitive();
    }

    public void setParameter(Object constraintParameter) {
        if (!(constraintParameter instanceof Boolean)) {
            throw new IllegalArgumentException("Parameter for constraint [nullable] of property [" + this.constraintPropertyName + "] of class [" + this.constraintOwningClass + "] must be a boolean value");
        }
        this.nullable = (Boolean)constraintParameter;
        super.setParameter(constraintParameter);
    }

    public String getName() {
        return "nullable";
    }

    protected boolean skipNullValues() {
        return false;
    }

    protected boolean processValidateWithVetoing(Object target, Object propertyValue, Errors errors) {
        if (propertyValue == null && !this.nullable) {
            Object[] args = new Object[]{this.constraintPropertyName, this.constraintOwningClass};
            super.rejectValue(target, errors, "default.null.message", "nullable", args);
            return true;
        }
        return false;
    }
}

