/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.commons;

import grails.util.GrailsNameUtils;
import grails.util.GrailsUtil;
import grails.web.Action;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.MetaProperty;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.StringUtils;
import org.codehaus.groovy.grails.commons.ClassPropertyFetcher;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.GrailsClass;
import org.codehaus.groovy.grails.commons.GrailsClassUtils;
import org.codehaus.groovy.grails.commons.GrailsMetaClassUtils;
import org.codehaus.groovy.grails.exceptions.NewInstanceCreationException;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public abstract class AbstractGrailsClass
implements GrailsClass {
    private final Class<?> clazz;
    private BeanWrapper reference;
    private final String fullName;
    private final String name;
    private final String packageName;
    private final String naturalName;
    private final String shortName;
    private final String propertyName;
    private final String logicalPropertyName;
    private final ClassPropertyFetcher classPropertyFetcher;
    protected GrailsApplication grailsApplication;
    private boolean isAbstract;

    public AbstractGrailsClass(Class<?> clazz, String trailingName) {
        Assert.notNull(clazz, (String)"Clazz parameter should not be null");
        this.clazz = clazz;
        this.fullName = clazz.getName();
        this.packageName = ClassUtils.getPackageName(clazz);
        this.naturalName = GrailsNameUtils.getNaturalName((String)clazz.getName());
        this.shortName = ClassUtils.getShortClassName(clazz);
        this.name = GrailsNameUtils.getLogicalName(clazz, (String)trailingName);
        this.propertyName = GrailsNameUtils.getPropertyNameRepresentation((String)this.shortName);
        this.logicalPropertyName = StringUtils.isBlank((String)this.name) ? this.propertyName : GrailsNameUtils.getPropertyNameRepresentation((String)this.name);
        this.classPropertyFetcher = ClassPropertyFetcher.forClass(clazz);
        this.isAbstract = Modifier.isAbstract(clazz.getModifiers());
    }

    @Override
    public void setGrailsApplication(GrailsApplication grailsApplication) {
        this.grailsApplication = grailsApplication;
    }

    @Override
    public GrailsApplication getGrailsApplication() {
        return this.grailsApplication;
    }

    @Override
    public String getShortName() {
        return this.shortName;
    }

    @Override
    public Class<?> getClazz() {
        return this.clazz;
    }

    @Override
    public Object newInstance() {
        try {
            Constructor<?> defaultConstructor = this.getClazz().getDeclaredConstructor(new Class[0]);
            if (!defaultConstructor.isAccessible()) {
                defaultConstructor.setAccessible(true);
            }
            return defaultConstructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            Throwable targetException = null;
            targetException = e instanceof InvocationTargetException ? ((InvocationTargetException)e).getTargetException() : e;
            throw new NewInstanceCreationException("Could not create a new instance of class [" + this.getClazz().getName() + "]!", targetException);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getNaturalName() {
        return this.naturalName;
    }

    @Override
    public String getFullName() {
        return this.fullName;
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public String getLogicalPropertyName() {
        return this.logicalPropertyName;
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    public Object getReferenceInstance() {
        Object obj = this.classPropertyFetcher.getReference();
        if (obj instanceof GroovyObject) {
            ((GroovyObject)obj).setMetaClass(this.getMetaClass());
        }
        return obj;
    }

    public PropertyDescriptor[] getPropertyDescriptors() {
        return this.classPropertyFetcher.getPropertyDescriptors();
    }

    public Class<?> getPropertyType(String typeName) {
        return this.classPropertyFetcher.getPropertyType(typeName);
    }

    public boolean isReadableProperty(String propName) {
        return this.classPropertyFetcher.isReadableProperty(propName);
    }

    public boolean isActionMethod(String methodName) {
        Method m = ReflectionUtils.findMethod(this.getClazz(), (String)methodName, (Class[])new Class[0]);
        if (m != null) {
            ReflectionUtils.makeAccessible((Method)m);
        }
        return m != null && m.getAnnotation(Action.class) != null;
    }

    public boolean hasMetaMethod(String methodName) {
        return this.hasMetaMethod(methodName, null);
    }

    public boolean hasMetaMethod(String methodName, Object[] args) {
        return this.getMetaClass().getMetaMethod(methodName, args) != null;
    }

    public boolean hasMetaProperty(String propName) {
        return this.getMetaClass().getMetaProperty(propName) != null;
    }

    @Override
    @Deprecated
    public BeanWrapper getReference() {
        GrailsUtil.deprecated(AbstractGrailsClass.class, "getReference");
        if (this.reference == null) {
            this.reference = new BeanWrapperImpl(this.newInstance());
        }
        return this.reference;
    }

    protected <T> T getPropertyOrStaticPropertyOrFieldValue(String name, Class<T> type) {
        Object value = this.classPropertyFetcher.getPropertyValue(name);
        return this.returnOnlyIfInstanceOf(value, type);
    }

    public <T> T getStaticPropertyValue(String propName, Class<T> type) {
        T value = this.classPropertyFetcher.getStaticPropertyValue(propName, type);
        if (value == null) {
            return this.getGroovyProperty(propName, type, true);
        }
        return value;
    }

    @Override
    public <T> T getPropertyValue(String propName, Class<T> type) {
        T value = this.classPropertyFetcher.getPropertyValue(propName, type);
        if (value == null) {
            return this.getGroovyProperty(propName, type, false);
        }
        return this.returnOnlyIfInstanceOf(value, type);
    }

    private <T> T getGroovyProperty(String propName, Class<T> type, boolean onlyStatic) {
        MetaProperty metaProperty;
        Object value = null;
        if (GroovyObject.class.isAssignableFrom(this.getClazz()) && (metaProperty = this.getMetaClass().getMetaProperty(propName)) != null) {
            int modifiers = metaProperty.getModifiers();
            if (Modifier.isStatic(modifiers)) {
                value = metaProperty.getProperty(this.clazz);
            } else if (!onlyStatic) {
                value = metaProperty.getProperty(this.getReferenceInstance());
            }
        }
        return this.returnOnlyIfInstanceOf(value, type);
    }

    public Object getPropertyValueObject(String propertyNAme) {
        return this.getPropertyValue(propertyNAme, Object.class);
    }

    private <T> T returnOnlyIfInstanceOf(Object value, Class<T> type) {
        if (value != null && (type == Object.class || GrailsClassUtils.isGroovyAssignableFrom(type, value.getClass()))) {
            return (T)value;
        }
        return null;
    }

    @Override
    public Object getPropertyValue(String propName) {
        return this.getPropertyOrStaticPropertyOrFieldValue(propName, Object.class);
    }

    @Override
    public boolean isAbstract() {
        return this.isAbstract;
    }

    @Override
    public boolean hasProperty(String propName) {
        return this.classPropertyFetcher.isReadableProperty(propName);
    }

    @Override
    public MetaClass getMetaClass() {
        return GrailsMetaClassUtils.getExpandoMetaClass(this.getClazz());
    }

    public String toString() {
        return "Artefact > " + this.getName();
    }
}

