/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.commons;

import grails.util.Environment;
import groovy.util.slurpersupport.GPathResult;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.ApplicationHolder;
import org.codehaus.groovy.grails.commons.DefaultGrailsApplication;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.compiler.GrailsClassLoader;
import org.codehaus.groovy.grails.compiler.support.GrailsResourceLoader;
import org.codehaus.groovy.grails.io.support.IOUtils;
import org.codehaus.groovy.grails.plugins.GrailsPluginUtils;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class GrailsApplicationFactoryBean
implements FactoryBean<GrailsApplication>,
InitializingBean {
    private static Log LOG = LogFactory.getLog(GrailsApplicationFactoryBean.class);
    private GrailsApplication grailsApplication = null;
    private Resource descriptor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterPropertiesSet() throws Exception {
        if (this.descriptor != null && this.descriptor.exists()) {
            LOG.info((Object)"Loading Grails application with information from descriptor.");
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            ArrayList classes = new ArrayList();
            InputStream inputStream = null;
            try {
                inputStream = this.descriptor.getInputStream();
                GPathResult root = IOUtils.createXmlSlurper().parse(inputStream);
                GPathResult resources = (GPathResult)root.getProperty("resources");
                GPathResult grailsClasses = (GPathResult)resources.getProperty("resource");
                for (int i = 0; i < grailsClasses.size(); ++i) {
                    GPathResult node = (GPathResult)grailsClasses.getAt(i);
                    String className = node.text();
                    try {
                        Class<?> clazz = classLoader instanceof GrailsClassLoader ? classLoader.loadClass(className) : Class.forName(className, true, classLoader);
                        classes.add(clazz);
                        continue;
                    }
                    catch (ClassNotFoundException e) {
                        LOG.warn((Object)("Class with name [" + className + "] was not found, and hence not loaded. Possible empty class or script definition?"));
                    }
                }
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            Class[] loadedClasses = classes.toArray(new Class[classes.size()]);
            this.grailsApplication = new DefaultGrailsApplication(loadedClasses, classLoader);
        } else if (!Environment.isWarDeployed()) {
            org.codehaus.groovy.grails.io.support.Resource[] buildResources = GrailsPluginUtils.getPluginBuildSettings().getArtefactResourcesForCurrentEnvironment();
            Resource[] resources = new Resource[buildResources.length];
            for (int i = 0; i < buildResources.length; ++i) {
                org.codehaus.groovy.grails.io.support.Resource buildResource = buildResources[i];
                resources[i] = new FileSystemResource(buildResource.getFile());
            }
            this.grailsApplication = new DefaultGrailsApplication(resources);
        } else {
            this.grailsApplication = new DefaultGrailsApplication();
        }
        ApplicationHolder.setApplication(this.grailsApplication);
    }

    public GrailsApplication getObject() {
        return this.grailsApplication;
    }

    public Class<GrailsApplication> getObjectType() {
        return GrailsApplication.class;
    }

    public boolean isSingleton() {
        return true;
    }

    @Deprecated
    public void setGrailsResourceLoader(GrailsResourceLoader resourceLoader) {
    }

    public void setGrailsDescriptor(Resource r) {
        this.descriptor = r;
    }
}

