/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.plugins;

import grails.util.GrailsNameUtils;
import groovy.lang.GroovyObjectSupport;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.grails.commons.AbstractGrailsClass;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.plugins.GrailsPlugin;
import org.codehaus.groovy.grails.plugins.GrailsPluginManager;
import org.codehaus.groovy.grails.plugins.support.WatchPattern;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.util.Assert;
import org.w3c.dom.Element;

public abstract class AbstractGrailsPlugin
extends GroovyObjectSupport
implements GrailsPlugin {
    protected GrailsApplication application;
    protected boolean isBase = false;
    protected String version = "1.0";
    protected Map<String, Object> dependencies = new HashMap<String, Object>();
    protected String[] dependencyNames = new String[0];
    protected Class<?> pluginClass;
    protected ApplicationContext applicationContext;
    protected GrailsPluginManager manager;
    protected String[] evictionList = new String[0];

    @Override
    public void refresh() {
    }

    public AbstractGrailsPlugin(Class<?> pluginClass, GrailsApplication application) {
        Assert.notNull(pluginClass, (String)"Argument [pluginClass] cannot be null");
        Assert.isTrue((boolean)pluginClass.getName().endsWith("GrailsPlugin"), (String)("Argument [pluginClass] with value [" + pluginClass + "] is not a Grails plugin (class name must end with 'GrailsPlugin')"));
        this.application = application;
        this.pluginClass = pluginClass;
    }

    @Override
    public String getFileSystemName() {
        return this.getFileSystemShortName() + '-' + this.getVersion();
    }

    @Override
    public String getFileSystemShortName() {
        return GrailsNameUtils.getScriptName((String)this.getName());
    }

    @Override
    public Class<?> getPluginClass() {
        return this.pluginClass;
    }

    @Override
    public boolean isBasePlugin() {
        return this.isBase;
    }

    @Override
    public void setBasePlugin(boolean isBase) {
        this.isBase = isBase;
    }

    @Override
    public List<WatchPattern> getWatchedResourcePatterns() {
        return Collections.emptyList();
    }

    @Override
    public boolean hasInterestInChange(String path) {
        return false;
    }

    @Override
    public boolean checkForChanges() {
        return false;
    }

    @Override
    public void doWithWebDescriptor(Element webXml) {
    }

    @Override
    public String[] getDependencyNames() {
        return this.dependencyNames;
    }

    @Override
    public String getDependentVersion(String name) {
        return null;
    }

    public String getName() {
        return this.pluginClass.getName();
    }

    public String getVersion() {
        return this.version;
    }

    @Override
    public String getPluginPath() {
        return "/plugins/" + GrailsNameUtils.getScriptName((String)this.getName()) + '-' + this.getVersion();
    }

    @Override
    public GrailsPluginManager getManager() {
        return this.manager;
    }

    @Override
    public String[] getLoadAfterNames() {
        return new String[0];
    }

    @Override
    public String[] getLoadBeforeNames() {
        return new String[0];
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public void setManager(GrailsPluginManager manager) {
        this.manager = manager;
    }

    @Override
    public void setApplication(GrailsApplication application) {
        this.application = application;
    }

    @Override
    public String[] getEvictionNames() {
        return this.evictionList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractGrailsPlugin)) {
            return false;
        }
        AbstractGrailsPlugin that = (AbstractGrailsPlugin)o;
        if (!this.pluginClass.equals(that.pluginClass)) {
            return false;
        }
        return this.version.equals(that.version);
    }

    public int hashCode() {
        int result = this.version.hashCode();
        result = 31 * result + this.pluginClass.hashCode();
        return result;
    }

    public int compareTo(Object o) {
        AbstractGrailsPlugin that = (AbstractGrailsPlugin)o;
        if (this.equals(that)) {
            return 0;
        }
        String thatName = that.getName();
        for (String pluginName : this.getLoadAfterNames()) {
            if (!pluginName.equals(thatName)) continue;
            return -1;
        }
        for (String pluginName : this.getLoadBeforeNames()) {
            if (!pluginName.equals(thatName)) continue;
            return 1;
        }
        for (String pluginName : that.getLoadAfterNames()) {
            if (!pluginName.equals(this.getName())) continue;
            return 1;
        }
        for (String pluginName : that.getLoadBeforeNames()) {
            if (!pluginName.equals(this.getName())) continue;
            return -1;
        }
        return 0;
    }

    class GrailsPluginClass
    extends AbstractGrailsClass {
        public GrailsPluginClass(Class<?> clazz) {
            super(clazz, "GrailsPlugin");
        }
    }
}

