/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.plugins;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.grails.plugins.GrailsPlugin;
import org.codehaus.groovy.grails.plugins.PluginFilter;

public abstract class BasePluginFilter
implements PluginFilter {
    private final Set<String> suppliedNames;
    private final List<GrailsPlugin> explicitlyNamedPlugins = new ArrayList<GrailsPlugin>();
    private final List<GrailsPlugin> derivedPlugins = new ArrayList<GrailsPlugin>();
    protected Map<String, GrailsPlugin> nameMap;
    private Set<String> addedNames;
    private List<GrailsPlugin> originalPlugins;

    public BasePluginFilter(Set<String> suppliedNames) {
        this.suppliedNames = suppliedNames;
    }

    public BasePluginFilter(String[] included) {
        this.suppliedNames = new HashSet<String>();
        for (int i = 0; i < included.length; ++i) {
            this.suppliedNames.add(included[i].trim());
        }
    }

    protected abstract void addPluginDependencies(List var1, GrailsPlugin var2);

    protected abstract List<GrailsPlugin> getPluginList(List var1, List var2);

    @Override
    public List<GrailsPlugin> filterPluginList(List<GrailsPlugin> original) {
        this.originalPlugins = Collections.unmodifiableList(original);
        this.addedNames = new HashSet<String>();
        this.buildNameMap();
        this.buildExplicitlyNamedList();
        this.buildDerivedPluginList();
        ArrayList<GrailsPlugin> pluginList = new ArrayList<GrailsPlugin>();
        pluginList.addAll(this.explicitlyNamedPlugins);
        pluginList.addAll(this.derivedPlugins);
        return this.getPluginList(this.originalPlugins, pluginList);
    }

    private void buildDerivedPluginList() {
        for (int i = 0; i < this.explicitlyNamedPlugins.size(); ++i) {
            GrailsPlugin plugin = this.explicitlyNamedPlugins.get(i);
            this.addPluginDependencies(this.derivedPlugins, plugin);
        }
    }

    protected boolean isDependentOn(GrailsPlugin plugin, String pluginName) {
        String[] dependencyNames = plugin.getDependencyNames();
        for (int i = 0; i < dependencyNames.length; ++i) {
            String dependencyName = dependencyNames[i];
            if (!pluginName.equals(dependencyName)) continue;
            return true;
        }
        return false;
    }

    private void buildExplicitlyNamedList() {
        for (GrailsPlugin plugin : this.originalPlugins) {
            String name = plugin.getName();
            if (!this.suppliedNames.contains(name)) continue;
            this.explicitlyNamedPlugins.add(plugin);
            this.addedNames.add(name);
        }
    }

    private void buildNameMap() {
        this.nameMap = new HashMap<String, GrailsPlugin>();
        for (GrailsPlugin plugin : this.originalPlugins) {
            this.nameMap.put(plugin.getName(), plugin);
        }
    }

    protected void registerDependency(List additionalList, GrailsPlugin plugin) {
        if (!this.addedNames.contains(plugin.getName())) {
            this.addedNames.add(plugin.getName());
            additionalList.add(plugin);
            this.addPluginDependencies(additionalList, plugin);
        }
    }

    protected Collection getAllPlugins() {
        return Collections.unmodifiableCollection(this.nameMap.values());
    }

    protected GrailsPlugin getNamedPlugin(String name) {
        return this.nameMap.get(name);
    }

    protected Set<String> getSuppliedNames() {
        return this.suppliedNames;
    }
}

