/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.commons;

import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import grails.util.Environment;
import org.codehaus.groovy.grails.commons.AbstractGrailsClass;
import org.codehaus.groovy.grails.commons.ArtefactHandlerAdapter;
import org.codehaus.groovy.grails.commons.ArtefactInfo;
import org.codehaus.groovy.grails.commons.DefaultGrailsControllerClass;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.GrailsClass;
import org.codehaus.groovy.grails.commons.GrailsControllerClass;
import org.codehaus.groovy.grails.plugins.GrailsPlugin;
import org.codehaus.groovy.grails.plugins.GrailsPluginManager;
import org.codehaus.groovy.grails.plugins.support.aware.GrailsApplicationAware;
import org.springframework.context.ApplicationContext;

public class ControllerArtefactHandler
extends ArtefactHandlerAdapter
implements GrailsApplicationAware {
    private static final String URL_MAPPING_CACHE_MAX_SIZE = "grails.urlmapping.cache.maxsize";
    private static final GrailsClass NO_CONTROLLER = new AbstractGrailsClass((Class)Object.class, "Controller"){};
    public static final String TYPE = "Controller";
    public static final String PLUGIN_NAME = "controllers";
    private ConcurrentLinkedHashMap<ControllerCacheKey, GrailsClass> uriToControllerClassCache;
    private ArtefactInfo artefactInfo;
    private GrailsApplication grailsApplication;

    public ControllerArtefactHandler() {
        super(TYPE, GrailsControllerClass.class, DefaultGrailsControllerClass.class, TYPE, false);
    }

    @Override
    public void initialize(ArtefactInfo artefacts) {
        Object cacheSize = this.grailsApplication.getFlatConfig().get(URL_MAPPING_CACHE_MAX_SIZE);
        if (cacheSize == null) {
            cacheSize = 10000;
        }
        this.uriToControllerClassCache = new ConcurrentLinkedHashMap.Builder().initialCapacity(500).maximumWeightedCapacity((long)new Integer(cacheSize.toString()).intValue()).build();
        this.artefactInfo = artefacts;
    }

    @Override
    public String getPluginName() {
        return PLUGIN_NAME;
    }

    @Override
    public GrailsClass getArtefactForFeature(Object featureId) {
        String uri;
        ControllerCacheKey cacheKey;
        if (this.artefactInfo == null) {
            return null;
        }
        String pluginName = null;
        String namespace = null;
        if (featureId instanceof ControllerCacheKey) {
            cacheKey = (ControllerCacheKey)featureId;
            pluginName = cacheKey.plugin;
            namespace = cacheKey.namespace;
            uri = cacheKey.uri;
        } else {
            uri = featureId.toString();
            cacheKey = new ControllerCacheKey(uri, null, null);
        }
        GrailsClass controllerClass = (GrailsClass)this.uriToControllerClassCache.get((Object)cacheKey);
        if (controllerClass == null) {
            Object pluginManagerBean;
            ApplicationContext mainContext = this.grailsApplication.getMainContext();
            GrailsPluginManager grailsPluginManager = null;
            if (mainContext.containsBean("pluginManager") && (pluginManagerBean = mainContext.getBean("pluginManager")) instanceof GrailsPluginManager) {
                grailsPluginManager = (GrailsPluginManager)pluginManagerBean;
            }
            GrailsClass[] controllerClasses = this.artefactInfo.getGrailsClasses();
            for (int i = controllerClasses.length - 1; i >= 0; --i) {
                boolean foundController;
                GrailsClass c = controllerClasses[i];
                if (!((GrailsControllerClass)c).mapsToURI(uri)) continue;
                boolean pluginMatches = false;
                boolean namespaceMatches = false;
                namespaceMatches = this.namespaceMatches((GrailsControllerClass)c, namespace);
                if (namespaceMatches) {
                    pluginMatches = this.pluginMatches(c, pluginName, grailsPluginManager);
                }
                boolean bl = foundController = pluginMatches && namespaceMatches;
                if (!foundController) continue;
                controllerClass = c;
                break;
            }
            if (controllerClass == null) {
                controllerClass = NO_CONTROLLER;
            }
            if (Environment.getCurrent() != Environment.DEVELOPMENT) {
                this.uriToControllerClassCache.put((Object)cacheKey, (Object)controllerClass);
            }
        }
        if (controllerClass == NO_CONTROLLER) {
            controllerClass = null;
        }
        return controllerClass;
    }

    protected boolean namespaceMatches(GrailsControllerClass c, String namespace) {
        boolean namespaceMatches = namespace != null ? namespace.equals(c.getNamespace()) : c.getNamespace() == null;
        return namespaceMatches;
    }

    protected boolean pluginMatches(GrailsClass c, String pluginName, GrailsPluginManager grailsPluginManager) {
        boolean pluginMatches = false;
        if (pluginName != null && grailsPluginManager != null) {
            GrailsPlugin pluginForClass = grailsPluginManager.getPluginForClass(c.getClazz());
            if (pluginForClass != null && pluginName.equals(pluginForClass.getName())) {
                pluginMatches = true;
            }
        } else {
            pluginMatches = true;
        }
        return pluginMatches;
    }

    @Override
    public void setGrailsApplication(GrailsApplication grailsApplication) {
        this.grailsApplication = grailsApplication;
    }

    public static class ControllerCacheKey {
        private String uri;
        private String plugin;
        private String namespace;

        public ControllerCacheKey(String uri, String plugin, String namespace) {
            this.uri = uri;
            this.plugin = plugin;
            this.namespace = namespace;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ControllerCacheKey that = (ControllerCacheKey)o;
            if (this.namespace != null ? !this.namespace.equals(that.namespace) : that.namespace != null) {
                return false;
            }
            if (this.plugin != null ? !this.plugin.equals(that.plugin) : that.plugin != null) {
                return false;
            }
            return this.uri.equals(that.uri);
        }

        public int hashCode() {
            int result = this.uri.hashCode();
            result = 31 * result + (this.plugin != null ? this.plugin.hashCode() : 0);
            result = 31 * result + (this.namespace != null ? this.namespace.hashCode() : 0);
            return result;
        }
    }
}

