/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.transaction;

import groovy.util.ConfigObject;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.groovy.grails.transaction.ChainedTransactionManager;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.Ordered;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.jta.JtaTransactionManager;
import org.springframework.util.ClassUtils;

public class ChainedTransactionManagerPostProcessor
implements BeanDefinitionRegistryPostProcessor,
Ordered {
    private static final String TRANSACTIONAL = "transactional";
    private static final String DEFAULT_TRANSACTION_MANAGER_BEAN_NAME_WHITELIST_PATTERN = "(?i).*transactionManager.*";
    private static final String DEFAULT_TRANSACTION_MANAGER_INTERNAL_BEAN_NAME_BLACKLIST_PATTERN = "(?i)chainedTransactionManagerPostProcessor|transactionManagerPostProcessor|.*PostProcessor";
    private String beanNameWhitelistPattern = "(?i).*transactionManager.*";
    private String beanNameBlacklistPattern = null;
    private String beanNameInternalBlacklistPattern = "(?i)chainedTransactionManagerPostProcessor|transactionManagerPostProcessor|.*PostProcessor";
    private static final Pattern SUFFIX_PATTERN = Pattern.compile("^transactionManager_(.+)$");
    private static final String PRIMARY_TRANSACTION_MANAGER = "$primaryTransactionManager";
    private static final String TRANSACTION_MANAGER = "transactionManager";
    private ConfigObject config;

    public ChainedTransactionManagerPostProcessor(ConfigObject config) {
        this(config, null, null);
    }

    public ChainedTransactionManagerPostProcessor(ConfigObject config, String whitelistPattern, String blacklistPattern) {
        this.config = config;
        if (whitelistPattern != null) {
            this.beanNameWhitelistPattern = whitelistPattern;
        }
        if (blacklistPattern != null) {
            this.beanNameBlacklistPattern = blacklistPattern;
        }
    }

    public ChainedTransactionManagerPostProcessor() {
        this(new ConfigObject(), null, null);
    }

    protected Map<String, ConfigObject> readDataSourceConfig() {
        LinkedHashMap<String, ConfigObject> dsConfigs = new LinkedHashMap<String, ConfigObject>();
        if (this.config != null) {
            if (this.config.containsKey((Object)"dataSource")) {
                dsConfigs.put("", (ConfigObject)this.config.get((Object)"dataSource"));
            }
            for (Map.Entry entry : this.config.entrySet()) {
                String name = String.valueOf(entry.getKey());
                if (!name.startsWith("dataSource_") || !(entry.getValue() instanceof ConfigObject)) continue;
                dsConfigs.put(name.substring("dataSource_".length()), (ConfigObject)entry.getValue());
            }
        }
        return dsConfigs;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        if (beanFactory.containsBean(TRANSACTION_MANAGER) && beanFactory.isTypeMatch(TRANSACTION_MANAGER, ChainedTransactionManager.class)) {
            this.registerAdditionalTransactionManagers(beanFactory);
        }
    }

    protected void registerAdditionalTransactionManagers(ConfigurableListableBeanFactory beanFactory) {
        String[] beanNames = BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)beanFactory, PlatformTransactionManager.class, (boolean)false, (boolean)false);
        ArrayList<Object> additionalTransactionManagers = new ArrayList<Object>();
        Map<String, ConfigObject> dsConfigs = this.readDataSourceConfig();
        for (String beanName : beanNames) {
            String suffix;
            if (TRANSACTION_MANAGER.equals(beanName) || PRIMARY_TRANSACTION_MANAGER.equals(beanName) || !this.isValidTransactionManagerBeanName(beanName) || this.isNotTransactional(dsConfigs, suffix = this.resolveDataSourceSuffix(beanName))) continue;
            additionalTransactionManagers.add(beanFactory.getBean(beanName, PlatformTransactionManager.class));
        }
        ChainedTransactionManager chainedTransactionManager = (ChainedTransactionManager)beanFactory.getBean(TRANSACTION_MANAGER, ChainedTransactionManager.class);
        chainedTransactionManager.getTransactionManagers().addAll(additionalTransactionManagers);
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        if (registry.containsBeanDefinition(TRANSACTION_MANAGER) && this.countChainableTransactionManagerBeans(registry) > 1 && !this.hasJtaTransactionManager(registry)) {
            this.addChainedTransactionManager(registry);
        }
    }

    protected void addChainedTransactionManager(BeanDefinitionRegistry registry) {
        ChainedTransactionManagerPostProcessor.renameBean(TRANSACTION_MANAGER, PRIMARY_TRANSACTION_MANAGER, registry);
        RootBeanDefinition beanDefinition = new RootBeanDefinition(ChainedTransactionManager.class);
        ConstructorArgumentValues constructorValues = beanDefinition.getConstructorArgumentValues();
        constructorValues.addIndexedArgumentValue(0, (Object)new RuntimeBeanReference(PRIMARY_TRANSACTION_MANAGER));
        registry.registerBeanDefinition(TRANSACTION_MANAGER, (BeanDefinition)beanDefinition);
    }

    protected boolean hasJtaTransactionManager(BeanDefinitionRegistry registry) {
        if (!registry.containsBeanDefinition(TRANSACTION_MANAGER)) {
            return false;
        }
        BeanDefinition transactionManagerBeanDefinition = registry.getBeanDefinition(TRANSACTION_MANAGER);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Class transactionManagerBeanClass = ClassUtils.resolveClassName((String)transactionManagerBeanDefinition.getBeanClassName(), (ClassLoader)classLoader);
        boolean isJtaTransactionManager = JtaTransactionManager.class.isAssignableFrom(transactionManagerBeanClass);
        return isJtaTransactionManager;
    }

    protected int countChainableTransactionManagerBeans(BeanDefinitionRegistry registry) {
        Map<String, ConfigObject> dsConfigs = this.readDataSourceConfig();
        int transactionManagerBeanCount = 0;
        for (String beanName : registry.getBeanDefinitionNames()) {
            if (!this.isValidTransactionManagerBeanName(beanName)) continue;
            String suffix = this.resolveDataSourceSuffix(beanName);
            if (!beanName.equals(TRANSACTION_MANAGER) && this.isNotTransactional(dsConfigs, suffix)) continue;
            ++transactionManagerBeanCount;
        }
        return transactionManagerBeanCount;
    }

    protected boolean isValidTransactionManagerBeanName(String beanName) {
        return beanName.matches(this.beanNameWhitelistPattern) && (this.beanNameBlacklistPattern == null || !beanName.matches(this.beanNameBlacklistPattern)) && !beanName.matches(this.beanNameInternalBlacklistPattern);
    }

    protected boolean isNotTransactional(Map<String, ConfigObject> dsConfigs, String suffix) {
        Object transactionalValue;
        if (suffix == null) {
            return false;
        }
        ConfigObject dsConfig = dsConfigs.get(suffix);
        if (dsConfig != null && dsConfig.containsKey((Object)TRANSACTIONAL) && (transactionalValue = dsConfig.get((Object)TRANSACTIONAL)) instanceof Boolean) {
            return (Boolean)transactionalValue == false;
        }
        return false;
    }

    protected String resolveDataSourceSuffix(String transactionManagerBeanName) {
        if (TRANSACTION_MANAGER.equals(transactionManagerBeanName)) {
            return "";
        }
        Matcher matcher = SUFFIX_PATTERN.matcher(transactionManagerBeanName);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }

    private static boolean renameBean(String oldName, String newName, BeanDefinitionRegistry registry) {
        if (!registry.containsBeanDefinition(oldName)) {
            return false;
        }
        LinkedHashSet<String> previousChildBeans = new LinkedHashSet<String>();
        for (String bdName : registry.getBeanDefinitionNames()) {
            BeanDefinition bd;
            if (oldName.equals(bdName) || !oldName.equals((bd = registry.getBeanDefinition(bdName)).getParentName())) continue;
            bd.setParentName(null);
            previousChildBeans.add(bdName);
        }
        BeanDefinition oldBeanDefinition = registry.getBeanDefinition(oldName);
        registry.removeBeanDefinition(oldName);
        registry.registerBeanDefinition(newName, oldBeanDefinition);
        for (String bdName : previousChildBeans) {
            BeanDefinition bd = registry.getBeanDefinition(bdName);
            bd.setParentName(newName);
        }
        return true;
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public void setConfig(ConfigObject config) {
        this.config = config;
    }

    public String getBeanNameWhitelistPattern() {
        return this.beanNameWhitelistPattern;
    }

    public void setBeanNameWhitelistPattern(String beanNameWhitelistPattern) {
        this.beanNameWhitelistPattern = beanNameWhitelistPattern;
    }

    public String getBeanNameBlacklistPattern() {
        return this.beanNameBlacklistPattern;
    }

    public void setBeanNameBlacklistPattern(String beanNameBlacklistPattern) {
        this.beanNameBlacklistPattern = beanNameBlacklistPattern;
    }

    public String getBeanNameInternalBlacklistPattern() {
        return this.beanNameInternalBlacklistPattern;
    }

    public void setBeanNameInternalBlacklistPattern(String beanNameInternalBlacklistPattern) {
        this.beanNameInternalBlacklistPattern = beanNameInternalBlacklistPattern;
    }
}

