/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.validation;

import java.math.BigDecimal;
import org.codehaus.groovy.grails.commons.GrailsClassUtils;
import org.codehaus.groovy.grails.validation.AbstractConstraint;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.validation.Errors;

public class ScaleConstraint
extends AbstractConstraint {
    private int scale;

    @Override
    public boolean supports(Class type) {
        return type != null && (BigDecimal.class.isAssignableFrom(type) || GrailsClassUtils.isAssignableOrConvertibleFrom(Float.class, type) || GrailsClassUtils.isAssignableOrConvertibleFrom(Double.class, type));
    }

    @Override
    public String getName() {
        return "scale";
    }

    public int getScale() {
        return this.scale;
    }

    @Override
    public void setParameter(Object constraintParameter) {
        if (!(constraintParameter instanceof Integer)) {
            throw new IllegalArgumentException("Parameter for constraint [" + this.getName() + "] of property [" + this.constraintPropertyName + "] of class [" + this.constraintOwningClass + "] must be a of type [java.lang.Integer]");
        }
        int requestedScale = (Integer)constraintParameter;
        if (requestedScale < 0) {
            throw new IllegalArgumentException("Parameter for constraint [" + this.getName() + "] of property [" + this.constraintPropertyName + "] of class [" + this.constraintOwningClass + "] must have a nonnegative value");
        }
        this.scale = requestedScale;
        super.setParameter(constraintParameter);
    }

    @Override
    protected void processValidate(Object target, Object propertyValue, Errors errors) {
        BeanWrapperImpl bean = new BeanWrapperImpl(target);
        if (propertyValue instanceof Float) {
            BigDecimal bigDecimal = new BigDecimal(propertyValue.toString());
            bigDecimal = this.getScaledValue(bigDecimal);
            bean.setPropertyValue(this.getPropertyName(), (Object)Float.valueOf(bigDecimal.floatValue()));
        } else if (propertyValue instanceof Double) {
            BigDecimal bigDecimal = new BigDecimal(propertyValue.toString());
            bigDecimal = this.getScaledValue(bigDecimal);
            bean.setPropertyValue(this.getPropertyName(), (Object)bigDecimal.doubleValue());
        } else if (propertyValue instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)propertyValue;
            bigDecimal = this.getScaledValue(bigDecimal);
            bean.setPropertyValue(this.getPropertyName(), (Object)bigDecimal);
        } else {
            throw new IllegalArgumentException("Unsupported type detected in constraint [" + this.getName() + "] of property [" + this.constraintPropertyName + "] of class [" + this.constraintOwningClass + "]");
        }
    }

    private BigDecimal getScaledValue(BigDecimal originalValue) {
        return originalValue.setScale(this.scale, 4);
    }
}

