/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.compiler.injection;

import grails.artefact.Artefact;
import grails.build.logging.GrailsConsole;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.GStringExpression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.TernaryExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.classgen.GeneratorContext;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.grails.compiler.injection.AstTransformer;
import org.codehaus.groovy.grails.compiler.injection.GrailsASTUtils;
import org.codehaus.groovy.grails.compiler.injection.GrailsArtefactClassInjector;
import org.codehaus.groovy.grails.compiler.injection.GrailsDomainClassInjector;
import org.codehaus.groovy.grails.io.support.GrailsResourceUtils;

@AstTransformer
public class DefaultGrailsDomainClassInjector
implements GrailsDomainClassInjector,
GrailsArtefactClassInjector {
    private List<ClassNode> classesWithInjectedToString = new ArrayList<ClassNode>();

    @Override
    public void performInjection(SourceUnit source, GeneratorContext context, ClassNode classNode) {
        if (GrailsASTUtils.isDomainClass(classNode, source) && this.shouldInjectClass(classNode)) {
            if (!classNode.getAnnotations(new ClassNode(Artefact.class)).isEmpty()) {
                return;
            }
            this.performInjectionOnAnnotatedEntity(classNode);
        }
    }

    @Override
    public void performInjectionOnAnnotatedEntity(ClassNode classNode) {
        this.injectIdProperty(classNode);
        this.injectVersionProperty(classNode);
        this.injectToStringMethod(classNode);
        this.injectAssociations(classNode);
    }

    @Override
    public boolean shouldInject(URL url) {
        return GrailsResourceUtils.isDomainClass((URL)url);
    }

    protected boolean shouldInjectClass(ClassNode classNode) {
        String fullName = GrailsASTUtils.getFullName(classNode);
        String mappingFile = this.getMappingFileName(fullName);
        if (this.getClass().getResource(mappingFile) != null) {
            return false;
        }
        return !this.isEnum(classNode);
    }

    private String getMappingFileName(String className) {
        return className.replaceAll("\\.", "/") + ".hbm.xml";
    }

    private void injectAssociations(ClassNode classNode) {
        ArrayList<PropertyNode> propertiesToAdd = new ArrayList<PropertyNode>();
        for (PropertyNode propertyNode : classNode.getProperties()) {
            boolean isBelongsToOrHasOne;
            boolean isHasManyProperty;
            String name = propertyNode.getName();
            boolean bl = isHasManyProperty = name.equals("relatesToMany") || name.equals("hasMany");
            if (isHasManyProperty) {
                Expression e = propertyNode.getInitialExpression();
                propertiesToAdd.addAll(this.createPropertiesForHasManyExpression(e, classNode));
            }
            if (!(isBelongsToOrHasOne = name.equals("belongsTo") || name.equals("hasOne"))) continue;
            Expression initialExpression = propertyNode.getInitialExpression();
            if (!(initialExpression instanceof MapExpression) && !(initialExpression instanceof ClassExpression)) {
                String message;
                if (name.equals("hasOne")) {
                    message = "The hasOne property in class [" + classNode.getName() + "] should have an initial expression of type Map or Class.";
                    GrailsConsole.getInstance().warn(message);
                } else if (!(initialExpression instanceof ListExpression)) {
                    message = "The belongsTo property in class [" + classNode.getName() + "] should have an initial expression of type List, Map or Class.";
                    GrailsConsole.getInstance().warn(message);
                }
            }
            propertiesToAdd.addAll(this.createPropertiesForBelongsToOrHasOneExpression(initialExpression, classNode));
        }
        this.injectAssociationProperties(classNode, propertiesToAdd);
    }

    private Collection<PropertyNode> createPropertiesForBelongsToOrHasOneExpression(Expression e, ClassNode classNode) {
        ArrayList<PropertyNode> properties = new ArrayList<PropertyNode>();
        if (e instanceof MapExpression) {
            MapExpression me = (MapExpression)e;
            for (MapEntryExpression mme : me.getMapEntryExpressions()) {
                String key = mme.getKeyExpression().getText();
                Expression expression = mme.getValueExpression();
                ClassNode type = expression instanceof ClassExpression ? expression.getType() : ClassHelper.make((String)expression.getText());
                properties.add(new PropertyNode(key, 1, type, classNode, null, null, null));
            }
        }
        return properties;
    }

    private void injectAssociationProperties(ClassNode classNode, List<PropertyNode> propertiesToAdd) {
        for (PropertyNode pn : propertiesToAdd) {
            if (GrailsASTUtils.hasProperty(classNode, pn.getName())) continue;
            classNode.addProperty(pn);
        }
    }

    private List<PropertyNode> createPropertiesForHasManyExpression(Expression e, ClassNode classNode) {
        ArrayList<PropertyNode> properties = new ArrayList<PropertyNode>();
        if (e instanceof MapExpression) {
            MapExpression me = (MapExpression)e;
            for (MapEntryExpression mee : me.getMapEntryExpressions()) {
                String key = mee.getKeyExpression().getText();
                this.addAssociationForKey(key, properties, classNode, this.findPropertyType(mee.getValueExpression()));
            }
        }
        return properties;
    }

    private ClassNode findPropertyType(Expression expression) {
        ClassNode setNode = ClassHelper.make(Set.class).getPlainNodeReference();
        if (expression instanceof ClassExpression) {
            GenericsType[] genericsTypes = new GenericsType[]{new GenericsType(GrailsASTUtils.nonGeneric(expression.getType()))};
            setNode.setGenericsTypes(genericsTypes);
        }
        return setNode;
    }

    private void addAssociationForKey(String key, List<PropertyNode> properties, ClassNode declaringType, ClassNode propertyType) {
        properties.add(new PropertyNode(key, 1, propertyType, declaringType, null, null, null));
    }

    private void injectToStringMethod(ClassNode classNode) {
        boolean hasToString = GrailsASTUtils.implementsOrInheritsZeroArgMethod(classNode, "toString", this.classesWithInjectedToString);
        if (!hasToString && !this.isEnum(classNode)) {
            GStringExpression ge = new GStringExpression(classNode.getName() + " : ${id ? id : '(unsaved)'}");
            ge.addString(new ConstantExpression((Object)(classNode.getName() + " : ")));
            VariableExpression idVariable = new VariableExpression("id");
            ge.addValue((Expression)new TernaryExpression(new BooleanExpression((Expression)idVariable), (Expression)idVariable, (Expression)new ConstantExpression((Object)"(unsaved)")));
            ReturnStatement s = new ReturnStatement((Expression)ge);
            MethodNode mn = new MethodNode("toString", 1, new ClassNode(String.class), new Parameter[0], new ClassNode[0], (Statement)s);
            classNode.addMethod(mn);
            this.classesWithInjectedToString.add(classNode);
        }
    }

    private boolean isEnum(ClassNode classNode) {
        for (ClassNode parent = classNode.getSuperClass(); parent != null; parent = parent.getSuperClass()) {
            if (!parent.getName().equals("java.lang.Enum")) continue;
            return true;
        }
        return false;
    }

    private void injectVersionProperty(ClassNode classNode) {
        boolean hasVersion = GrailsASTUtils.hasOrInheritsProperty(classNode, "version");
        if (!hasVersion) {
            ClassNode parent = GrailsASTUtils.getFurthestUnresolvedParent(classNode);
            parent.addProperty("version", 1, new ClassNode(Long.class), null, null, null);
        }
    }

    private void injectIdProperty(ClassNode classNode) {
        boolean hasId = GrailsASTUtils.hasOrInheritsProperty(classNode, "id");
        if (!hasId) {
            ClassNode parent = GrailsASTUtils.getFurthestUnresolvedParent(classNode);
            parent.addProperty("id", 1, new ClassNode(Long.class), null, null, null);
        }
    }

    @Override
    public void performInjection(SourceUnit source, ClassNode classNode) {
        this.performInjection(source, null, classNode);
    }

    @Override
    public void performInjectionOnAnnotatedClass(SourceUnit source, ClassNode classNode) {
        this.performInjectionOnAnnotatedEntity(classNode);
    }

    @Override
    public String[] getArtefactTypes() {
        return new String[]{"Domain"};
    }
}

