/*
 * Decompiled with CFR 0.152.
 */
package grails.util;

import grails.config.Config;
import grails.core.GrailsApplication;
import grails.plugins.GrailsPluginManager;
import grails.util.Holder;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.grails.core.io.support.GrailsFactoriesLoader;
import org.grails.core.support.GrailsApplicationDiscoveryStrategy;
import org.springframework.context.ApplicationContext;
import org.springframework.context.Lifecycle;
import org.springframework.util.Assert;

public class Holders {
    private static final Log LOG = LogFactory.getLog(Holders.class);
    private static Holder<GrailsPluginManager> pluginManagers = new Holder("PluginManager");
    private static Holder<Boolean> pluginManagersInCreation = new Holder("PluginManagers in creation");
    private static Holder<Config> configs = new Holder("config");
    private static Holder<Map<?, ?>> flatConfigs = new Holder("flat config");
    private static List<GrailsApplicationDiscoveryStrategy> applicationDiscoveryStrategies = GrailsFactoriesLoader.loadFactories(GrailsApplicationDiscoveryStrategy.class, Holders.class.getClassLoader());
    private static Holder servletContexts;
    private static GrailsApplication applicationSingleton;

    private Holders() {
    }

    public static void addApplicationDiscoveryStrategy(GrailsApplicationDiscoveryStrategy strategy) {
        applicationDiscoveryStrategies.add(strategy);
    }

    public static void clear() {
        pluginManagers.set(null);
        pluginManagersInCreation.set(null);
        configs.set(null);
        flatConfigs.set(null);
        if (servletContexts != null) {
            servletContexts.set(null);
        }
        applicationDiscoveryStrategies.clear();
        applicationSingleton = null;
    }

    public static void setServletContext(Object servletContext) {
        servletContexts.set(servletContext);
    }

    public static Object getServletContext() {
        return Holders.get(servletContexts, "servletContext");
    }

    public static ApplicationContext getApplicationContext() {
        for (GrailsApplicationDiscoveryStrategy strategy : applicationDiscoveryStrategies) {
            boolean running;
            ApplicationContext applicationContext = strategy.findApplicationContext();
            if (applicationContext == null || !(running = ((Lifecycle)applicationContext).isRunning())) continue;
            return applicationContext;
        }
        throw new IllegalStateException("Could not find ApplicationContext, configure Grails correctly first");
    }

    public static ApplicationContext findApplicationContext() {
        for (GrailsApplicationDiscoveryStrategy strategy : applicationDiscoveryStrategies) {
            ApplicationContext applicationContext = strategy.findApplicationContext();
            if (applicationContext == null) continue;
            return applicationContext;
        }
        return null;
    }

    public static GrailsApplication findApplication() {
        for (GrailsApplicationDiscoveryStrategy strategy : applicationDiscoveryStrategies) {
            GrailsApplication grailsApplication = strategy.findGrailsApplication();
            if (grailsApplication == null) continue;
            return grailsApplication;
        }
        return applicationSingleton;
    }

    public static GrailsApplication getGrailsApplication() {
        GrailsApplication grailsApplication = Holders.findApplication();
        Assert.notNull((Object)grailsApplication, (String)"GrailsApplication not found");
        return grailsApplication;
    }

    public static void setGrailsApplication(GrailsApplication application) {
        applicationSingleton = application;
    }

    public static void setConfig(Config config) {
        configs.set((Object)config);
        flatConfigs.set(config == null ? null : config.flatten());
    }

    public static Config getConfig() {
        return Holders.get(configs, "config");
    }

    public static Map<?, ?> getFlatConfig() {
        Map<?, ?> flatConfig = Holders.get(flatConfigs, "flatConfig");
        return flatConfig == null ? Collections.emptyMap() : flatConfig;
    }

    public static void setPluginManagerInCreation(boolean inCreation) {
        pluginManagersInCreation.set((Object)inCreation);
    }

    public static void setPluginManager(GrailsPluginManager pluginManager) {
        if (pluginManager != null) {
            pluginManagersInCreation.set((Object)false);
        }
        pluginManagers.set((Object)pluginManager);
    }

    public static GrailsPluginManager getPluginManager() {
        return Holders.getPluginManager(false);
    }

    public static GrailsPluginManager getPluginManager(boolean mappedOnly) {
        while (true) {
            Boolean inCreation;
            if ((inCreation = Holders.get(pluginManagersInCreation, "PluginManager in creation", mappedOnly)) == null) {
                inCreation = false;
            }
            if (!inCreation.booleanValue()) break;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                break;
            }
        }
        return Holders.get(pluginManagers, "PluginManager", mappedOnly);
    }

    public static GrailsPluginManager currentPluginManager() {
        GrailsPluginManager current = Holders.getPluginManager();
        Assert.notNull((Object)current, (String)"No PluginManager set");
        return current;
    }

    public static void reset() {
        Holders.setPluginManager(null);
        Holders.setGrailsApplication(null);
        Holders.setServletContext(null);
        Holders.setPluginManager(null);
        Holders.setPluginManagerInCreation(false);
        Holders.setConfig(null);
    }

    private static <T> T get(Holder<T> holder, String type) {
        return Holders.get(holder, type, false);
    }

    private static <T> T get(Holder<T> holder, String type, boolean mappedOnly) {
        return (T)holder.get(mappedOnly);
    }

    private static void createServletContextsHolder() {
        try {
            Class<?> clazz = Holders.class.getClassLoader().loadClass("grails.web.context.WebRequestServletHolder");
            servletContexts = (Holder)clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            LOG.debug((Object)("Error initializing servlet context holder, not running in Servlet environment: " + e.getMessage()), (Throwable)e);
        }
        catch (InstantiationException e) {
            LOG.debug((Object)("Error initializing servlet context holder, not running in Servlet environment: " + e.getMessage()), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOG.debug((Object)("Error initializing servlet context holder, not running in Servlet environment: " + e.getMessage()), (Throwable)e);
        }
    }

    static {
        Holders.createServletContextsHolder();
    }
}

