/*
 * Decompiled with CFR 0.152.
 */
package org.grails.config;

import grails.config.Config;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class PrefixedConfig
implements Config {
    protected String prefix;
    protected String[] prefixTokens;
    protected Config delegate;

    public PrefixedConfig(String prefix, Config delegate) {
        this.prefix = prefix;
        this.prefixTokens = prefix.split("\\.");
        this.delegate = delegate;
    }

    @Override
    public Map<String, Object> flatten() {
        Map<String, Object> flattened = this.delegate.flatten();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(flattened.size());
        for (String key : flattened.keySet()) {
            map.put(this.formulateKey(key), flattened.get(key));
        }
        return map;
    }

    @Override
    public Properties toProperties() {
        Map<String, Object> flattened = this.flatten();
        Properties properties = new Properties();
        properties.putAll(flattened);
        return properties;
    }

    public Object getAt(Object key) {
        return this.get(key);
    }

    public Object navigate(String ... path) {
        ArrayList<String> tokens = new ArrayList<String>();
        tokens.addAll(Arrays.asList(this.prefixTokens));
        tokens.addAll(Arrays.asList(path));
        return this.delegate.navigate(tokens.toArray(new String[tokens.size()]));
    }

    public Iterator<Map.Entry<String, Object>> iterator() {
        return this.entrySet().iterator();
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.containsProperty(key.toString());
    }

    public boolean containsValue(Object value) {
        return this.values().contains(value);
    }

    public Object get(Object key) {
        return this.getProperty(key.toString(), Object.class);
    }

    public Set<String> keySet() {
        Set keys = this.delegate.keySet();
        HashSet<String> newKeys = new HashSet<String>();
        for (String key : keys) {
            newKeys.add(this.formulateKey(key));
        }
        return newKeys;
    }

    public Collection<Object> values() {
        return this.delegate.values();
    }

    public Set<Map.Entry<String, Object>> entrySet() {
        Set entries = this.delegate.entrySet();
        HashSet<Map.Entry<String, Object>> newEntries = new HashSet<Map.Entry<String, Object>>();
        for (final Map.Entry entry : entries) {
            newEntries.add(new Map.Entry<String, Object>(){

                @Override
                public String getKey() {
                    return PrefixedConfig.this.formulateKey((String)entry.getKey());
                }

                @Override
                public Object getValue() {
                    return entry.getValue();
                }

                @Override
                public Object setValue(Object value) {
                    return entry.setValue(value);
                }
            });
        }
        return newEntries;
    }

    public boolean containsProperty(String key) {
        return this.delegate.containsProperty(this.formulateKey(key));
    }

    public String getProperty(String key) {
        return this.delegate.getProperty(this.formulateKey(key));
    }

    public String getProperty(String key, String defaultValue) {
        return this.delegate.getProperty(this.formulateKey(key), defaultValue);
    }

    public <T> T getProperty(String key, Class<T> targetType) {
        return (T)this.delegate.getProperty(this.formulateKey(key), targetType);
    }

    public <T> T getProperty(String key, Class<T> targetType, T defaultValue) {
        return (T)this.delegate.getProperty(this.formulateKey(key), targetType, defaultValue);
    }

    public <T> Class<T> getPropertyAsClass(String key, Class<T> targetType) {
        return this.delegate.getPropertyAsClass(this.formulateKey(key), targetType);
    }

    public String getRequiredProperty(String key) throws IllegalStateException {
        return this.delegate.getRequiredProperty(this.formulateKey(key));
    }

    public <T> T getRequiredProperty(String key, Class<T> targetType) throws IllegalStateException {
        return (T)this.delegate.getRequiredProperty(this.formulateKey(key), targetType);
    }

    protected String formulateKey(String key) {
        return this.prefix + '.' + key;
    }

    public String resolvePlaceholders(String text) {
        throw new UnsupportedOperationException("Resolving placeholders not supported");
    }

    public String resolveRequiredPlaceholders(String text) throws IllegalArgumentException {
        throw new UnsupportedOperationException("Resolving placeholders not supported");
    }

    public Object put(String key, Object value) {
        throw new UnsupportedOperationException("Config cannot be modified");
    }

    public Object remove(Object key) {
        throw new UnsupportedOperationException("Config cannot be modified");
    }

    public void putAll(Map<? extends String, ?> m) {
        throw new UnsupportedOperationException("Config cannot be modified");
    }

    public void clear() {
        throw new UnsupportedOperationException("Config cannot be modified");
    }

    @Override
    public Config merge(Map<String, Object> toMerge) {
        throw new UnsupportedOperationException("Config cannot be modified");
    }

    public void setAt(Object key, Object value) {
        throw new UnsupportedOperationException("Config cannot be modified");
    }
}

