/*
 * Decompiled with CFR 0.152.
 */
package org.grails.spring.context.support;

import grails.core.GrailsApplication;
import grails.core.support.GrailsApplicationAware;
import grails.plugins.GrailsPlugin;
import grails.plugins.GrailsPluginManager;
import grails.plugins.PluginManagerAware;
import grails.util.CacheEntry;
import grails.util.GrailsStringUtils;
import grails.util.Pair;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.grails.plugins.BinaryGrailsPlugin;
import org.grails.spring.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class PluginAwareResourceBundleMessageSource
extends ReloadableResourceBundleMessageSource
implements GrailsApplicationAware,
PluginManagerAware,
InitializingBean {
    private static final Log LOG = LogFactory.getLog(PluginAwareResourceBundleMessageSource.class);
    private static final Resource[] NO_RESOURCES = new Resource[0];
    private static final String WEB_INF_PLUGINS_PATH = "/WEB-INF/plugins/";
    private static final String GRAILS_APP_I18N_PATH_COMPONENT = "/grails-app/i18n/";
    protected GrailsApplication application;
    protected GrailsPluginManager pluginManager;
    protected List<String> pluginBaseNames = new ArrayList<String>();
    private ResourceLoader localResourceLoader;
    private PathMatchingResourcePatternResolver resourceResolver;
    private ConcurrentMap<Locale, CacheEntry<ReloadableResourceBundleMessageSource.PropertiesHolder>> cachedMergedPluginProperties = new ConcurrentHashMap<Locale, CacheEntry<ReloadableResourceBundleMessageSource.PropertiesHolder>>();
    private ConcurrentMap<Locale, CacheEntry<ReloadableResourceBundleMessageSource.PropertiesHolder>> cachedMergedBinaryPluginProperties = new ConcurrentHashMap<Locale, CacheEntry<ReloadableResourceBundleMessageSource.PropertiesHolder>>();
    private long pluginCacheMillis = Long.MIN_VALUE;

    public List<String> getPluginBaseNames() {
        return this.pluginBaseNames;
    }

    public void setPluginBaseNames(List<String> pluginBaseNames) {
        this.pluginBaseNames = pluginBaseNames;
    }

    @Override
    public void setGrailsApplication(GrailsApplication grailsApplication) {
        this.application = grailsApplication;
    }

    @Override
    public void setPluginManager(GrailsPluginManager pluginManager) {
        this.pluginManager = pluginManager;
    }

    public void setResourceResolver(PathMatchingResourcePatternResolver resourceResolver) {
        this.resourceResolver = resourceResolver;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.pluginCacheMillis == Long.MIN_VALUE) {
            this.pluginCacheMillis = this.cacheMillis;
        }
        if (this.pluginManager == null || this.localResourceLoader == null) {
            return;
        }
        Resource[] resources = this.resourceResolver.getResources("classpath*:**/*.properties");
        ArrayList<String> basenames = new ArrayList<String>();
        for (Resource resource : resources) {
            String filename = resource.getFilename();
            String baseName = GrailsStringUtils.getFileBasename(filename);
            int i = baseName.indexOf(95);
            if (i > -1) {
                baseName = baseName.substring(0, i);
            }
            if (basenames.contains(baseName)) continue;
            basenames.add(baseName);
        }
        this.setBasenames(basenames.toArray(new String[basenames.size()]));
        for (GrailsPlugin grailsPlugin : this.pluginManager.getAllPlugins()) {
            for (Resource pluginBundle : this.getPluginBundles(grailsPlugin)) {
                String basePath = WEB_INF_PLUGINS_PATH.substring(1) + grailsPlugin.getFileSystemName();
                String baseName = GrailsStringUtils.substringBefore(GrailsStringUtils.getFileBasename(pluginBundle.getFilename()), "_");
                String pathToAdd = basePath + GRAILS_APP_I18N_PATH_COMPONENT + baseName;
                if (this.pluginBaseNames.contains(pathToAdd)) continue;
                this.pluginBaseNames.add(pathToAdd);
            }
        }
    }

    protected Resource[] getPluginBundles(GrailsPlugin grailsPlugin) {
        if (grailsPlugin instanceof BinaryGrailsPlugin) {
            return NO_RESOURCES;
        }
        try {
            String basePath = WEB_INF_PLUGINS_PATH + grailsPlugin.getFileSystemName();
            return this.resourceResolver.getResources(basePath + "/grails-app/i18n/*.properties");
        }
        catch (IOException e) {
            LOG.debug((Object)("Could not resolve any resources for plugin " + grailsPlugin.getFileSystemName()), (Throwable)e);
            return NO_RESOURCES;
        }
    }

    @Override
    protected String resolveCodeWithoutArguments(String code, Locale locale) {
        String msg = super.resolveCodeWithoutArguments(code, locale);
        return msg == null ? this.resolveCodeWithoutArgumentsFromPlugins(code, locale) : msg;
    }

    @Override
    protected MessageFormat resolveCode(String code, Locale locale) {
        MessageFormat mf = super.resolveCode(code, locale);
        return mf == null ? this.resolveCodeFromPlugins(code, locale) : mf;
    }

    protected ReloadableResourceBundleMessageSource.PropertiesHolder getMergedPluginProperties(final Locale locale) {
        return CacheEntry.getValue(this.cachedMergedPluginProperties, locale, this.cacheMillis, new Callable<ReloadableResourceBundleMessageSource.PropertiesHolder>(){

            @Override
            public ReloadableResourceBundleMessageSource.PropertiesHolder call() throws Exception {
                Properties mergedProps = new Properties();
                ReloadableResourceBundleMessageSource.PropertiesHolder mergedHolder = new ReloadableResourceBundleMessageSource.PropertiesHolder(mergedProps);
                PluginAwareResourceBundleMessageSource.this.mergeBinaryPluginProperties(locale, mergedProps);
                for (String basename : PluginAwareResourceBundleMessageSource.this.pluginBaseNames) {
                    List<Pair<String, Resource>> filenamesAndResources = PluginAwareResourceBundleMessageSource.this.calculateAllFilenames(basename, locale);
                    for (int j = filenamesAndResources.size() - 1; j >= 0; --j) {
                        Pair<String, Resource> filenameAndResource = filenamesAndResources.get(j);
                        if (filenameAndResource.getbValue() == null) continue;
                        ReloadableResourceBundleMessageSource.PropertiesHolder propHolder = PluginAwareResourceBundleMessageSource.this.getProperties(filenameAndResource.getaValue(), filenameAndResource.getbValue());
                        mergedProps.putAll((Map<?, ?>)propHolder.getProperties());
                    }
                }
                return mergedHolder;
            }
        });
    }

    protected String resolveCodeWithoutArgumentsFromPlugins(String code, Locale locale) {
        if (this.pluginCacheMillis < 0L) {
            ReloadableResourceBundleMessageSource.PropertiesHolder propHolder = this.getMergedPluginProperties(locale);
            String result = propHolder.getProperty(code);
            if (result != null) {
                return result;
            }
        } else {
            String result = this.findMessageInSourcePlugins(code, locale);
            if (result != null) {
                return result;
            }
            result = this.findCodeInBinaryPlugins(code, locale);
            if (result != null) {
                return result;
            }
        }
        return null;
    }

    protected ReloadableResourceBundleMessageSource.PropertiesHolder getMergedBinaryPluginProperties(final Locale locale) {
        return CacheEntry.getValue(this.cachedMergedBinaryPluginProperties, locale, this.cacheMillis, new Callable<ReloadableResourceBundleMessageSource.PropertiesHolder>(){

            @Override
            public ReloadableResourceBundleMessageSource.PropertiesHolder call() throws Exception {
                Properties mergedProps = new Properties();
                ReloadableResourceBundleMessageSource.PropertiesHolder mergedHolder = new ReloadableResourceBundleMessageSource.PropertiesHolder(mergedProps);
                PluginAwareResourceBundleMessageSource.this.mergeBinaryPluginProperties(locale, mergedProps);
                return mergedHolder;
            }
        });
    }

    protected void mergeBinaryPluginProperties(Locale locale, Properties mergedProps) {
        GrailsPlugin[] allPlugins;
        for (GrailsPlugin plugin : allPlugins = this.pluginManager.getAllPlugins()) {
            BinaryGrailsPlugin binaryPlugin;
            Properties binaryPluginProperties;
            if (!(plugin instanceof BinaryGrailsPlugin) || (binaryPluginProperties = (binaryPlugin = (BinaryGrailsPlugin)plugin).getProperties(locale)) == null) continue;
            mergedProps.putAll((Map<?, ?>)binaryPluginProperties);
        }
    }

    private String findCodeInBinaryPlugins(String code, Locale locale) {
        return this.getMergedBinaryPluginProperties(locale).getProperty(code);
    }

    private String findMessageInSourcePlugins(String code, Locale locale) {
        for (String pluginBaseName : this.pluginBaseNames) {
            List<Pair<String, Resource>> filenamesAndResources = this.calculateAllFilenames(pluginBaseName, locale);
            for (Pair<String, Resource> filenameAndResource : filenamesAndResources) {
                ReloadableResourceBundleMessageSource.PropertiesHolder holder = this.getProperties(filenameAndResource.getaValue(), filenameAndResource.getbValue());
                String result = holder.getProperty(code);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    private MessageFormat findMessageFormatInBinaryPlugins(String code, Locale locale) {
        return this.getMergedBinaryPluginProperties(locale).getMessageFormat(code, locale);
    }

    private MessageFormat findMessageFormatInSourcePlugins(String code, Locale locale) {
        for (String pluginBaseName : this.pluginBaseNames) {
            List<Pair<String, Resource>> filenamesAndResources = this.calculateAllFilenames(pluginBaseName, locale);
            for (Pair<String, Resource> filenameAndResource : filenamesAndResources) {
                ReloadableResourceBundleMessageSource.PropertiesHolder holder = this.getProperties(filenameAndResource.getaValue(), filenameAndResource.getbValue());
                MessageFormat result = holder.getMessageFormat(code, locale);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    protected MessageFormat resolveCodeFromPlugins(String code, Locale locale) {
        if (this.pluginCacheMillis < 0L) {
            ReloadableResourceBundleMessageSource.PropertiesHolder propHolder = this.getMergedPluginProperties(locale);
            MessageFormat result = propHolder.getMessageFormat(code, locale);
            if (result != null) {
                return result;
            }
        } else {
            MessageFormat result = this.findMessageFormatInSourcePlugins(code, locale);
            if (result != null) {
                return result;
            }
            result = this.findMessageFormatInBinaryPlugins(code, locale);
            if (result != null) {
                return result;
            }
        }
        return null;
    }

    @Override
    public void setResourceLoader(ResourceLoader resourceLoader) {
        super.setResourceLoader(resourceLoader);
        this.localResourceLoader = resourceLoader;
        if (this.resourceResolver == null) {
            this.resourceResolver = new PathMatchingResourcePatternResolver(this.localResourceLoader);
        }
    }

    public void setPluginCacheSeconds(int pluginCacheSeconds) {
        this.pluginCacheMillis = pluginCacheSeconds * 1000;
    }
}

