/*
 * Decompiled with CFR 0.152.
 */
package org.grails.core.metaclass;

import grails.util.GrailsArrayUtils;
import grails.util.GrailsClassUtils;
import groovy.lang.GString;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.codehaus.groovy.reflection.CachedClass;
import org.codehaus.groovy.reflection.CachedMethod;
import org.codehaus.groovy.runtime.metaclass.ReflectionMetaMethod;

public abstract class BaseApiProvider {
    private static List<String> EXCLUDED_METHODS = Arrays.asList("setMetaClass", "getMetaClass", "setProperties", "getProperties");
    public static final String CONSTRUCTOR_METHOD = "initialize";
    public static final String CTOR_GROOVY_METHOD = "<ctor>";
    protected List instanceMethods = new ArrayList();
    protected List<Method> staticMethods = new ArrayList<Method>();
    protected List<Method> constructors = new ArrayList<Method>();

    public void addApi(final Object apiInstance) {
        if (apiInstance == null) {
            return;
        }
        for (Class<?> currentClass = apiInstance.getClass(); currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
            Method[] declaredMethods;
            for (final Method javaMethod : declaredMethods = currentClass.getDeclaredMethods()) {
                int modifiers = javaMethod.getModifiers();
                if (!this.isNotExcluded(javaMethod, modifiers)) continue;
                if (Modifier.isStatic(modifiers)) {
                    if (this.isConstructorCallMethod(javaMethod)) {
                        this.constructors.add(javaMethod);
                        continue;
                    }
                    this.staticMethods.add(javaMethod);
                    continue;
                }
                this.instanceMethods.add(new ReflectionMetaMethod(new CachedMethod(javaMethod)){
                    {
                        super(x0);
                        CachedClass[] paramTypes = super.getParameterTypes();
                        if (paramTypes.length > 0) {
                            this.setParametersTypes((CachedClass[])GrailsArrayUtils.subarray(paramTypes, 1, paramTypes.length));
                        }
                    }

                    public String getName() {
                        String methodName = super.getName();
                        if (BaseApiProvider.this.isConstructorCallMethod(javaMethod)) {
                            return BaseApiProvider.CTOR_GROOVY_METHOD;
                        }
                        return methodName;
                    }

                    public Object invoke(Object object, Object[] arguments) {
                        if (arguments.length == 0) {
                            return super.invoke(apiInstance, new Object[]{object});
                        }
                        return super.invoke(apiInstance, (Object[])GrailsArrayUtils.add(this.checkForGStrings(arguments), 0, object));
                    }

                    private Object[] checkForGStrings(Object[] arguments) {
                        for (int i = 0; i < arguments.length; ++i) {
                            if (!(arguments[i] instanceof GString)) continue;
                            arguments[i] = arguments[i].toString();
                        }
                        return arguments;
                    }

                    public CachedClass[] getParameterTypes() {
                        CachedClass[] paramTypes = this.method.getParameterTypes();
                        if (paramTypes.length > 0) {
                            return (CachedClass[])GrailsArrayUtils.subarray(paramTypes, 1, paramTypes.length);
                        }
                        return paramTypes;
                    }
                });
            }
        }
    }

    private boolean isConstructorCallMethod(Method method) {
        return method != null && Modifier.isStatic(method.getModifiers()) && Modifier.isPublic(method.getModifiers()) && method.getName().equals(CONSTRUCTOR_METHOD) && method.getParameterTypes().length > 0;
    }

    private boolean isNotExcluded(Method method, int modifiers) {
        String name = method.getName();
        if (EXCLUDED_METHODS.contains(name)) {
            return false;
        }
        boolean isStatic = Modifier.isStatic(modifiers);
        if (!isStatic && (GrailsClassUtils.isSetter(name, method.getParameterTypes()) || GrailsClassUtils.isGetter(name, method.getParameterTypes()))) {
            return false;
        }
        int minParameters = isStatic ? 0 : 1;
        return Modifier.isPublic(modifiers) && !method.isSynthetic() && !method.isBridge() && !Modifier.isAbstract(modifiers) && !name.contains("$") && method.getParameterTypes().length >= minParameters;
    }
}

