/*
 * Decompiled with CFR 0.152.
 */
package org.grails.beans.support;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.LogFactory;
import org.grails.beans.support.ExtendedBeanInfo;
import org.springframework.beans.BeanInfoFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.ExtendedBeanInfoFactory;
import org.springframework.beans.FatalBeanException;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.util.ClassUtils;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class CachedIntrospectionResults {
    public static final String IGNORE_BEANINFO_PROPERTY_NAME = "spring.beaninfo.ignore";
    private static final boolean shouldIntrospectorIgnoreBeaninfoClasses = true;
    private static List<BeanInfoFactory> beanInfoFactories = new ArrayList<BeanInfoFactory>(){
        {
            this.add(new ExtendedBeanInfoFactory());
        }
    };
    static final Set<ClassLoader> acceptedClassLoaders = Collections.newSetFromMap(new ConcurrentHashMap(16));
    static final ConcurrentMap<Class<?>, CachedIntrospectionResults> strongClassCache = new ConcurrentHashMap(64);
    static final ConcurrentMap<Class<?>, CachedIntrospectionResults> softClassCache = new ConcurrentReferenceHashMap(64);
    private final BeanInfo beanInfo;
    private final Map<String, PropertyDescriptor> propertyDescriptorCache;
    private final ConcurrentMap<PropertyDescriptor, TypeDescriptor> typeDescriptorCache;

    public static void acceptClassLoader(ClassLoader classLoader) {
        if (classLoader != null) {
            acceptedClassLoaders.add(classLoader);
        }
    }

    public static void clearClassLoader(ClassLoader classLoader) {
        Class beanClass;
        Iterator<ClassLoader> it = acceptedClassLoaders.iterator();
        while (it.hasNext()) {
            ClassLoader registeredLoader = it.next();
            if (!CachedIntrospectionResults.isUnderneathClassLoader(registeredLoader, classLoader)) continue;
            it.remove();
        }
        it = strongClassCache.keySet().iterator();
        while (it.hasNext()) {
            beanClass = (Class)((Object)it.next());
            if (!CachedIntrospectionResults.isUnderneathClassLoader(beanClass.getClassLoader(), classLoader)) continue;
            it.remove();
        }
        it = softClassCache.keySet().iterator();
        while (it.hasNext()) {
            beanClass = (Class)((Object)it.next());
            if (!CachedIntrospectionResults.isUnderneathClassLoader(beanClass.getClassLoader(), classLoader)) continue;
            it.remove();
        }
    }

    public static CachedIntrospectionResults forClass(Class<?> beanClass) throws BeansException {
        CachedIntrospectionResults results = (CachedIntrospectionResults)strongClassCache.get(beanClass);
        if (results != null) {
            return results;
        }
        results = (CachedIntrospectionResults)softClassCache.get(beanClass);
        if (results != null) {
            return results;
        }
        results = new CachedIntrospectionResults(beanClass);
        ConcurrentMap<Class<?>, CachedIntrospectionResults> classCacheToUse = ClassUtils.isCacheSafe(beanClass, (ClassLoader)CachedIntrospectionResults.class.getClassLoader()) || CachedIntrospectionResults.isClassLoaderAccepted(beanClass.getClassLoader()) ? strongClassCache : softClassCache;
        CachedIntrospectionResults existing = classCacheToUse.putIfAbsent(beanClass, results);
        return existing != null ? existing : results;
    }

    private static boolean isClassLoaderAccepted(ClassLoader classLoader) {
        for (ClassLoader acceptedLoader : acceptedClassLoaders) {
            if (!CachedIntrospectionResults.isUnderneathClassLoader(classLoader, acceptedLoader)) continue;
            return true;
        }
        return false;
    }

    private static boolean isUnderneathClassLoader(ClassLoader candidate, ClassLoader parent) {
        if (candidate == parent) {
            return true;
        }
        if (candidate == null) {
            return false;
        }
        ClassLoader classLoaderToCheck = candidate;
        while (classLoaderToCheck != null) {
            if ((classLoaderToCheck = classLoaderToCheck.getParent()) != parent) continue;
            return true;
        }
        return false;
    }

    private CachedIntrospectionResults(Class<?> beanClass) throws BeansException {
        try {
            PropertyDescriptor[] pds;
            BeanInfo beanInfo = new ExtendedBeanInfo(Introspector.getBeanInfo(beanClass));
            if (beanInfo == null) {
                beanInfo = Introspector.getBeanInfo(beanClass, 3);
            }
            this.beanInfo = beanInfo;
            this.propertyDescriptorCache = new LinkedHashMap<String, PropertyDescriptor>();
            for (PropertyDescriptor pd : pds = this.beanInfo.getPropertyDescriptors()) {
                if (Class.class.equals(beanClass) && ("classLoader".equals(pd.getName()) || "protectionDomain".equals(pd.getName()))) continue;
                pd = this.buildGenericTypeAwarePropertyDescriptor(beanClass, pd);
                this.propertyDescriptorCache.put(pd.getName(), pd);
            }
            this.typeDescriptorCache = new ConcurrentReferenceHashMap();
        }
        catch (IntrospectionException ex) {
            throw new FatalBeanException("Failed to obtain BeanInfo for class [" + beanClass.getName() + "]", (Throwable)ex);
        }
    }

    public BeanInfo getBeanInfo() {
        return this.beanInfo;
    }

    public Class<?> getBeanClass() {
        return this.beanInfo.getBeanDescriptor().getBeanClass();
    }

    public PropertyDescriptor getPropertyDescriptor(String name) {
        PropertyDescriptor pd = this.propertyDescriptorCache.get(name);
        if (pd == null && StringUtils.hasLength((String)name) && (pd = this.propertyDescriptorCache.get(name.substring(0, 1).toLowerCase() + name.substring(1))) == null) {
            pd = this.propertyDescriptorCache.get(name.substring(0, 1).toUpperCase() + name.substring(1));
        }
        return pd == null || pd instanceof GenericTypeAwarePropertyDescriptor ? pd : this.buildGenericTypeAwarePropertyDescriptor(this.getBeanClass(), pd);
    }

    public PropertyDescriptor[] getPropertyDescriptors() {
        PropertyDescriptor[] pds = new PropertyDescriptor[this.propertyDescriptorCache.size()];
        int i = 0;
        for (PropertyDescriptor pd : this.propertyDescriptorCache.values()) {
            pds[i] = pd instanceof GenericTypeAwarePropertyDescriptor ? pd : this.buildGenericTypeAwarePropertyDescriptor(this.getBeanClass(), pd);
            ++i;
        }
        return pds;
    }

    private PropertyDescriptor buildGenericTypeAwarePropertyDescriptor(Class<?> beanClass, PropertyDescriptor pd) {
        try {
            return new GenericTypeAwarePropertyDescriptor(beanClass, pd.getName(), pd.getReadMethod(), pd.getWriteMethod(), pd.getPropertyEditorClass());
        }
        catch (IntrospectionException ex) {
            throw new FatalBeanException("Failed to re-introspect class [" + beanClass.getName() + "]", (Throwable)ex);
        }
    }

    public TypeDescriptor addTypeDescriptor(PropertyDescriptor pd, TypeDescriptor td) {
        TypeDescriptor existing = this.typeDescriptorCache.putIfAbsent(pd, td);
        return existing != null ? existing : td;
    }

    public TypeDescriptor getTypeDescriptor(PropertyDescriptor pd) {
        return (TypeDescriptor)this.typeDescriptorCache.get(pd);
    }

    public static boolean equals(PropertyDescriptor pd, PropertyDescriptor otherPd) {
        return ObjectUtils.nullSafeEquals((Object)pd.getReadMethod(), (Object)otherPd.getReadMethod()) && ObjectUtils.nullSafeEquals((Object)pd.getWriteMethod(), (Object)otherPd.getWriteMethod()) && ObjectUtils.nullSafeEquals(pd.getPropertyType(), otherPd.getPropertyType()) && ObjectUtils.nullSafeEquals(pd.getPropertyEditorClass(), otherPd.getPropertyEditorClass()) && pd.isBound() == otherPd.isBound() && pd.isConstrained() == otherPd.isConstrained();
    }

    final class GenericTypeAwarePropertyDescriptor
    extends PropertyDescriptor {
        private final Class<?> beanClass;
        private final Method readMethod;
        private final Method writeMethod;
        private volatile Set<Method> ambiguousWriteMethods;
        private MethodParameter writeMethodParameter;
        private Class<?> propertyType;
        private final Class<?> propertyEditorClass;

        public GenericTypeAwarePropertyDescriptor(Class<?> beanClass, String propertyName, Method readMethod, Method writeMethod, Class<?> propertyEditorClass) throws IntrospectionException {
            Method candidate;
            super(propertyName, null, null);
            if (beanClass == null) {
                throw new IntrospectionException("Bean class must not be null");
            }
            this.beanClass = beanClass;
            Method readMethodToUse = BridgeMethodResolver.findBridgedMethod((Method)readMethod);
            Method writeMethodToUse = BridgeMethodResolver.findBridgedMethod((Method)writeMethod);
            if (writeMethodToUse == null && readMethodToUse != null && (candidate = ClassUtils.getMethodIfAvailable(this.beanClass, (String)("set" + StringUtils.capitalize((String)this.getName())), (Class[])null)) != null && candidate.getParameterTypes().length == 1) {
                writeMethodToUse = candidate;
            }
            this.readMethod = readMethodToUse;
            this.writeMethod = writeMethodToUse;
            if (this.writeMethod != null) {
                if (this.readMethod == null) {
                    HashSet<Method> ambiguousCandidates = new HashSet<Method>();
                    for (Method method : beanClass.getMethods()) {
                        if (!method.getName().equals(writeMethodToUse.getName()) || method.equals(writeMethodToUse) || method.isBridge()) continue;
                        ambiguousCandidates.add(method);
                    }
                    if (!ambiguousCandidates.isEmpty()) {
                        this.ambiguousWriteMethods = ambiguousCandidates;
                    }
                }
                this.writeMethodParameter = new MethodParameter(this.writeMethod, 0);
                GenericTypeResolver.resolveParameterType((MethodParameter)this.writeMethodParameter, this.beanClass);
            }
            if (this.readMethod != null) {
                this.propertyType = GenericTypeResolver.resolveReturnType((Method)this.readMethod, this.beanClass);
            } else if (this.writeMethodParameter != null) {
                this.propertyType = this.writeMethodParameter.getParameterType();
            }
            this.propertyEditorClass = propertyEditorClass;
        }

        public Class<?> getBeanClass() {
            return this.beanClass;
        }

        @Override
        public Method getReadMethod() {
            return this.readMethod;
        }

        @Override
        public Method getWriteMethod() {
            return this.writeMethod;
        }

        public Method getWriteMethodForActualAccess() {
            Set<Method> ambiguousCandidates = this.ambiguousWriteMethods;
            if (ambiguousCandidates != null) {
                this.ambiguousWriteMethods = null;
                LogFactory.getLog(GenericTypeAwarePropertyDescriptor.class).warn((Object)("Invalid JavaBean property '" + this.getName() + "' being accessed! Ambiguous write methods found next to actually used [" + this.writeMethod + "]: " + ambiguousCandidates));
            }
            return this.writeMethod;
        }

        public MethodParameter getWriteMethodParameter() {
            return this.writeMethodParameter;
        }

        @Override
        public Class<?> getPropertyType() {
            return this.propertyType;
        }

        @Override
        public Class<?> getPropertyEditorClass() {
            return this.propertyEditorClass;
        }

        @Override
        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof GenericTypeAwarePropertyDescriptor)) {
                return false;
            }
            GenericTypeAwarePropertyDescriptor otherPd = (GenericTypeAwarePropertyDescriptor)other;
            return this.getBeanClass().equals(otherPd.getBeanClass()) && CachedIntrospectionResults.equals(this, otherPd);
        }

        @Override
        public int hashCode() {
            int hashCode = this.getBeanClass().hashCode();
            hashCode = 29 * hashCode + ObjectUtils.nullSafeHashCode((Object)this.getReadMethod());
            hashCode = 29 * hashCode + ObjectUtils.nullSafeHashCode((Object)this.getWriteMethod());
            return hashCode;
        }
    }
}

