/*
 * Decompiled with CFR 0.152.
 */
package grails.util;

import grails.util.Environment;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import groovy.lang.Writable;
import groovy.util.slurpersupport.GPathResult;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.grails.exceptions.reporting.DefaultStackTraceFilterer;
import org.grails.exceptions.reporting.StackTraceFilterer;

public class GrailsUtil {
    private static final Log LOG = LogFactory.getLog(GrailsUtil.class);
    private static final boolean LOG_DEPRECATED = Boolean.valueOf(System.getProperty("grails.log.deprecated", String.valueOf(Environment.isDevelopmentMode())));
    private static final StackTraceFilterer stackFilterer = new DefaultStackTraceFilterer();

    private GrailsUtil() {
    }

    @Deprecated
    public static String getEnvironment() {
        return Environment.getCurrent().getName();
    }

    public static boolean isDevelopmentEnv() {
        return Environment.getCurrent().equals((Object)Environment.DEVELOPMENT);
    }

    public static String getGrailsVersion() {
        return Environment.getGrailsVersion();
    }

    private static boolean isBlank(String value) {
        return value == null || value.trim().length() == 0;
    }

    public static void deprecated(Class<?> clazz, String methodOrPropName) {
        GrailsUtil.deprecated(clazz, methodOrPropName, GrailsUtil.getGrailsVersion());
    }

    public static void deprecated(Class<?> clazz, String methodOrPropName, String version) {
        if (LOG_DEPRECATED) {
            GrailsUtil.deprecated("Property or method [" + methodOrPropName + "] of class [" + clazz.getName() + "] is deprecated in [" + version + "] and will be removed in future releases");
        }
    }

    public static void deprecated(String message) {
        if (LOG_DEPRECATED && LOG.isWarnEnabled()) {
            LOG.warn((Object)("[DEPRECATED] " + message));
        }
    }

    public static void warn(String message) {
        if (LOG.isWarnEnabled()) {
            LOG.warn((Object)("[WARNING] " + message));
        }
    }

    @Deprecated
    public static Throwable sanitize(Throwable t) {
        return stackFilterer.filter(t);
    }

    public static void printSanitizedStackTrace(Throwable t, PrintWriter p) {
        GrailsUtil.printSanitizedStackTrace(t, p, stackFilterer);
    }

    public static void printSanitizedStackTrace(Throwable t, PrintWriter p, StackTraceFilterer stackTraceFilterer) {
        StackTraceElement[] trace;
        t = stackTraceFilterer.filter(t);
        for (StackTraceElement stackTraceElement : trace = t.getStackTrace()) {
            p.println("at " + stackTraceElement.getClassName() + "(" + stackTraceElement.getMethodName() + ":" + stackTraceElement.getLineNumber() + ")");
        }
    }

    public static void printSanitizedStackTrace(Throwable t) {
        GrailsUtil.printSanitizedStackTrace(t, new PrintWriter(System.err));
    }

    public static Throwable extractRootCause(Throwable t) {
        Throwable result = t;
        while (result.getCause() != null) {
            result = result.getCause();
        }
        return result;
    }

    public static Throwable sanitizeRootCause(Throwable t) {
        return stackFilterer.filter(GrailsUtil.extractRootCause(t));
    }

    public static Throwable deepSanitize(Throwable t) {
        return stackFilterer.filter(t, true);
    }

    @Deprecated
    public static void writeSlurperResult(GPathResult result, Writer output) throws IOException {
        Binding b = new Binding();
        b.setVariable("node", (Object)result);
        Writable w = (Writable)new GroovyShell(b).evaluate("new groovy.xml.StreamingMarkupBuilder().bind { mkp.declareNamespace(\"\":  \"http://java.sun.com/xml/ns/j2ee\"); mkp.yield node}");
        w.writeTo(output);
    }
}

