/*
 * Decompiled with CFR 0.152.
 */
package grails.core;

import grails.config.Config;
import grails.core.ArtefactHandler;
import grails.core.ArtefactInfo;
import grails.core.DefaultArtefactInfo;
import grails.core.GrailsApplicationClass;
import grails.core.GrailsClass;
import grails.core.GrailsDomainClass;
import grails.core.events.ArtefactAdditionEvent;
import grails.util.GrailsNameUtils;
import grails.util.GrailsUtil;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClassRegistry;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.reflection.CachedClass;
import org.codehaus.groovy.runtime.metaclass.MetaClassRegistryImpl;
import org.grails.config.PropertySourcesConfig;
import org.grails.core.AbstractGrailsApplication;
import org.grails.core.exceptions.GrailsConfigurationException;
import org.grails.core.io.support.GrailsFactoriesLoader;
import org.grails.io.support.GrailsResourceUtils;
import org.grails.io.support.Resource;
import org.grails.spring.beans.GrailsApplicationAwareBeanPostProcessor;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySources;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class DefaultGrailsApplication
extends AbstractGrailsApplication
implements BeanClassLoaderAware {
    protected static final Pattern GETCLASSESPROP_PATTERN = Pattern.compile("(\\w+)(Classes)");
    protected static final Pattern GETCLASSESMETH_PATTERN = Pattern.compile("(get)(\\w+)(Classes)");
    protected static final Pattern ISCLASS_PATTERN = Pattern.compile("(is)(\\w+)(Class)");
    protected static final Pattern GETCLASS_PATTERN = Pattern.compile("(get)(\\w+)Class");
    protected Class<?>[] allClasses = new Class[0];
    protected static Log log = LogFactory.getLog(DefaultGrailsApplication.class);
    protected Set<Class<?>> loadedClasses = new LinkedHashSet();
    protected ArtefactHandler[] artefactHandlers;
    protected Map<String, ArtefactHandler> artefactHandlersByName = new HashMap<String, ArtefactHandler>();
    protected List<Class<?>> allArtefactClasses = new ArrayList();
    protected Map<String, ArtefactInfo> artefactInfo = new HashMap<String, ArtefactInfo>();
    protected Class<?>[] allArtefactClassesArray;
    protected org.springframework.core.io.Resource[] resources;
    protected boolean initialised = false;
    protected GrailsApplicationClass applicationClass;
    private static boolean extensionMethodsInitialized = false;

    public DefaultGrailsApplication() {
        this((ClassLoader)new GroovyClassLoader());
    }

    public DefaultGrailsApplication(GrailsApplicationClass applicationClass) {
        this((ClassLoader)new GroovyClassLoader());
        this.applicationClass = applicationClass;
    }

    public DefaultGrailsApplication(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public DefaultGrailsApplication(Class<?> ... classes) {
        this(classes, (ClassLoader)new GroovyClassLoader(Thread.currentThread().getContextClassLoader()));
    }

    public DefaultGrailsApplication(Class<?>[] classes, ClassLoader classLoader) {
        Assert.notNull(classes, (String)"Constructor argument 'classes' cannot be null");
        this.loadedClasses.addAll(Arrays.asList(classes));
        this.allClasses = classes;
        this.classLoader = classLoader;
    }

    public DefaultGrailsApplication(org.springframework.core.io.Resource[] resources) {
        this();
        for (org.springframework.core.io.Resource resource : resources) {
            Class<?> aClass;
            try {
                aClass = this.classLoader.loadClass(GrailsResourceUtils.getClassName((String)resource.getFile().getAbsolutePath()));
            }
            catch (ClassNotFoundException e) {
                throw new GrailsConfigurationException("Class not found loading Grails application: " + e.getMessage(), e);
            }
            catch (IOException e) {
                throw new GrailsConfigurationException("Class not found loading Grails application: " + e.getMessage(), e);
            }
            this.loadedClasses.add(aClass);
        }
    }

    public DefaultGrailsApplication(Resource[] resources) {
        this();
        for (Resource resource : resources) {
            Class<?> aClass;
            try {
                aClass = this.classLoader.loadClass(GrailsResourceUtils.getClassName((String)resource.getFile().getAbsolutePath()));
            }
            catch (ClassNotFoundException e) {
                throw new GrailsConfigurationException("Class not found loading Grails application: " + e.getMessage(), e);
            }
            catch (IOException e) {
                throw new GrailsConfigurationException("Class not found loading Grails application: " + e.getMessage(), e);
            }
            this.loadedClasses.add(aClass);
        }
    }

    public GrailsApplicationClass getApplicationClass() {
        return this.applicationClass;
    }

    protected void initArtefactHandlers() {
        List<ArtefactHandler> additionalArtefactHandlers = GrailsFactoriesLoader.loadFactories(ArtefactHandler.class, this.getClassLoader());
        for (ArtefactHandler artefactHandler : additionalArtefactHandlers) {
            this.registerArtefactHandler(artefactHandler);
        }
        this.updateArtefactHandlers();
    }

    private void updateArtefactHandlers() {
        this.artefactHandlers = this.artefactHandlersByName.values().toArray(new ArtefactHandler[this.artefactHandlersByName.size()]);
    }

    public Class<?>[] getAllArtefacts() {
        return this.allArtefactClassesArray;
    }

    protected Class<?>[] populateAllClasses() {
        this.allClasses = this.loadedClasses.toArray(new Class[this.loadedClasses.size()]);
        return this.allClasses;
    }

    protected void configureLoadedClasses(Class<?>[] classes) {
        this.initArtefactHandlers();
        this.artefactInfo.clear();
        this.allArtefactClasses.clear();
        this.allArtefactClassesArray = null;
        this.allClasses = classes;
        log.debug((Object)"Going to inspect artefact classes.");
        MetaClassRegistry metaClassRegistry = GroovySystem.getMetaClassRegistry();
        block0: for (Class<?> theClass : classes) {
            log.debug((Object)("Inspecting [" + theClass.getName() + "]"));
            metaClassRegistry.removeMetaClass(theClass);
            if (this.allArtefactClasses.contains(theClass)) continue;
            for (ArtefactHandler artefactHandler : this.artefactHandlers) {
                if (!artefactHandler.isArtefact(theClass)) continue;
                log.debug((Object)("Adding artefact " + theClass + " of kind " + artefactHandler.getType()));
                GrailsClass gclass = this.addArtefact(artefactHandler.getType(), theClass);
                this.allArtefactClasses.add(theClass);
                DefaultArtefactInfo info = this.getArtefactInfo(artefactHandler.getType(), true);
                info.addGrailsClass(gclass);
                continue block0;
            }
        }
        this.refreshArtefactGrailsClassCaches();
        this.allArtefactClassesArray = this.allArtefactClasses.toArray(new Class[this.allArtefactClasses.size()]);
        for (ArtefactHandler artefactHandler : this.artefactHandlers) {
            this.initializeArtefacts(artefactHandler);
        }
    }

    protected void refreshArtefactGrailsClassCaches() {
        for (ArtefactInfo o : this.artefactInfo.values()) {
            ((DefaultArtefactInfo)o).updateComplete();
        }
    }

    protected void addToLoaded(Class<?> clazz) {
        this.loadedClasses.add(clazz);
        this.populateAllClasses();
    }

    @Override
    public Config getConfig() {
        if (this.config == null) {
            if (this.parentContext != null) {
                Environment environment = this.parentContext.getEnvironment();
                if (environment instanceof ConfigurableEnvironment) {
                    MutablePropertySources propertySources = ((ConfigurableEnvironment)environment).getPropertySources();
                    this.config = new PropertySourcesConfig((PropertySources)propertySources);
                }
            } else {
                this.config = new PropertySourcesConfig();
            }
            this.setConfig(this.config);
        }
        return this.config;
    }

    protected int getArtefactCount(String artefactType) {
        ArtefactInfo info = this.getArtefactInfo(artefactType);
        return info == null ? 0 : info.getClasses().length;
    }

    public Class<?>[] getAllClasses() {
        return this.allClasses;
    }

    @Override
    public Class<?> getClassForName(String className) {
        if (!StringUtils.hasText((String)className)) {
            return null;
        }
        for (Class<?> c : this.allClasses) {
            if (!c.getName().equals(className)) continue;
            return c;
        }
        return null;
    }

    @Override
    public void refreshConstraints() {
        GrailsClass[] domainClasses;
        DefaultArtefactInfo info = this.getArtefactInfo("Domain", true);
        for (GrailsClass domainClass : domainClasses = info.getGrailsClasses()) {
            ((GrailsDomainClass)domainClass).refreshConstraints();
        }
    }

    @Override
    public void refresh() {
        if (this.classLoader instanceof GroovyClassLoader) {
            this.configureLoadedClasses(((GroovyClassLoader)this.classLoader).getLoadedClasses());
        }
    }

    @Override
    public void rebuild() {
        this.initialised = false;
        this.loadedClasses.clear();
        this.initArtefactHandlers();
        if (!GrailsUtil.isDevelopmentEnv()) {
            throw new IllegalStateException("Cannot rebuild GrailsApplication when not in development mode!");
        }
        this.initialise();
    }

    @Override
    public org.springframework.core.io.Resource getResourceForClass(Class theClazz) {
        return null;
    }

    @Override
    public boolean isArtefact(Class theClazz) {
        String className = theClazz.getName();
        for (Class<?> artefactClass : this.allArtefactClasses) {
            if (!className.equals(artefactClass.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isArtefactOfType(String artefactType, Class theClazz) {
        ArtefactHandler handler = this.artefactHandlersByName.get(artefactType);
        if (handler == null) {
            throw new GrailsConfigurationException("Unable to locate arefact handler for specified type: " + artefactType);
        }
        return handler.isArtefact(theClazz);
    }

    @Override
    public boolean isArtefactOfType(String artefactType, String className) {
        return this.getArtefact(artefactType, className) != null;
    }

    @Override
    public GrailsClass getArtefact(String artefactType, String name) {
        ArtefactInfo info = this.getArtefactInfo(artefactType);
        return info == null ? null : info.getGrailsClass(name);
    }

    @Override
    public ArtefactHandler getArtefactType(Class theClass) {
        for (ArtefactHandler artefactHandler : this.artefactHandlers) {
            if (!artefactHandler.isArtefact(theClass)) continue;
            return artefactHandler;
        }
        return null;
    }

    protected GrailsClass getFirstArtefact(String artefactType) {
        ArtefactInfo info = this.getArtefactInfo(artefactType);
        return info == null ? null : info.getGrailsClasses()[0];
    }

    @Override
    public GrailsClass[] getArtefacts(String artefactType) {
        return this.getArtefactInfo(artefactType, true).getGrailsClasses();
    }

    @Override
    public GrailsClass addArtefact(String artefactType, Class artefactClass) {
        return this.addArtefact(artefactType, artefactClass, false);
    }

    @Override
    public GrailsClass addArtefact(String artefactType, GrailsClass artefactGrailsClass) {
        ArtefactHandler handler = this.artefactHandlersByName.get(artefactType);
        if (handler.isArtefactGrailsClass(artefactGrailsClass)) {
            DefaultArtefactInfo info = this.getArtefactInfo(artefactType, true);
            info.addGrailsClass(artefactGrailsClass);
            info.updateComplete();
            this.initializeArtefacts(artefactType);
            return artefactGrailsClass;
        }
        throw new GrailsConfigurationException("Cannot add " + artefactType + " class [" + artefactGrailsClass + "]. It is not a " + artefactType + "!");
    }

    @Override
    public void registerArtefactHandler(ArtefactHandler handler) {
        GrailsApplicationAwareBeanPostProcessor.processAwareInterfaces(this, handler);
        this.artefactHandlersByName.put(handler.getType(), handler);
        this.updateArtefactHandlers();
    }

    @Override
    public boolean hasArtefactHandler(String type) {
        return this.artefactHandlersByName.containsKey(type);
    }

    @Override
    public ArtefactHandler[] getArtefactHandlers() {
        return this.artefactHandlers;
    }

    @Override
    public ArtefactHandler getArtefactHandler(String type) {
        return this.artefactHandlersByName.get(type);
    }

    protected void initializeArtefacts(String artefactType) {
        this.initializeArtefacts(this.artefactHandlersByName.get(artefactType));
    }

    public void clear() {
        this.artefactHandlersByName.clear();
        this.updateArtefactHandlers();
        this.artefactInfo.clear();
        this.initialise();
    }

    protected void initializeArtefacts(ArtefactHandler handler) {
        if (handler == null) {
            return;
        }
        ArtefactInfo info = this.getArtefactInfo(handler.getType());
        if (info != null) {
            handler.initialize(info);
        }
    }

    protected DefaultArtefactInfo getArtefactInfo(String artefactType, boolean create) {
        DefaultArtefactInfo cache = (DefaultArtefactInfo)this.artefactInfo.get(artefactType);
        if (cache == null && create) {
            cache = new DefaultArtefactInfo();
            this.artefactInfo.put(artefactType, cache);
            cache.updateComplete();
        }
        return cache;
    }

    @Override
    public ArtefactInfo getArtefactInfo(String artefactType) {
        return this.getArtefactInfo(artefactType, false);
    }

    public Object invokeMethod(String methodName, Object args) {
        Object[] argsv = (Object[])args;
        Matcher match = GETCLASS_PATTERN.matcher(methodName);
        match.find();
        if (match.matches()) {
            if (argsv.length > 0) {
                if (argsv[0] instanceof CharSequence) {
                    argsv[0] = argsv[0].toString();
                }
                if (argsv.length != 1 || !(argsv[0] instanceof String)) {
                    throw new IllegalArgumentException("Dynamic method get<Artefact>Class(artefactName) requires a single String parameter");
                }
                return this.getArtefact(match.group(2), argsv[0].toString());
            }
            return super.invokeMethod(methodName, args);
        }
        match = ISCLASS_PATTERN.matcher(methodName);
        match.find();
        if (match.matches()) {
            if (argsv.length != 1 || !(argsv[0] instanceof Class)) {
                throw new IllegalArgumentException("Dynamic method is<Artefact>Class(artefactClass) requires a single Class parameter");
            }
            return this.isArtefactOfType(match.group(2), (Class)argsv[0]);
        }
        match = GETCLASSESMETH_PATTERN.matcher(methodName);
        match.find();
        if (match.matches()) {
            String artefactName = GrailsNameUtils.getClassNameRepresentation((String)match.group(2));
            if (this.artefactHandlersByName.containsKey(artefactName)) {
                return this.getArtefacts(match.group(2));
            }
            throw new IllegalArgumentException("Dynamic method get<Artefact>Classes() called for unrecognized artefact: " + match.group(2));
        }
        return super.invokeMethod(methodName, args);
    }

    public Object getProperty(String propertyName) {
        String artefactName;
        Matcher match = GETCLASSESPROP_PATTERN.matcher(propertyName);
        match.find();
        if (match.matches() && this.artefactHandlersByName.containsKey(artefactName = GrailsNameUtils.getClassNameRepresentation((String)match.group(1)))) {
            return this.getArtefacts(artefactName);
        }
        return super.getProperty(propertyName);
    }

    @Override
    public void initialise() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("loaded classes: [" + this.loadedClasses + "]"));
        }
        Class<?>[] classes = this.populateAllClasses();
        this.configureLoadedClasses(classes);
        DefaultGrailsApplication.initialiseGroovyExtensionModules();
        this.initialised = true;
    }

    protected static void initialiseGroovyExtensionModules() {
        if (extensionMethodsInitialized) {
            return;
        }
        extensionMethodsInitialized = true;
        HashMap map = new HashMap();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Enumeration<URL> resources = classLoader.getResources("META-INF/services/org.codehaus.groovy.runtime.ExtensionModule");
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                if (url.getPath().contains("groovy-all")) continue;
                Properties properties = new Properties();
                InputStream inStream = null;
                try {
                    inStream = url.openStream();
                    properties.load(inStream);
                    ((MetaClassRegistryImpl)GroovySystem.getMetaClassRegistry()).registerExtensionModuleFromProperties(properties, classLoader, map);
                }
                catch (IOException e) {
                    throw new GroovyRuntimeException("Unable to load module META-INF descriptor", (Throwable)e);
                }
                finally {
                    if (inStream == null) continue;
                    inStream.close();
                }
            }
        }
        catch (IOException resources) {
            // empty catch block
        }
        for (Map.Entry moduleMethods : map.entrySet()) {
            CachedClass cls = (CachedClass)moduleMethods.getKey();
            cls.addNewMopMethods((List)moduleMethods.getValue());
        }
    }

    @Override
    public GrailsClass getArtefactForFeature(String artefactType, Object featureID) {
        return this.artefactHandlersByName.get(artefactType).getArtefactForFeature(featureID);
    }

    @Override
    public boolean isInitialised() {
        return this.initialised;
    }

    @Override
    public GrailsClass getArtefactByLogicalPropertyName(String type, String logicalName) {
        ArtefactInfo info = this.getArtefactInfo(type);
        return info == null ? null : info.getGrailsClassByLogicalPropertyName(logicalName);
    }

    @Override
    public void addArtefact(Class artefact) {
        for (ArtefactHandler artefactHandler : this.artefactHandlers) {
            if (!artefactHandler.isArtefact(artefact)) continue;
            this.addArtefact(artefactHandler.getType(), artefact);
        }
    }

    @Override
    public void setBeanClassLoader(ClassLoader classLoader) {
    }

    @Override
    public void addOverridableArtefact(Class artefact) {
        for (ArtefactHandler artefactHandler : this.artefactHandlers) {
            if (!artefactHandler.isArtefact(artefact)) continue;
            this.addOverridableArtefact(artefactHandler.getType(), artefact);
        }
    }

    public GrailsClass addOverridableArtefact(String artefactType, Class artefactClass) {
        return this.addArtefact(artefactType, artefactClass, true);
    }

    protected GrailsClass addArtefact(String artefactType, Class<?> artefactClass, boolean overrideable) {
        ArtefactHandler handler = this.artefactHandlersByName.get(artefactType);
        if (handler != null && handler.isArtefact(artefactClass)) {
            GrailsClass artefactGrailsClass = handler.newArtefactClass(artefactClass);
            artefactGrailsClass.setGrailsApplication(this);
            DefaultArtefactInfo info = this.getArtefactInfo(artefactType, true);
            if (overrideable) {
                info.addOverridableGrailsClass(artefactGrailsClass);
            } else {
                info.addGrailsClass(artefactGrailsClass);
            }
            info.updateComplete();
            this.addToLoaded(artefactClass);
            if (this.isInitialised()) {
                this.initializeArtefacts(artefactType);
                ApplicationContext context = this.getMainContext();
                if (context instanceof ConfigurableApplicationContext && this.contextInitialized && ((ConfigurableApplicationContext)context).isActive()) {
                    context.publishEvent((ApplicationEvent)new ArtefactAdditionEvent(artefactGrailsClass));
                }
            }
            return artefactGrailsClass;
        }
        throw new GrailsConfigurationException("Cannot add " + artefactType + " class [" + artefactClass + "]. It is not a " + artefactType + "!");
    }
}

