/*
 * Decompiled with CFR 0.152.
 */
package org.grails.config;

import grails.config.Config;
import grails.util.GrailsStringUtils;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.grails.config.NavigableMap;
import org.grails.core.exceptions.GrailsConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.ConversionException;
import org.springframework.core.convert.support.ConfigurableConversionService;
import org.springframework.core.convert.support.DefaultConversionService;

public abstract class NavigableMapConfig
implements Config {
    protected static final Logger LOG = LoggerFactory.getLogger(NavigableMapConfig.class);
    protected ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
    protected ConfigurableConversionService conversionService = new DefaultConversionService();
    protected NavigableMap configMap = new NavigableMap(){

        protected Object mergeMapEntry(NavigableMap targetMap, String sourceKey, Object newValue) {
            if (newValue instanceof CharSequence) {
                newValue = NavigableMapConfig.this.resolvePlaceholders(newValue.toString());
            }
            return super.mergeMapEntry(targetMap, sourceKey, newValue);
        }
    };

    public int hashCode() {
        return this.configMap.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof NavigableMapConfig) {
            return this.configMap.equals((Object)((NavigableMapConfig)obj).configMap);
        }
        return false;
    }

    public String toString() {
        return this.configMap.toString();
    }

    public Object getAt(Object key) {
        return this.get(key);
    }

    public void setAt(Object key, Object value) {
        this.configMap.put(key.toString(), value);
    }

    public int size() {
        return this.configMap.size();
    }

    public boolean isEmpty() {
        return this.configMap.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.containsProperty(key.toString());
    }

    public boolean containsValue(Object value) {
        return this.configMap.containsValue(value);
    }

    public Object get(Object key) {
        return this.configMap.getProperty(key.toString());
    }

    public Object put(String key, Object value) {
        return this.configMap.put(key, value);
    }

    public Object remove(Object key) {
        return this.configMap.remove(key);
    }

    public void putAll(Map<? extends String, ?> m) {
        this.configMap.putAll(m);
    }

    public void clear() {
        this.configMap.clear();
    }

    public Set<String> keySet() {
        return this.configMap.keySet();
    }

    public Collection<Object> values() {
        return this.configMap.values();
    }

    public Set<Map.Entry<String, Object>> entrySet() {
        return this.configMap.entrySet();
    }

    @Override
    @Deprecated
    public Map<String, Object> flatten() {
        if (LOG.isWarnEnabled()) {
            LOG.warn("A plugin or your application called the flatten() method which can degrade startup performance");
        }
        return this.configMap;
    }

    @Override
    public Properties toProperties() {
        return this.configMap.toProperties();
    }

    public Object navigate(String ... path) {
        return this.configMap.navigate(path);
    }

    @Override
    public Config merge(Map<String, Object> toMerge) {
        this.configMap.merge(toMerge, true);
        return this;
    }

    public Object asType(Class c) {
        if (c == Boolean.class || c == Boolean.TYPE) {
            return false;
        }
        return null;
    }

    public Iterator<Map.Entry<String, Object>> iterator() {
        return DefaultGroovyMethods.iterator((Object)this.configMap);
    }

    public boolean containsProperty(String key) {
        return this.getProperty(key, Object.class) != null;
    }

    public String getProperty(String key) {
        return this.getProperty(key, String.class);
    }

    public String getProperty(String key, String defaultValue) {
        return this.getProperty(key, String.class, defaultValue);
    }

    public <T> T getProperty(String key, Class<T> targetType) {
        return this.getProperty(key, targetType, null);
    }

    @Override
    public <T> T getProperty(String key, Class<T> targetType, T defaultValue, List<T> allowedValues) {
        T value = this.getProperty(key, targetType, defaultValue);
        if (!allowedValues.contains(value)) {
            throw new GrailsConfigurationException("Invalid configuration value [$value] for key [${key}]. Possible values $allowedValues");
        }
        return value;
    }

    public <T> T getProperty(String key, Class<T> targetType, T defaultValue) {
        Object value = this.findInSystemEnvironment(key);
        if (value == null) {
            value = this.configMap.get((Object)key);
        }
        return this.convertValueIfNecessary(value, targetType, defaultValue);
    }

    private Object findInSystemEnvironment(String key) {
        String propertyName = this.resolvePropertyName(key);
        return propertyName != null ? System.getenv(propertyName) : null;
    }

    private String resolvePropertyName(String name) {
        String resolvedName = this.checkPropertyName(name);
        if (resolvedName != null) {
            return resolvedName;
        }
        String uppercasedName = name.toUpperCase();
        if (!name.equals(uppercasedName) && (resolvedName = this.checkPropertyName(uppercasedName)) != null) {
            return resolvedName;
        }
        return name;
    }

    private String checkPropertyName(String name) {
        if (this.containsKey(name)) {
            return name;
        }
        String noDotName = name.replace('.', '_');
        if (!name.equals(noDotName) && this.containsKey(noDotName)) {
            return noDotName;
        }
        String noHyphenName = name.replace('-', '_');
        if (!name.equals(noHyphenName) && this.containsKey(noHyphenName)) {
            return noHyphenName;
        }
        String noDotNoHyphenName = noDotName.replace('-', '_');
        if (!noDotName.equals(noDotNoHyphenName) && this.containsKey(noDotNoHyphenName)) {
            return noDotNoHyphenName;
        }
        return null;
    }

    private boolean containsKey(String name) {
        return System.getenv(name) != null;
    }

    private <T> T convertValueIfNecessary(Object originalValue, Class<T> targetType, T defaultValue) {
        block7: {
            if (originalValue != null) {
                if (targetType.isInstance(originalValue)) {
                    return (T)originalValue;
                }
                if (!(originalValue instanceof NavigableMap)) {
                    try {
                        Object value = this.conversionService.convert(originalValue, targetType);
                        return (T)(DefaultGroovyMethods.asBoolean((Object)value) ? value : defaultValue);
                    }
                    catch (ConversionException e) {
                        if (!targetType.isEnum()) break block7;
                        String stringValue = originalValue.toString();
                        try {
                            Object value = this.toEnumValue(targetType, stringValue);
                            return (T)value;
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        return defaultValue;
    }

    private Object toEnumValue(Class targetType, String stringValue) {
        return Enum.valueOf(targetType, stringValue.toUpperCase());
    }

    public String getRequiredProperty(String key) throws IllegalStateException {
        String value = this.getProperty(key);
        if (GrailsStringUtils.isBlank(value)) {
            throw new IllegalStateException("Value for key [" + key + "] cannot be resolved");
        }
        return value;
    }

    public <T> T getRequiredProperty(String key, Class<T> targetType) throws IllegalStateException {
        T value = this.getProperty(key, targetType);
        if (value == null) {
            throw new IllegalStateException("Value for key [" + key + "] cannot be resolved");
        }
        return value;
    }

    public static class ClassConversionException
    extends ConversionException {
        public ClassConversionException(Class<?> actual, Class<?> expected) {
            super(String.format("Actual type %s is not assignable to expected type %s", actual.getName(), expected.getName()));
        }

        public ClassConversionException(String actual, Class<?> expected, Exception ex) {
            super(String.format("Could not find/load class %s during attempt to convert to %s", actual, expected.getName()), (Throwable)ex);
        }
    }
}

