/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.amf.io.util.instantiator;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.granite.messaging.amf.io.util.instantiator.AbstractInstantiator;
import org.granite.messaging.service.ServiceException;

public class BigIntegerInstantiator
extends AbstractInstantiator<BigInteger> {
    private static final long serialVersionUID = 1L;
    private static final String VALUE = "value";
    private static final List<String> orderedFields;

    @Override
    public List<String> getOrderedFieldNames() {
        return orderedFields;
    }

    @Override
    public BigInteger newInstance() {
        BigInteger bigInteger = null;
        String value = (String)this.get(VALUE);
        if (value != null && value.length() == 1) {
            switch (Character.toLowerCase(value.charAt(0))) {
                case '0': {
                    bigInteger = BigInteger.ZERO;
                    break;
                }
                case '1': {
                    bigInteger = BigInteger.ONE;
                    break;
                }
                case 'a': {
                    bigInteger = BigInteger.TEN;
                }
            }
        }
        if (bigInteger == null) {
            try {
                bigInteger = new BigInteger(value, 36);
            }
            catch (NumberFormatException e) {
                throw new ServiceException("Illegal BigInteger value (base 36): " + value, e);
            }
        }
        return bigInteger;
    }

    static {
        ArrayList<String> of = new ArrayList<String>(1);
        of.add(VALUE);
        orderedFields = Collections.unmodifiableList(of);
    }
}

