/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.jmf.codec.std.impl;

import java.io.IOException;
import java.io.OutputStream;
import org.granite.messaging.jmf.DumpContext;
import org.granite.messaging.jmf.InputContext;
import org.granite.messaging.jmf.OutputContext;
import org.granite.messaging.jmf.codec.std.ShortCodec;
import org.granite.messaging.jmf.codec.std.impl.AbstractStandardCodec;

public class ShortCodecImpl
extends AbstractStandardCodec<Short>
implements ShortCodec {
    @Override
    public int getObjectType() {
        return 25;
    }

    @Override
    public Class<?> getObjectClass() {
        return Short.class;
    }

    @Override
    public int getPrimitiveType() {
        return 24;
    }

    @Override
    public Class<?> getPrimitiveClass() {
        return Short.TYPE;
    }

    @Override
    public void encode(OutputContext ctx, Short v) throws IOException {
        this.writeShortData(ctx, 25, v.intValue());
    }

    @Override
    public Short decode(InputContext ctx, int parameterizedJmfType) throws IOException {
        int jmfType = ctx.getSharedContext().getCodecRegistry().extractJmfType(parameterizedJmfType);
        if (jmfType != 25) {
            throw this.newBadTypeJMFEncodingException(jmfType, parameterizedJmfType);
        }
        return this.readShortData(ctx, parameterizedJmfType);
    }

    @Override
    public void encodePrimitive(OutputContext ctx, int v) throws IOException {
        this.writeShortData(ctx, 24, v);
    }

    @Override
    public short decodePrimitive(InputContext ctx) throws IOException {
        int parameterizedJmfType = ctx.safeRead();
        int jmfType = ctx.getSharedContext().getCodecRegistry().extractJmfType(parameterizedJmfType);
        if (jmfType != 24) {
            throw this.newBadTypeJMFEncodingException(jmfType, parameterizedJmfType);
        }
        return this.readShortData(ctx, parameterizedJmfType);
    }

    @Override
    public void dump(DumpContext ctx, int parameterizedJmfType) throws IOException {
        int jmfType = ctx.getSharedContext().getCodecRegistry().extractJmfType(parameterizedJmfType);
        switch (jmfType) {
            case 24: {
                ctx.indentPrintLn("short: " + this.readShortData(ctx, parameterizedJmfType));
                break;
            }
            case 25: {
                ctx.indentPrintLn(Short.class.getName() + ": " + Short.valueOf(this.readShortData(ctx, parameterizedJmfType)));
                break;
            }
            default: {
                throw this.newBadTypeJMFEncodingException(jmfType, parameterizedJmfType);
            }
        }
    }

    public void writeShortData(OutputContext ctx, int jmfType, int v) throws IOException {
        OutputStream os = ctx.getOutputStream();
        if (v == Short.MIN_VALUE) {
            os.write(0x40 | jmfType);
            os.write(v >> 8);
            os.write(v);
        } else {
            int s = 0;
            int a = v;
            if (v < 0) {
                a = -v;
                s = 128;
            }
            if (a <= 255) {
                os.write(s | jmfType);
                os.write(a);
            } else {
                os.write(s | 0x40 | jmfType);
                os.write(a >> 8);
                os.write(a);
            }
        }
    }

    public short readShortData(InputContext ctx, int parameterizedJmfType) throws IOException {
        short v = (short)ctx.safeRead();
        if ((parameterizedJmfType & 0x40) != 0) {
            v = (short)(v << 8 | ctx.safeRead());
        }
        if ((parameterizedJmfType & 0x80) != 0) {
            v = -v;
        }
        return v;
    }
}

