/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.invocation;

import java.io.Serializable;
import org.granite.tide.Expression;

public class ContextResult
implements Serializable,
Expression {
    private static final long serialVersionUID = 1L;
    private String componentName;
    private String componentClassName;
    private String expression;
    private Class<?> componentClass;

    public ContextResult() {
    }

    public ContextResult(String componentName, String expression) {
        this.componentName = componentName;
        this.expression = expression;
    }

    @Override
    public String getComponentName() {
        return this.componentName;
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    @Override
    public String getComponentClassName() {
        return this.componentClassName;
    }

    public void setComponentClassName(String componentClassName) {
        this.componentClassName = componentClassName;
    }

    public Class<?> getComponentClass() {
        if (this.componentClassName == null) {
            return null;
        }
        if (this.componentClass == null) {
            try {
                this.componentClass = Thread.currentThread().getContextClassLoader().loadClass(this.componentClassName);
            }
            catch (Exception e) {
                throw new RuntimeException("Component class not found", e);
            }
        }
        return this.componentClass;
    }

    @Override
    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public Boolean getRestrict() {
        return null;
    }

    @Override
    public String getPath() {
        return this.componentName + (this.expression != null ? "." + this.expression : "");
    }

    public boolean matches(String componentName, String componentClassName, String expr) {
        if (this.componentClassName != null && componentClassName != null && (this.componentClassName + (this.expression != null ? "." + this.expression : "")).indexOf(componentClassName + (expr != null ? "." + expr : "")) == 0) {
            return true;
        }
        return this.getPath().indexOf(componentName + (expr != null ? "." + expr : "")) == 0;
    }

    public String toString() {
        return (this.componentName != null ? this.componentName : "") + (this.componentClassName != null ? "(" + this.componentClassName + ")" : "") + (this.expression != null ? "." + this.expression : "");
    }

    public int hashCode() {
        return (this.componentName + "(" + this.componentClassName + ")." + this.expression).hashCode();
    }

    public boolean equals(Object object) {
        if (object == null || !object.getClass().equals(this.getClass())) {
            return false;
        }
        ContextResult result = (ContextResult)object;
        if (!(result.getComponentName() != null || this.componentName != null || result.getComponentClassName() == null && this.componentClassName == null || result.getComponentClassName().equals(this.componentClassName))) {
            return false;
        }
        if (result.getComponentName() != null && !result.getComponentName().equals(this.componentName)) {
            return false;
        }
        if (result.getComponentClassName() != null && this.componentClassName != null && !result.getComponentClassName().equals(this.componentClassName)) {
            return false;
        }
        if (this.expression == null) {
            return result.getExpression() == null;
        }
        return this.expression.equals(result.getExpression());
    }
}

