/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.amf.io;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.UTFDataFormatException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.granite.context.GraniteContext;
import org.granite.logging.Logger;
import org.granite.messaging.amf.AMF3Constants;
import org.granite.messaging.amf.io.AMF3DeserializerSecurizer;
import org.granite.messaging.amf.io.AMF3SerializationException;
import org.granite.messaging.amf.io.util.ActionScriptClassDescriptor;
import org.granite.messaging.amf.io.util.DefaultActionScriptClassDescriptor;
import org.granite.messaging.amf.io.util.externalizer.Externalizer;
import org.granite.messaging.amf.io.util.instantiator.AbstractInstantiator;
import org.granite.util.TypeUtil;
import org.granite.util.XMLUtil;
import org.granite.util.XMLUtilFactory;
import org.w3c.dom.Document;

public class AMF3Deserializer
extends DataInputStream
implements ObjectInput,
AMF3Constants {
    protected static final Logger log = Logger.getLogger(AMF3Deserializer.class);
    protected static final Logger logMore = Logger.getLogger(AMF3Deserializer.class.getName() + "_MORE");
    protected final List<String> storedStrings = new ArrayList<String>();
    protected final List<Object> storedObjects = new ArrayList<Object>();
    protected final List<ActionScriptClassDescriptor> storedClassDescriptors = new ArrayList<ActionScriptClassDescriptor>();
    protected final GraniteContext context = GraniteContext.getCurrentInstance();
    protected final AMF3DeserializerSecurizer securizer = this.context.getGraniteConfig().getAmf3DeserializerSecurizer();
    protected final XMLUtil xmlUtil = XMLUtilFactory.getXMLUtil();
    protected final boolean debug = log.isDebugEnabled();
    protected final boolean debugMore = logMore.isDebugEnabled();

    public AMF3Deserializer(InputStream in) {
        super(in);
        if (this.debugMore) {
            logMore.debug("new AMF3Deserializer(in=%s)", in);
        }
    }

    @Override
    public Object readObject() throws IOException {
        if (this.debugMore) {
            logMore.debug("readObject()...", new Object[0]);
        }
        try {
            int type = this.readAMF3Integer();
            return this.readObject(type);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AMF3SerializationException(e);
        }
    }

    protected Object readObject(int type) throws IOException {
        if (this.debugMore) {
            logMore.debug("readObject(type=0x%02X)", type);
        }
        switch (type) {
            case 0: 
            case 1: {
                return null;
            }
            case 2: {
                return Boolean.FALSE;
            }
            case 3: {
                return Boolean.TRUE;
            }
            case 4: {
                return this.readAMF3Integer();
            }
            case 5: {
                return this.readAMF3Double();
            }
            case 6: {
                return this.readAMF3String();
            }
            case 7: {
                return this.readAMF3Xml();
            }
            case 8: {
                return this.readAMF3Date();
            }
            case 9: {
                return this.readAMF3Array();
            }
            case 10: {
                return this.readAMF3Object();
            }
            case 11: {
                return this.readAMF3XmlString();
            }
            case 12: {
                return this.readAMF3ByteArray();
            }
            case 13: {
                return this.readAMF3VectorInt();
            }
            case 14: {
                return this.readAMF3VectorUint();
            }
            case 15: {
                return this.readAMF3VectorNumber();
            }
            case 16: {
                return this.readAMF3VectorObject();
            }
            case 17: {
                return this.readAMF3Dictionary();
            }
        }
        throw new IllegalArgumentException("Unknown type: " + type);
    }

    protected int readAMF3Integer() throws IOException {
        int n;
        int result = 0;
        int b = this.readUnsignedByte();
        for (n = 0; (b & 0x80) != 0 && n < 3; ++n) {
            result <<= 7;
            result |= b & 0x7F;
            b = this.readUnsignedByte();
        }
        if (n < 3) {
            result <<= 7;
            result |= b;
        } else {
            result <<= 8;
            if (((result |= b) & 0x10000000) != 0) {
                result |= 0xE0000000;
            }
        }
        if (this.debugMore) {
            logMore.debug("readAMF3Integer() -> %d", result);
        }
        return result;
    }

    protected Double readAMF3Double() throws IOException {
        Double result;
        double d = this.readDouble();
        Double d2 = result = Double.isNaN(d) ? null : Double.valueOf(d);
        if (this.debugMore) {
            logMore.debug("readAMF3Double() -> %f", result);
        }
        return result;
    }

    protected String readAMF3String() throws IOException {
        int type;
        String result = null;
        if (this.debugMore) {
            logMore.debug("readAMF3String()...", new Object[0]);
        }
        if (((type = this.readAMF3Integer()) & 1) == 0) {
            result = this.getFromStoredStrings(type >> 1);
        } else {
            int length = type >> 1;
            if (this.debugMore) {
                logMore.debug("readAMF3String() - length=%d", length);
            }
            if (length > 0) {
                byte[] utfBytes = new byte[length];
                char[] utfChars = new char[length];
                this.readFully(utfBytes);
                int iBytes = 0;
                int iChars = 0;
                block4: while (iBytes < length) {
                    int c;
                    if ((c = utfBytes[iBytes++] & 0xFF) <= 127) {
                        utfChars[iChars++] = (char)c;
                        continue;
                    }
                    switch (c >> 4) {
                        case 12: 
                        case 13: {
                            byte c2 = utfBytes[iBytes++];
                            if ((c2 & 0xC0) != 128) {
                                throw new UTFDataFormatException("Malformed input around byte " + (iBytes - 2));
                            }
                            utfChars[iChars++] = (char)((c & 0x1F) << 6 | c2 & 0x3F);
                            continue block4;
                        }
                        case 14: {
                            byte c2 = utfBytes[iBytes++];
                            byte c3 = utfBytes[iBytes++];
                            if ((c2 & 0xC0) != 128 || (c3 & 0xC0) != 128) {
                                throw new UTFDataFormatException("Malformed input around byte " + (iBytes - 3));
                            }
                            utfChars[iChars++] = (char)((c & 0xF) << 12 | (c2 & 0x3F) << 6 | (c3 & 0x3F) << 0);
                            continue block4;
                        }
                    }
                    throw new UTFDataFormatException("Malformed input around byte " + (iBytes - 1));
                }
                result = new String(utfChars, 0, iChars);
                if (this.debugMore) {
                    logMore.debug("readAMF3String() - result=%s", result);
                }
                this.addToStoredStrings(result);
            } else {
                result = "";
            }
        }
        if (this.debugMore) {
            logMore.debug("readAMF3String() -> %s", result);
        }
        return result;
    }

    protected Date readAMF3Date() throws IOException {
        Date result = null;
        int type = this.readAMF3Integer();
        if ((type & 1) == 0) {
            result = (Date)this.getFromStoredObjects(type >> 1);
        } else {
            result = new Date((long)this.readDouble());
            this.addToStoredObjects(result);
        }
        if (this.debugMore) {
            logMore.debug("readAMF3Date() -> %s", result);
        }
        return result;
    }

    protected Object readAMF3Array() throws IOException {
        Object result = null;
        int type = this.readAMF3Integer();
        if ((type & 1) == 0) {
            result = this.getFromStoredObjects(type >> 1);
        } else {
            int size = type >> 1;
            String key = this.readAMF3String();
            if (key.length() == 0) {
                Object[] objects = new Object[size];
                this.addToStoredObjects(objects);
                for (int i = 0; i < size; ++i) {
                    objects[i] = this.readObject();
                }
                result = objects;
            } else {
                HashMap<Object, Object> map = new HashMap<Object, Object>();
                this.addToStoredObjects(map);
                while (key.length() > 0) {
                    map.put(key, this.readObject());
                    key = this.readAMF3String();
                }
                for (int i = 0; i < size; ++i) {
                    map.put(i, this.readObject());
                }
                result = map;
            }
        }
        if (this.debugMore) {
            logMore.debug("readAMF3Array() -> %s", result);
        }
        return result;
    }

    protected int[] readAMF3VectorInt() throws IOException {
        int[] vector = null;
        int type = this.readAMF3Integer();
        if ((type & 1) == 0) {
            vector = (int[])this.getFromStoredObjects(type >> 1);
        } else {
            int length = type >> 1;
            vector = new int[length];
            this.addToStoredObjects(vector);
            boolean fixedLength = this.readAMF3Integer() == 1;
            for (int i = 0; i < length; ++i) {
                vector[i] = this.readInt();
            }
        }
        if (this.debugMore) {
            logMore.debug("readAMF3VectorInt() -> %s", new Object[]{vector});
        }
        return vector;
    }

    protected long[] readAMF3VectorUint() throws IOException {
        long[] vector = null;
        int type = this.readAMF3Integer();
        if ((type & 1) == 0) {
            vector = (long[])this.getFromStoredObjects(type >> 1);
        } else {
            int length = type >> 1;
            vector = new long[length];
            this.addToStoredObjects(vector);
            boolean fixedLength = this.readAMF3Integer() == 1;
            for (int i = 0; i < length; ++i) {
                vector[i] = (long)this.readInt() & 0xFFFFFFFFL;
            }
        }
        if (this.debugMore) {
            logMore.debug("readAMF3VectorUInt() -> %s", new Object[]{vector});
        }
        return vector;
    }

    protected double[] readAMF3VectorNumber() throws IOException {
        double[] vector = null;
        int type = this.readAMF3Integer();
        if ((type & 1) == 0) {
            vector = (double[])this.getFromStoredObjects(type >> 1);
        } else {
            int length = type >> 1;
            vector = new double[length];
            this.addToStoredObjects(vector);
            boolean fixedLength = this.readAMF3Integer() == 1;
            for (int i = 0; i < length; ++i) {
                vector[i] = this.readDouble();
            }
        }
        if (this.debugMore) {
            logMore.debug("readAMF3VectorDouble() -> %s", new Object[]{vector});
        }
        return vector;
    }

    protected List<Object> readAMF3VectorObject() throws IOException {
        ArrayList<Object> vector = null;
        int type = this.readAMF3Integer();
        if ((type & 1) == 0) {
            vector = (ArrayList<Object>)this.getFromStoredObjects(type >> 1);
        } else {
            int length = type >> 1;
            vector = new ArrayList<Object>(length);
            this.addToStoredObjects(vector);
            boolean fixedLength = this.readAMF3Integer() == 1;
            String componentClassName = this.readAMF3String();
            for (int i = 0; i < length; ++i) {
                vector.add(this.readObject());
            }
        }
        if (this.debugMore) {
            logMore.debug("readAMF3VectorObject() -> %s", vector);
        }
        return vector;
    }

    protected Map<Object, Object> readAMF3Dictionary() throws IOException {
        HashMap<Object, Object> dictionary = null;
        int type = this.readAMF3Integer();
        if ((type & 1) == 0) {
            dictionary = (HashMap<Object, Object>)this.getFromStoredObjects(type >> 1);
        } else {
            int length = type >> 1;
            dictionary = new HashMap<Object, Object>(length);
            this.addToStoredObjects(dictionary);
            boolean weakKeys = this.readAMF3Integer() == 1;
            for (int i = 0; i < length; ++i) {
                Object key = this.readObject();
                Object value = this.readObject();
                dictionary.put(key, value);
            }
        }
        if (this.debugMore) {
            logMore.debug("readAMF3Dictionary() -> %s", dictionary);
        }
        return dictionary;
    }

    protected Object readAMF3Object() throws IOException {
        if (this.debug) {
            log.debug("readAMF3Object()...", new Object[0]);
        }
        Object result = null;
        int type = this.readAMF3Integer();
        if (this.debug) {
            log.debug("readAMF3Object() - type=0x%02X", type);
        }
        if ((type & 1) == 0) {
            result = this.getFromStoredObjects(type >> 1);
        } else {
            boolean inlineClassDef;
            boolean bl = inlineClassDef = (type >> 1 & 1) != 0;
            if (this.debug) {
                log.debug("readAMF3Object() - inlineClassDef=%b", inlineClassDef);
            }
            ActionScriptClassDescriptor desc = null;
            if (inlineClassDef) {
                int propertiesCount = type >> 4;
                if (this.debug) {
                    log.debug("readAMF3Object() - propertiesCount=%d", propertiesCount);
                }
                byte encoding = (byte)(type >> 2 & 3);
                if (this.debug) {
                    log.debug("readAMF3Object() - encoding=%d", encoding);
                }
                String alias = this.readAMF3String();
                String className = this.context.getGraniteConfig().getAliasRegistry().getTypeForAlias(alias);
                if (this.debug) {
                    log.debug("readAMF3Object() - alias=%, className=%s", alias, className);
                }
                if (this.securizer != null && !this.securizer.allowInstantiation(className)) {
                    throw new SecurityException("Illegal attempt to instantiate class: " + className + ", securizer: " + this.securizer.getClass());
                }
                Class<? extends ActionScriptClassDescriptor> descriptorType = null;
                if (!"".equals(className)) {
                    descriptorType = this.context.getGraniteConfig().getActionScriptDescriptor(className);
                }
                if (this.debug) {
                    log.debug("readAMF3Object() - descriptorType=%s", descriptorType);
                }
                if (descriptorType != null) {
                    Class[] argsDef = new Class[]{String.class, Byte.TYPE};
                    Object[] argsVal = new Object[]{className, encoding};
                    try {
                        desc = TypeUtil.newInstance(descriptorType, argsDef, argsVal);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Could not instantiate AS descriptor: " + descriptorType, e);
                    }
                }
                if (desc == null) {
                    desc = new DefaultActionScriptClassDescriptor(className, encoding);
                }
                this.addToStoredClassDescriptors(desc);
                if (this.debug) {
                    log.debug("readAMF3Object() - defining %d properties...", propertiesCount);
                }
                for (int i = 0; i < propertiesCount; ++i) {
                    String name = this.readAMF3String();
                    if (this.debug) {
                        log.debug("readAMF3Object() - defining property name=%s", name);
                    }
                    desc.defineProperty(name);
                }
            } else {
                desc = this.getFromStoredClassDescriptors(type >> 2);
            }
            if (this.debug) {
                log.debug("readAMF3Object() - actionScriptClassDescriptor=%s", desc);
            }
            byte objectEncoding = desc.getEncoding();
            Externalizer externalizer = desc.getExternalizer();
            if (externalizer != null) {
                try {
                    result = externalizer.newInstance(desc.getType(), this);
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not instantiate type: " + desc.getType(), e);
                }
            } else {
                result = desc.newJavaInstance();
            }
            int index = this.addToStoredObjects(result);
            if (result == null) {
                if (this.debug) {
                    log.debug("readAMF3Object() - Added null object to stored objects for actionScriptClassDescriptor=%s", desc);
                }
                return null;
            }
            if ((objectEncoding & 1) != 0) {
                if (externalizer != null) {
                    if (this.debug) {
                        log.debug("readAMF3Object() - using externalizer=%s", externalizer);
                    }
                    try {
                        externalizer.readExternal(result, this);
                    }
                    catch (IOException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Could not read externalized object: " + result, e);
                    }
                } else {
                    if (this.debug) {
                        log.debug("readAMF3Object() - legacy Externalizable=%s", result.getClass());
                    }
                    if (!(result instanceof Externalizable)) {
                        throw new RuntimeException("The ActionScript3 class bound to " + result.getClass().getName() + " (ie: [RemoteClass(alias=\"" + result.getClass().getName() + "\")])" + " implements flash.utils.IExternalizable but this Java class neither" + " implements java.io.Externalizable nor is in the scope of a configured" + " externalizer (please fix your granite-config.xml)");
                    }
                    try {
                        ((Externalizable)result).readExternal(this);
                    }
                    catch (IOException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Could not read externalizable object: " + result, e);
                    }
                }
            } else {
                if (desc.getPropertiesCount() > 0) {
                    if (this.debug) {
                        log.debug("readAMF3Object() - reading defined properties...", new Object[0]);
                    }
                    for (int i = 0; i < desc.getPropertiesCount(); ++i) {
                        byte vType = this.readByte();
                        Object value = this.readObject(vType);
                        if (this.debug) {
                            log.debug("readAMF3Object() - setting defined property: %s=%s", desc.getPropertyName(i), value);
                        }
                        desc.setPropertyValue(i, result, value);
                    }
                }
                if (objectEncoding == 2) {
                    String name;
                    if (this.debug) {
                        log.debug("readAMF3Object() - reading dynamic properties...", new Object[0]);
                    }
                    while ((name = this.readAMF3String()).length() != 0) {
                        byte vType = this.readByte();
                        Object value = this.readObject(vType);
                        if (this.debug) {
                            log.debug("readAMF3Object() - setting dynamic property: %s=%s", name, value);
                        }
                        desc.setPropertyValue(name, result, value);
                    }
                }
            }
            if (result instanceof AbstractInstantiator) {
                if (this.debug) {
                    log.debug("readAMF3Object() - resolving instantiator...", new Object[0]);
                }
                try {
                    result = ((AbstractInstantiator)result).resolve();
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not instantiate object: " + result, e);
                }
                this.setStoredObject(index, result);
            }
        }
        if (this.debug) {
            log.debug("readAMF3Object() -> %s", result);
        }
        return result;
    }

    protected Document readAMF3Xml() throws IOException {
        String xml = this.readAMF3XmlString();
        Document result = this.xmlUtil.buildDocument(xml);
        if (this.debugMore) {
            logMore.debug("readAMF3Xml() -> %s", result);
        }
        return result;
    }

    protected String readAMF3XmlString() throws IOException {
        String result = null;
        int type = this.readAMF3Integer();
        if ((type & 1) == 0) {
            result = (String)this.getFromStoredObjects(type >> 1);
        } else {
            byte[] bytes = this.readBytes(type >> 1);
            result = new String(bytes, "UTF-8");
            this.addToStoredObjects(result);
        }
        if (this.debugMore) {
            logMore.debug("readAMF3XmlString() -> %s", result);
        }
        return result;
    }

    protected byte[] readAMF3ByteArray() throws IOException {
        byte[] result = null;
        int type = this.readAMF3Integer();
        if ((type & 1) == 0) {
            result = (byte[])this.getFromStoredObjects(type >> 1);
        } else {
            result = this.readBytes(type >> 1);
            this.addToStoredObjects(result);
        }
        if (this.debugMore) {
            logMore.debug("readAMF3ByteArray() -> %s", new Object[]{result});
        }
        return result;
    }

    protected void addToStoredStrings(String s) {
        if (this.debug) {
            log.debug("addToStoredStrings(s=%s) at index=%d", s, this.storedStrings.size());
        }
        this.storedStrings.add(s);
    }

    protected String getFromStoredStrings(int index) {
        if (this.debug) {
            log.debug("getFromStoredStrings(index=%d)", index);
        }
        String s = this.storedStrings.get(index);
        if (this.debug) {
            log.debug("getFromStoredStrings() -> %s", s);
        }
        return s;
    }

    protected int addToStoredObjects(Object o) {
        int index = this.storedObjects.size();
        if (this.debug) {
            log.debug("addToStoredObjects(o=%s) at index=%d", o, index);
        }
        this.storedObjects.add(o);
        return index;
    }

    protected void setStoredObject(int index, Object o) {
        if (this.debug) {
            log.debug("setStoredObject(index=%d, o=%s)", index, o);
        }
        this.storedObjects.set(index, o);
    }

    protected Object getFromStoredObjects(int index) {
        if (this.debug) {
            log.debug("getFromStoredObjects(index=%d)", index);
        }
        Object o = this.storedObjects.get(index);
        if (this.debug) {
            log.debug("getFromStoredObjects() -> %s", o);
        }
        return o;
    }

    protected void addToStoredClassDescriptors(ActionScriptClassDescriptor desc) {
        if (this.debug) {
            log.debug("addToStoredClassDescriptors(desc=%s) at index=%d", desc, this.storedClassDescriptors.size());
        }
        this.storedClassDescriptors.add(desc);
    }

    protected ActionScriptClassDescriptor getFromStoredClassDescriptors(int index) {
        if (this.debug) {
            log.debug("getFromStoredClassDescriptors(index=%d)", index);
        }
        ActionScriptClassDescriptor desc = this.storedClassDescriptors.get(index);
        if (this.debug) {
            log.debug("getFromStoredClassDescriptors() -> %s", desc);
        }
        return desc;
    }

    protected byte[] readBytes(int count) throws IOException {
        byte[] bytes = new byte[count];
        int b = -1;
        for (int i = 0; i < count; ++i) {
            b = this.in.read();
            if (b == -1) {
                throw new EOFException();
            }
            bytes[i] = (byte)b;
        }
        return bytes;
    }
}

