/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.jmf;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.granite.messaging.annotations.Include;
import org.granite.messaging.jmf.CodecRegistry;
import org.granite.messaging.jmf.InputContext;
import org.granite.messaging.jmf.JMFEncodingException;
import org.granite.messaging.jmf.JMFUnresolvedSharedObjectException;
import org.granite.messaging.jmf.SharedContext;
import org.granite.messaging.jmf.codec.StandardCodec;
import org.granite.messaging.reflect.NoopWritableProperty;
import org.granite.messaging.reflect.Property;
import org.granite.messaging.reflect.Reflection;

public class JMFDeserializer
implements InputContext {
    protected final List<String> storedStrings = new ArrayList<String>(256);
    protected final List<Object> storedObjects = new ArrayList<Object>(256);
    protected final InputStream inputStream;
    protected final SharedContext context;
    protected final CodecRegistry codecRegistry;

    public JMFDeserializer(InputStream is, SharedContext context) {
        this.inputStream = is;
        this.context = context;
        this.codecRegistry = context.getCodecRegistry();
        this.storedStrings.addAll(context.getDefaultStoredStrings());
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.codecRegistry.getBooleanCodec().decodePrimitive(this);
    }

    @Override
    public byte readByte() throws IOException {
        return this.codecRegistry.getByteCodec().decodePrimitive(this);
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.readByte() & 0xFF;
    }

    @Override
    public short readShort() throws IOException {
        return this.codecRegistry.getShortCodec().decodePrimitive(this);
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.readShort() & 0xFFFF;
    }

    @Override
    public char readChar() throws IOException {
        return this.codecRegistry.getCharacterCodec().decodePrimitive(this);
    }

    @Override
    public int readInt() throws IOException {
        return this.codecRegistry.getIntegerCodec().decodePrimitive(this);
    }

    @Override
    public long readLong() throws IOException {
        return this.codecRegistry.getLongCodec().decodePrimitive(this);
    }

    @Override
    public float readFloat() throws IOException {
        return this.codecRegistry.getFloatCodec().decodePrimitive(this);
    }

    @Override
    public double readDouble() throws IOException {
        return this.codecRegistry.getDoubleCodec().decodePrimitive(this);
    }

    @Override
    public String readUTF() throws IOException {
        int parameterizedJmfType = this.safeRead();
        if (parameterizedJmfType == 120) {
            return (String)this.codecRegistry.getNullCodec().decode(this, parameterizedJmfType);
        }
        return this.codecRegistry.getStringCodec().decode(this, parameterizedJmfType);
    }

    @Override
    public Object readObject() throws ClassNotFoundException, IOException {
        int parameterizedJmfType = this.safeRead();
        int jmfType = this.codecRegistry.extractJmfType(parameterizedJmfType);
        StandardCodec codec = this.codecRegistry.getCodec(jmfType);
        if (codec == null) {
            throw new JMFEncodingException("Unsupported JMF type: " + jmfType);
        }
        try {
            return codec.decode(this, parameterizedJmfType);
        }
        catch (InvocationTargetException e) {
            throw new IOException(e.getTargetException());
        }
        catch (IllegalAccessException e) {
            throw new IOException(e);
        }
        catch (InstantiationException e) {
            throw new IOException(e);
        }
        catch (NoSuchMethodException e) {
            throw new IOException(e);
        }
    }

    @Override
    public int available() throws IOException {
        return this.inputStream.available();
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }

    @Override
    @Deprecated
    public int read() throws IOException {
        throw new UnsupportedOperationException("Use readByte()");
    }

    @Override
    @Deprecated
    public int read(byte[] b) throws IOException {
        throw new UnsupportedOperationException("Use (byte[])readObject()");
    }

    @Override
    @Deprecated
    public int read(byte[] b, int off, int len) throws IOException {
        throw new UnsupportedOperationException("Use (byte[])readObject()");
    }

    @Override
    @Deprecated
    public void readFully(byte[] b) throws IOException {
        throw new UnsupportedOperationException("Use (byte[])readObject()");
    }

    @Override
    @Deprecated
    public void readFully(byte[] b, int off, int len) throws IOException {
        throw new UnsupportedOperationException("Use (byte[])readObject()");
    }

    @Override
    @Deprecated
    public String readLine() throws IOException {
        throw new UnsupportedOperationException("Use readUTF()");
    }

    @Override
    @Deprecated
    public int skipBytes(int n) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public long skip(long n) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public SharedContext getSharedContext() {
        return this.context;
    }

    @Override
    public InputStream getInputStream() {
        return this.inputStream;
    }

    @Override
    public int safeRead() throws IOException {
        int b = this.inputStream.read();
        if (b == -1) {
            throw new EOFException();
        }
        return b;
    }

    @Override
    public void safeReadFully(byte[] b) throws IOException {
        this.safeReadFully(b, 0, b.length);
    }

    @Override
    public void safeReadFully(byte[] b, int off, int len) throws IOException {
        int read;
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException("b.length=" + b.length + ", off=" + off + ", len" + len);
        }
        if (len == 0) {
            return;
        }
        do {
            if ((read = this.inputStream.read(b, off, len)) == -1) {
                throw new EOFException();
            }
            off += read;
        } while ((len -= read) > 0);
    }

    @Override
    public void safeSkip(long n) throws IOException {
        while (n > 0L) {
            if (this.inputStream.read() == -1) {
                throw new EOFException();
            }
            --n;
        }
    }

    @Override
    public int addSharedString(String s) {
        int index = this.storedStrings.size();
        this.storedStrings.add(index, s);
        return index;
    }

    @Override
    public String getSharedString(int index) {
        return this.storedStrings.get(index);
    }

    @Override
    public int addSharedObject(Object o) {
        int index = this.storedObjects.size();
        this.storedObjects.add(index, o);
        return index;
    }

    @Override
    public Object getSharedObject(int index) {
        Object o = this.storedObjects.get(index);
        if (o instanceof UnresolvedSharedObject) {
            throw new JMFUnresolvedSharedObjectException("Unresolved shared object: " + o);
        }
        return o;
    }

    @Override
    public int addUnresolvedSharedObject(String className) {
        int index = this.storedObjects.size();
        this.storedObjects.add(index, new UnresolvedSharedObject(className, index));
        return index;
    }

    @Override
    public Object setUnresolvedSharedObject(int index, Object o) {
        Object uso = this.storedObjects.set(index, o);
        if (!(uso instanceof UnresolvedSharedObject)) {
            throw new JMFUnresolvedSharedObjectException("Not an unresolved shared object: " + uso);
        }
        return uso;
    }

    @Override
    public Reflection getReflection() {
        return this.context.getReflection();
    }

    @Override
    public String getAlias(String remoteAlias) {
        return this.context.getClassName(remoteAlias);
    }

    @Override
    public void readAndSetProperty(Object obj, Property property) throws IOException, ClassNotFoundException, IllegalAccessException, InvocationTargetException {
        if (property.isAnnotationPresent(Include.class) && !property.isWritable()) {
            property = new NoopWritableProperty(property.getName(), property.getType());
        }
        if (property.getType().isPrimitive()) {
            this.codecRegistry.getPrimitivePropertyCodec(property.getType()).decodePrimitive(this, obj, property);
        } else {
            property.setObject(obj, this.readObject());
        }
    }

    static class UnresolvedSharedObject {
        private final String className;
        private final int index;

        public UnresolvedSharedObject(String className, int index) {
            this.className = className;
            this.index = index;
        }

        public String getClassName() {
            return this.className;
        }

        public int getIndex() {
            return this.index;
        }

        public String toString() {
            return UnresolvedSharedObject.class.getName() + " {className=" + this.className + ", index=" + this.index + "}";
        }
    }
}

