/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.jmf.codec.std.impl;

import java.io.IOException;
import org.granite.messaging.jmf.DumpContext;
import org.granite.messaging.jmf.InputContext;
import org.granite.messaging.jmf.JMFEncodingException;
import org.granite.messaging.jmf.OutputContext;
import org.granite.messaging.jmf.codec.std.NullCodec;
import org.granite.messaging.jmf.codec.std.impl.AbstractStandardCodec;

public class NullCodecImpl
extends AbstractStandardCodec<Object>
implements NullCodec {
    @Override
    public int getObjectType() {
        return 120;
    }

    @Override
    public Class<?> getObjectClass() {
        return null;
    }

    @Override
    public void encode(OutputContext ctx, Object v) throws IOException {
        if (v != null) {
            throw new JMFEncodingException("Null value must be null");
        }
        ctx.getOutputStream().write(120);
    }

    @Override
    public Object decode(InputContext ctx, int parameterizedJmfType) throws IOException {
        int jmfType = ctx.getSharedContext().getCodecRegistry().extractJmfType(parameterizedJmfType);
        if (jmfType != 120) {
            throw this.newBadTypeJMFEncodingException(jmfType, parameterizedJmfType);
        }
        return null;
    }

    @Override
    public void dump(DumpContext ctx, int parameterizedJmfType) throws IOException {
        int jmfType = ctx.getSharedContext().getCodecRegistry().extractJmfType(parameterizedJmfType);
        if (jmfType != 120) {
            throw this.newBadTypeJMFEncodingException(jmfType, parameterizedJmfType);
        }
        ctx.indentPrintLn("?: null");
    }
}

