/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.jmf.codec.std.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.util.List;
import org.granite.messaging.jmf.CodecRegistry;
import org.granite.messaging.jmf.DumpContext;
import org.granite.messaging.jmf.InputContext;
import org.granite.messaging.jmf.JMFEncodingException;
import org.granite.messaging.jmf.OutputContext;
import org.granite.messaging.jmf.codec.ExtendedObjectCodec;
import org.granite.messaging.jmf.codec.StandardCodec;
import org.granite.messaging.jmf.codec.std.ObjectCodec;
import org.granite.messaging.jmf.codec.std.impl.AbstractIntegerStringCodec;
import org.granite.messaging.reflect.Property;

public class ObjectCodecImpl
extends AbstractIntegerStringCodec<Object>
implements ObjectCodec {
    protected static final AbstractIntegerStringCodec.StringTypeHandler TYPE_HANDLER = new AbstractIntegerStringCodec.StringTypeHandler(){

        @Override
        public int type(AbstractIntegerStringCodec.IntegerComponents ics, boolean reference) {
            if (reference) {
                return 0x40 | ics.length << 4 | 1;
            }
            return ics.length << 4 | 1;
        }

        @Override
        public int indexOrLengthBytesCount(int parameterizedJmfType) {
            return parameterizedJmfType >> 4 & 3;
        }

        @Override
        public boolean isReference(int parameterizedJmfType) {
            return (parameterizedJmfType & 0x40) != 0;
        }
    };

    @Override
    public int getObjectType() {
        return 1;
    }

    @Override
    public boolean canEncode(Object v) {
        Class<?> cls = v.getClass();
        return !cls.isArray() && !cls.isEnum() && !(v instanceof Class);
    }

    @Override
    public void encode(OutputContext ctx, Object v) throws IOException, IllegalAccessException, InvocationTargetException {
        OutputStream os = ctx.getOutputStream();
        int indexOfStoredObject = ctx.indexOfStoredObjects(v);
        if (indexOfStoredObject >= 0) {
            AbstractIntegerStringCodec.IntegerComponents ics = this.intComponents(indexOfStoredObject);
            os.write(0x80 | ics.length << 4 | 1);
            this.writeIntData(ctx, ics);
        } else {
            if (!(v instanceof Serializable)) {
                throw new NotSerializableException(v.getClass().getName());
            }
            ctx.addToStoredObjects(v);
            ExtendedObjectCodec extendedCodec = ctx.getSharedContext().getCodecRegistry().findExtendedEncoder(ctx, v);
            String className = extendedCodec != null ? extendedCodec.getEncodedClassName(ctx, v) : ctx.getAlias(v.getClass().getName());
            this.writeString(ctx, className, TYPE_HANDLER);
            if (extendedCodec != null) {
                extendedCodec.encode(ctx, v);
            } else if (v instanceof Externalizable && !Proxy.isProxyClass(v.getClass())) {
                ((Externalizable)v).writeExternal(ctx);
            } else {
                this.encodeSerializable(ctx, (Serializable)v);
            }
            os.write(121);
        }
    }

    protected void encodeSerializable(OutputContext ctx, Serializable v) throws IOException, IllegalAccessException, InvocationTargetException {
        List<Property> properties = ctx.getReflection().findSerializableProperties(v.getClass());
        for (Property property : properties) {
            ctx.getAndWriteProperty(v, property);
        }
    }

    @Override
    public Object decode(InputContext ctx, int parameterizedJmfType) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchMethodException {
        CodecRegistry codecRegistry = ctx.getSharedContext().getCodecRegistry();
        int jmfType = codecRegistry.extractJmfType(parameterizedJmfType);
        if (jmfType != 1) {
            throw this.newBadTypeJMFEncodingException(jmfType, parameterizedJmfType);
        }
        Object v = null;
        int indexOrLength = this.readIntData(ctx, parameterizedJmfType >> 4 & 3, false);
        if ((parameterizedJmfType & 0x80) != 0) {
            v = ctx.getSharedObject(indexOrLength);
        } else {
            String className = this.readString(ctx, parameterizedJmfType, indexOrLength, TYPE_HANDLER);
            ExtendedObjectCodec extendedCodec = codecRegistry.findExtendedDecoder(ctx, className);
            if (extendedCodec != null) {
                className = extendedCodec.getDecodedClassName(ctx, className);
                int index = ctx.addUnresolvedSharedObject(className);
                v = extendedCodec.newInstance(ctx, className);
                ctx.setUnresolvedSharedObject(index, v);
                extendedCodec.decode(ctx, v);
            } else {
                className = ctx.getAlias(className);
                Class<?> cls = ctx.getSharedContext().getReflection().loadClass(className);
                if (!Serializable.class.isAssignableFrom(cls)) {
                    throw new NotSerializableException(cls.getName());
                }
                if (Externalizable.class.isAssignableFrom(cls)) {
                    v = ctx.getReflection().newInstance(cls);
                    ctx.addSharedObject(v);
                    ((Externalizable)v).readExternal(ctx);
                } else {
                    v = ctx.getReflection().newInstance(cls);
                    ctx.addSharedObject(v);
                    this.decodeSerializable(ctx, (Serializable)v);
                }
            }
            int mark = ctx.safeRead();
            if (mark != 121) {
                throw new JMFEncodingException("Not a Object end marker: " + mark);
            }
        }
        return v;
    }

    protected void decodeSerializable(InputContext ctx, Serializable v) throws IOException, ClassNotFoundException, IllegalAccessException, InvocationTargetException {
        List<Property> properties = ctx.getReflection().findSerializableProperties(v.getClass());
        for (Property property : properties) {
            ctx.readAndSetProperty(v, property);
        }
    }

    @Override
    public void dump(DumpContext ctx, int parameterizedJmfType) throws IOException {
        CodecRegistry codecRegistry = ctx.getSharedContext().getCodecRegistry();
        int jmfType = codecRegistry.extractJmfType(parameterizedJmfType);
        if (jmfType != 1) {
            throw this.newBadTypeJMFEncodingException(jmfType, parameterizedJmfType);
        }
        int indexOrLength = this.readIntData(ctx, parameterizedJmfType >> 4 & 3, false);
        if ((parameterizedJmfType & 0x80) != 0) {
            String className = (String)ctx.getSharedObject(indexOrLength);
            ctx.indentPrintLn("<" + className + "@" + indexOrLength + ">");
        } else {
            String className = this.readString(ctx, parameterizedJmfType, indexOrLength, TYPE_HANDLER);
            int indexOfStoredObject = ctx.addSharedObject(className);
            ctx.indentPrintLn(className + "@" + indexOfStoredObject + " {");
            ctx.incrIndent(1);
            while ((parameterizedJmfType = ctx.safeRead()) != 121) {
                jmfType = codecRegistry.extractJmfType(parameterizedJmfType);
                StandardCodec codec = codecRegistry.getCodec(jmfType);
                if (codec == null) {
                    throw new JMFEncodingException("No codec for JMF type: " + jmfType);
                }
                codec.dump(ctx, parameterizedJmfType);
            }
            ctx.incrIndent(-1);
            ctx.indentPrintLn("}");
        }
    }
}

