/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.granite.messaging.reflect.MethodProperty;

public class SimpleMethodProperty
implements MethodProperty {
    private final Method getter;
    private final Method setter;
    private final String name;

    public SimpleMethodProperty(Method getter, Method setter, String name) {
        if (getter == null || name == null) {
            throw new NullPointerException("getter and name cannot be null");
        }
        this.getter = getter;
        this.setter = setter;
        this.name = name;
    }

    @Override
    public Method getGetter() {
        return this.getter;
    }

    @Override
    public Method getSetter() {
        return this.setter;
    }

    @Override
    public Class<?> getType() {
        return this.getter.getReturnType();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this.getter.isAnnotationPresent(annotationClass) || this.setter != null && this.setter.isAnnotationPresent(annotationClass);
    }

    @Override
    public boolean isReadable() {
        return this.getter != null;
    }

    @Override
    public boolean isWritable() {
        return this.setter != null;
    }

    @Override
    public boolean getBoolean(Object holder) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return (Boolean)this.getter.invoke(holder, new Object[0]);
    }

    @Override
    public char getChar(Object holder) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return ((Character)this.getter.invoke(holder, new Object[0])).charValue();
    }

    @Override
    public byte getByte(Object holder) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return (Byte)this.getter.invoke(holder, new Object[0]);
    }

    @Override
    public short getShort(Object holder) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return (Short)this.getter.invoke(holder, new Object[0]);
    }

    @Override
    public int getInt(Object holder) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return (Integer)this.getter.invoke(holder, new Object[0]);
    }

    @Override
    public long getLong(Object holder) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return ((Long)this.getter.invoke(holder, new Object[0])).intValue();
    }

    @Override
    public float getFloat(Object holder) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return ((Float)this.getter.invoke(holder, new Object[0])).floatValue();
    }

    @Override
    public double getDouble(Object holder) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return (Double)this.getter.invoke(holder, new Object[0]);
    }

    @Override
    public Object getObject(Object holder) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return this.getter.invoke(holder, new Object[0]);
    }

    @Override
    public Object getRawObject(Object holder) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return this.getter.invoke(holder, new Object[0]);
    }

    @Override
    public void setBoolean(Object holder, boolean value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (this.setter == null) {
            throw new IllegalAccessException("Property " + this + " isn't writable");
        }
        this.setter.invoke(holder, value);
    }

    @Override
    public void setChar(Object holder, char value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (this.setter == null) {
            throw new IllegalAccessException("Property " + this + " isn't writable");
        }
        this.setter.invoke(holder, Character.valueOf(value));
    }

    @Override
    public void setByte(Object holder, byte value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (this.setter == null) {
            throw new IllegalAccessException("Property " + this + " isn't writable");
        }
        this.setter.invoke(holder, value);
    }

    @Override
    public void setShort(Object holder, short value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (this.setter == null) {
            throw new IllegalAccessException("Property " + this + " isn't writable");
        }
        this.setter.invoke(holder, value);
    }

    @Override
    public void setInt(Object holder, int value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (this.setter == null) {
            throw new IllegalAccessException("Property " + this + " isn't writable");
        }
        this.setter.invoke(holder, value);
    }

    @Override
    public void setLong(Object holder, long value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (this.setter == null) {
            throw new IllegalAccessException("Property " + this + " isn't writable");
        }
        this.setter.invoke(holder, value);
    }

    @Override
    public void setFloat(Object holder, float value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (this.setter == null) {
            throw new IllegalAccessException("Property " + this + " isn't writable");
        }
        this.setter.invoke(holder, Float.valueOf(value));
    }

    @Override
    public void setDouble(Object holder, double value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (this.setter == null) {
            throw new IllegalAccessException("Property " + this + " isn't writable");
        }
        this.setter.invoke(holder, value);
    }

    @Override
    public void setObject(Object holder, Object value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (this.setter == null) {
            throw new IllegalAccessException("Property " + this + " isn't writable");
        }
        this.setter.invoke(holder, value);
    }

    public int hashCode() {
        return this.getter.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof MethodProperty && ((MethodProperty)obj).getGetter().equals(this.getter);
    }

    public String toString() {
        return this.getter.toString();
    }
}

