/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.data;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.granite.tide.TideTransactionManager;
import org.granite.tide.data.TideTransactionPersistenceManager;

public class JTATransactionManager
implements TideTransactionManager {
    public static final String USER_TRANSACTION_JNDI = "java:comp/UserTransaction";

    @Override
    public Object begin(TideTransactionPersistenceManager pm) {
        try {
            InitialContext ic = new InitialContext();
            UserTransaction ut = (UserTransaction)ic.lookup(USER_TRANSACTION_JNDI);
            ut.begin();
            return ut;
        }
        catch (NamingException f) {
            throw new RuntimeException("Could not initiate JTA transaction for lazy initialization", f);
        }
        catch (SystemException f) {
            throw new RuntimeException("Could not initiate JTA transaction for lazy initialization", f);
        }
        catch (NotSupportedException f) {
            throw new RuntimeException("Could not initiate JTA transaction for lazy initialization", f);
        }
    }

    @Override
    public void commit(Object tx) throws Exception {
        if (tx instanceof UserTransaction) {
            ((UserTransaction)tx).commit();
        }
    }

    @Override
    public void rollback(Object tx) {
        try {
            if (tx instanceof UserTransaction) {
                ((UserTransaction)tx).rollback();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to rollback attach entity and init collection", e);
        }
    }
}

