/*
 * Decompiled with CFR 0.152.
 */
package org.granite.config.flex;

import org.granite.config.flex.EndPoint;
import org.granite.util.XMap;

public class Channel {
    private static final String LEGACY_XML = "serialization/legacy-xml";
    private static final String LEGACY_COLLECTION = "serialization/legacy-collection";
    private final String id;
    private final String className;
    private final EndPoint endPoint;
    private final XMap properties;
    private final boolean legacyXml;
    private final boolean legacyCollection;

    public Channel(String id, String className, EndPoint endPoint, XMap properties) {
        this.id = id;
        this.className = className;
        this.endPoint = endPoint;
        this.properties = properties;
        this.legacyCollection = Boolean.TRUE.toString().equals(properties.get(LEGACY_COLLECTION));
        this.legacyXml = Boolean.TRUE.toString().equals(properties.get(LEGACY_XML));
    }

    public String getId() {
        return this.id;
    }

    public String getClassName() {
        return this.className;
    }

    public EndPoint getEndPoint() {
        return this.endPoint;
    }

    public XMap getProperties() {
        return this.properties;
    }

    public boolean isLegacyXmlSerialization() {
        return this.legacyXml;
    }

    public boolean isLegacyCollectionSerialization() {
        return this.legacyCollection;
    }

    public static Channel forElement(XMap element) {
        String id = element.get("@id");
        String className = element.get("@class");
        XMap endPointElt = element.getOne("endpoint");
        if (endPointElt == null) {
            throw new RuntimeException("Excepting a 'endpoint' element in 'channel-definition': " + id);
        }
        EndPoint endPoint = EndPoint.forElement(endPointElt);
        XMap properties = new XMap(element.getOne("properties"));
        return new Channel(id, className, endPoint, properties);
    }
}

