/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity.generic;

import flex.messaging.messages.CommandMessage;
import flex.messaging.messages.Message;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.granite.gravity.AbstractGravityServlet;
import org.granite.gravity.AsyncHttpContext;
import org.granite.gravity.Gravity;
import org.granite.gravity.GravityManager;
import org.granite.gravity.generic.GenericChannel;
import org.granite.gravity.generic.GenericChannelFactory;
import org.granite.gravity.generic.WaitingContinuation;
import org.granite.logging.Logger;

public class GravityGenericServlet
extends AbstractGravityServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(GravityGenericServlet.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.debug("doPost: from %s:%d", request.getRemoteAddr(), request.getRemotePort());
        Gravity gravity = GravityManager.getGravity(this.getServletContext());
        GenericChannelFactory channelFactory = new GenericChannelFactory(gravity);
        try {
            this.initializeRequest(gravity, request, response);
            CommandMessage connect = GravityGenericServlet.getConnectMessage(request);
            if (connect != null) {
                try {
                    GenericChannel channel;
                    String channelId = (String)connect.getClientId();
                    GenericChannel genericChannel = channel = gravity.getChannel(channelFactory, channelId);
                    synchronized (genericChannel) {
                        channel.close();
                        channel.runReceived(new AsyncHttpContext(request, response, connect));
                    }
                }
                finally {
                    GravityGenericServlet.removeConnectMessage(request);
                }
                return;
            }
            Message[] amf3Requests = this.deserialize(gravity, request);
            log.debug(">> [AMF3 REQUESTS] %s", new Object[]{amf3Requests});
            Message[] amf3Responses = null;
            boolean accessed = false;
            for (int i = 0; i < amf3Requests.length; ++i) {
                Message amf3Request = amf3Requests[i];
                Message amf3Response = gravity.handleMessage(channelFactory, amf3Request);
                String channelId = (String)amf3Request.getClientId();
                if (!accessed) {
                    accessed = gravity.access(channelId);
                }
                if (amf3Response == null) {
                    if (amf3Requests.length > 1) {
                        throw new IllegalArgumentException("Only one request is allowed on tunnel.");
                    }
                    GenericChannel channel = gravity.getChannel(channelFactory, channelId);
                    if (channel == null) {
                        throw new NullPointerException("No channel on tunnel connect");
                    }
                    if (!channel.runReceived(new AsyncHttpContext(request, response, amf3Request))) {
                        GravityGenericServlet.setConnectMessage(request, amf3Request);
                        GenericChannel genericChannel = channel;
                        synchronized (genericChannel) {
                            WaitingContinuation continuation = new WaitingContinuation(channel);
                            channel.setContinuation(continuation);
                            continuation.suspend(this.getLongPollingTimeout());
                        }
                    }
                    return;
                }
                if (amf3Responses == null) {
                    amf3Responses = new Message[amf3Requests.length];
                }
                amf3Responses[i] = amf3Response;
            }
            log.debug("<< [AMF3 RESPONSES] %s", new Object[]{amf3Responses});
            this.serialize(gravity, response, amf3Responses);
        }
        catch (IOException e) {
            log.error(e, "Gravity message error", new Object[0]);
            throw e;
        }
        catch (ClassNotFoundException e) {
            log.error(e, "Gravity message error", new Object[0]);
            throw new ServletException("Gravity message error", (Throwable)e);
        }
        finally {
            this.cleanupRequest(request);
        }
        GravityGenericServlet.removeConnectMessage(request);
    }
}

