/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.jmf;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.granite.messaging.jmf.CodecRegistry;
import org.granite.messaging.jmf.ExtendedObjectInput;
import org.granite.messaging.jmf.ExtendedObjectOutput;
import org.granite.messaging.jmf.InputContext;
import org.granite.messaging.jmf.JMFConfigurationException;
import org.granite.messaging.jmf.OutputContext;
import org.granite.messaging.jmf.codec.BijectiveCodec;
import org.granite.messaging.jmf.codec.ConditionalObjectCodec;
import org.granite.messaging.jmf.codec.ExtendedObjectCodec;
import org.granite.messaging.jmf.codec.PrimitiveCodec;
import org.granite.messaging.jmf.codec.StandardCodec;
import org.granite.messaging.jmf.codec.std.BooleanCodec;
import org.granite.messaging.jmf.codec.std.ByteCodec;
import org.granite.messaging.jmf.codec.std.CharacterCodec;
import org.granite.messaging.jmf.codec.std.DoubleCodec;
import org.granite.messaging.jmf.codec.std.FloatCodec;
import org.granite.messaging.jmf.codec.std.IntegerCodec;
import org.granite.messaging.jmf.codec.std.LongCodec;
import org.granite.messaging.jmf.codec.std.NullCodec;
import org.granite.messaging.jmf.codec.std.ShortCodec;
import org.granite.messaging.jmf.codec.std.StringCodec;
import org.granite.messaging.jmf.codec.std.impl.ArrayListCodecImpl;
import org.granite.messaging.jmf.codec.std.impl.BigDecimalCodecImpl;
import org.granite.messaging.jmf.codec.std.impl.BigIntegerCodecImpl;
import org.granite.messaging.jmf.codec.std.impl.BooleanCodecImpl;
import org.granite.messaging.jmf.codec.std.impl.ByteCodecImpl;
import org.granite.messaging.jmf.codec.std.impl.CharacterCodecImpl;
import org.granite.messaging.jmf.codec.std.impl.ClassCodecImpl;
import org.granite.messaging.jmf.codec.std.impl.DateCodecImpl;
import org.granite.messaging.jmf.codec.std.impl.DoubleCodecImpl;
import org.granite.messaging.jmf.codec.std.impl.EnumCodecImpl;
import org.granite.messaging.jmf.codec.std.impl.FloatCodecImpl;
import org.granite.messaging.jmf.codec.std.impl.HashMapCodecImpl;
import org.granite.messaging.jmf.codec.std.impl.HashSetCodecImpl;
import org.granite.messaging.jmf.codec.std.impl.IntegerCodecImpl;
import org.granite.messaging.jmf.codec.std.impl.LongCodecImpl;
import org.granite.messaging.jmf.codec.std.impl.NullCodecImpl;
import org.granite.messaging.jmf.codec.std.impl.ObjectArrayCodecImpl;
import org.granite.messaging.jmf.codec.std.impl.ObjectCodecImpl;
import org.granite.messaging.jmf.codec.std.impl.PrimitiveArrayCodecImpl;
import org.granite.messaging.jmf.codec.std.impl.ShortCodecImpl;
import org.granite.messaging.jmf.codec.std.impl.SqlDateCodecImpl;
import org.granite.messaging.jmf.codec.std.impl.SqlTimeCodecImpl;
import org.granite.messaging.jmf.codec.std.impl.SqlTimestampCodecImpl;
import org.granite.messaging.jmf.codec.std.impl.StringCodecImpl;
import org.granite.messaging.reflect.Property;

public class DefaultCodecRegistry
implements CodecRegistry {
    private static final int[] UNPARAMETERIZED_JMF_TYPES = new int[256];
    private NullCodec nullCodec;
    private BooleanCodec booleanCodec;
    private CharacterCodec characterCodec;
    private ByteCodec byteCodec;
    private ShortCodec shortCodec;
    private IntegerCodec integerCodec;
    private LongCodec longCodec;
    private FloatCodec floatCodec;
    private DoubleCodec doubleCodec;
    private StringCodec stringCodec;
    private final StandardCodec<?>[] typeToCodec = new StandardCodec[256];
    private final Map<Class<?>, StandardCodec<?>> classToCodec = new HashMap();
    private final List<ConditionalObjectCodec> conditionalObjectCodecs = new ArrayList<ConditionalObjectCodec>();
    private final Map<Class<?>, CodecRegistry.PrimitivePropertyCodec> primitivePropertyCodecs = new HashMap();
    private final List<ExtendedObjectCodec> extendedCodecs;

    public DefaultCodecRegistry() {
        this(null);
    }

    public DefaultCodecRegistry(List<ExtendedObjectCodec> extendedCodecs) {
        this.extendedCodecs = extendedCodecs != null ? extendedCodecs : new ArrayList();
        HashMap typeToCodecMap = new HashMap();
        List<StandardCodec<?>> standardCodecs = this.getStandardCodecs();
        for (StandardCodec<?> codec : standardCodecs) {
            if (codec instanceof BijectiveCodec) {
                if (codec instanceof PrimitiveCodec) {
                    this.assertNull(this.classToCodec.put(((PrimitiveCodec)codec).getPrimitiveClass(), codec));
                    this.assertNull(typeToCodecMap.put(((PrimitiveCodec)codec).getPrimitiveType(), codec));
                    switch (((PrimitiveCodec)codec).getPrimitiveType()) {
                        case 56: {
                            this.initBooleanCodec((BooleanCodec)codec);
                            break;
                        }
                        case 58: {
                            this.initCharacterCodec((CharacterCodec)codec);
                            break;
                        }
                        case 123: {
                            this.initByteCodec((ByteCodec)codec);
                            break;
                        }
                        case 24: {
                            this.initShortCodec((ShortCodec)codec);
                            break;
                        }
                        case 8: {
                            this.initIntegerCodec((IntegerCodec)codec);
                            break;
                        }
                        case 2: {
                            this.initLongCodec((LongCodec)codec);
                            break;
                        }
                        case 125: {
                            this.initFloatCodec((FloatCodec)codec);
                            break;
                        }
                        case 0: {
                            this.initDoubleCodec((DoubleCodec)codec);
                        }
                    }
                }
                this.assertNull(this.classToCodec.put(((BijectiveCodec)codec).getObjectClass(), codec));
                this.assertNull(typeToCodecMap.put(codec.getObjectType(), codec));
                if (codec.getObjectType() == 4) {
                    this.initStringCodec((StringCodec)codec);
                    continue;
                }
                if (codec.getObjectType() != 120) continue;
                this.initNullCodec((NullCodec)codec);
                continue;
            }
            if (codec instanceof ConditionalObjectCodec) {
                this.assertNull(typeToCodecMap.put(codec.getObjectType(), codec));
                this.conditionalObjectCodecs.add((ConditionalObjectCodec)codec);
                continue;
            }
            throw new JMFConfigurationException("Codec must implement BijectiveCodec or ConditionalObjectCodec: " + codec);
        }
        this.checkPrimitiveCodecs();
        for (int i = 0; i < 256; ++i) {
            int jmfType = UNPARAMETERIZED_JMF_TYPES[i];
            this.typeToCodec[i] = (StandardCodec)typeToCodecMap.get(jmfType);
        }
    }

    @Override
    public NullCodec getNullCodec() {
        return this.nullCodec;
    }

    @Override
    public BooleanCodec getBooleanCodec() {
        return this.booleanCodec;
    }

    @Override
    public CharacterCodec getCharacterCodec() {
        return this.characterCodec;
    }

    @Override
    public ByteCodec getByteCodec() {
        return this.byteCodec;
    }

    @Override
    public ShortCodec getShortCodec() {
        return this.shortCodec;
    }

    @Override
    public IntegerCodec getIntegerCodec() {
        return this.integerCodec;
    }

    @Override
    public LongCodec getLongCodec() {
        return this.longCodec;
    }

    @Override
    public FloatCodec getFloatCodec() {
        return this.floatCodec;
    }

    @Override
    public DoubleCodec getDoubleCodec() {
        return this.doubleCodec;
    }

    @Override
    public StringCodec getStringCodec() {
        return this.stringCodec;
    }

    @Override
    public <T> StandardCodec<T> getCodec(int jmfType) {
        return this.typeToCodec[jmfType];
    }

    @Override
    public <T> StandardCodec<T> getCodec(Object v) {
        Class<?> cls = v != null ? v.getClass() : null;
        ConditionalObjectCodec codec = this.classToCodec.get(cls);
        if (codec == null) {
            for (ConditionalObjectCodec condCodec : this.conditionalObjectCodecs) {
                if (!condCodec.canEncode(v)) continue;
                codec = condCodec;
                break;
            }
        }
        return codec;
    }

    @Override
    public ExtendedObjectCodec findExtendedEncoder(ExtendedObjectOutput out, Object v) {
        for (ExtendedObjectCodec c : this.extendedCodecs) {
            if (!c.canEncode(out, v)) continue;
            return c;
        }
        return null;
    }

    @Override
    public ExtendedObjectCodec findExtendedDecoder(ExtendedObjectInput in, String className) {
        for (ExtendedObjectCodec c : this.extendedCodecs) {
            try {
                if (!c.canDecode(in, className)) continue;
                return c;
            }
            catch (ClassNotFoundException e) {
            }
        }
        return null;
    }

    @Override
    public CodecRegistry.PrimitivePropertyCodec getPrimitivePropertyCodec(Class<?> propertyCls) {
        return this.primitivePropertyCodecs.get(propertyCls);
    }

    @Override
    public int extractJmfType(int parameterizedJmfType) {
        return UNPARAMETERIZED_JMF_TYPES[parameterizedJmfType];
    }

    protected List<StandardCodec<?>> getStandardCodecs() {
        return Arrays.asList(new NullCodecImpl(), new BooleanCodecImpl(), new CharacterCodecImpl(), new ByteCodecImpl(), new ShortCodecImpl(), new IntegerCodecImpl(), new LongCodecImpl(), new FloatCodecImpl(), new DoubleCodecImpl(), new BigIntegerCodecImpl(), new BigDecimalCodecImpl(), new StringCodecImpl(), new DateCodecImpl(), new SqlDateCodecImpl(), new SqlTimeCodecImpl(), new SqlTimestampCodecImpl(), new ArrayListCodecImpl(), new HashSetCodecImpl(), new HashMapCodecImpl(), new EnumCodecImpl(), new PrimitiveArrayCodecImpl(), new ObjectArrayCodecImpl(), new ClassCodecImpl(), new ObjectCodecImpl());
    }

    private void assertNull(StandardCodec<?> codec) {
        if (codec != null) {
            throw new JMFConfigurationException("Codec conflict with: " + codec);
        }
    }

    private void checkPrimitiveCodecs() {
        if (this.nullCodec == null) {
            throw new JMFConfigurationException("No Null codec");
        }
        if (this.booleanCodec == null) {
            throw new JMFConfigurationException("No Boolean codec");
        }
        if (this.characterCodec == null) {
            throw new JMFConfigurationException("No Character codec");
        }
        if (this.byteCodec == null) {
            throw new JMFConfigurationException("No Byte codec");
        }
        if (this.shortCodec == null) {
            throw new JMFConfigurationException("No Short codec");
        }
        if (this.integerCodec == null) {
            throw new JMFConfigurationException("No Integer codec");
        }
        if (this.longCodec == null) {
            throw new JMFConfigurationException("No Long codec");
        }
        if (this.floatCodec == null) {
            throw new JMFConfigurationException("No Float codec");
        }
        if (this.doubleCodec == null) {
            throw new JMFConfigurationException("No Double codec");
        }
        if (this.stringCodec == null) {
            throw new JMFConfigurationException("No String codec");
        }
    }

    private void initBooleanCodec(BooleanCodec codec) {
        this.booleanCodec = codec;
        this.primitivePropertyCodecs.put(this.booleanCodec.getPrimitiveClass(), new CodecRegistry.PrimitivePropertyCodec(){

            @Override
            public void encodePrimitive(OutputContext ctx, Object holder, Property property) throws IllegalAccessException, IOException, InvocationTargetException {
                DefaultCodecRegistry.this.booleanCodec.encodePrimitive(ctx, property.getBoolean(holder));
            }

            @Override
            public void decodePrimitive(InputContext ctx, Object holder, Property property) throws IllegalAccessException, IOException, InvocationTargetException {
                property.setBoolean(holder, DefaultCodecRegistry.this.booleanCodec.decodePrimitive(ctx));
            }
        });
    }

    private void initCharacterCodec(CharacterCodec codec) {
        this.characterCodec = codec;
        this.primitivePropertyCodecs.put(this.characterCodec.getPrimitiveClass(), new CodecRegistry.PrimitivePropertyCodec(){

            @Override
            public void encodePrimitive(OutputContext ctx, Object holder, Property property) throws IllegalAccessException, IOException, InvocationTargetException {
                DefaultCodecRegistry.this.characterCodec.encodePrimitive(ctx, property.getChar(holder));
            }

            @Override
            public void decodePrimitive(InputContext ctx, Object holder, Property property) throws IllegalAccessException, IOException, InvocationTargetException {
                property.setChar(holder, DefaultCodecRegistry.this.characterCodec.decodePrimitive(ctx));
            }
        });
    }

    private void initByteCodec(ByteCodec codec) {
        this.byteCodec = codec;
        this.primitivePropertyCodecs.put(this.byteCodec.getPrimitiveClass(), new CodecRegistry.PrimitivePropertyCodec(){

            @Override
            public void encodePrimitive(OutputContext ctx, Object holder, Property property) throws IllegalAccessException, IOException, InvocationTargetException {
                DefaultCodecRegistry.this.byteCodec.encodePrimitive(ctx, property.getByte(holder));
            }

            @Override
            public void decodePrimitive(InputContext ctx, Object holder, Property property) throws IllegalAccessException, IOException, InvocationTargetException {
                property.setByte(holder, DefaultCodecRegistry.this.byteCodec.decodePrimitive(ctx));
            }
        });
    }

    private void initShortCodec(ShortCodec codec) {
        this.shortCodec = codec;
        this.primitivePropertyCodecs.put(this.shortCodec.getPrimitiveClass(), new CodecRegistry.PrimitivePropertyCodec(){

            @Override
            public void encodePrimitive(OutputContext ctx, Object holder, Property property) throws IllegalAccessException, IOException, InvocationTargetException {
                DefaultCodecRegistry.this.shortCodec.encodePrimitive(ctx, property.getShort(holder));
            }

            @Override
            public void decodePrimitive(InputContext ctx, Object holder, Property property) throws IllegalAccessException, IOException, InvocationTargetException {
                property.setShort(holder, DefaultCodecRegistry.this.shortCodec.decodePrimitive(ctx));
            }
        });
    }

    private void initIntegerCodec(IntegerCodec codec) {
        this.integerCodec = codec;
        this.primitivePropertyCodecs.put(this.integerCodec.getPrimitiveClass(), new CodecRegistry.PrimitivePropertyCodec(){

            @Override
            public void encodePrimitive(OutputContext ctx, Object holder, Property property) throws IllegalAccessException, IOException, InvocationTargetException {
                DefaultCodecRegistry.this.integerCodec.encodePrimitive(ctx, property.getInt(holder));
            }

            @Override
            public void decodePrimitive(InputContext ctx, Object holder, Property property) throws IllegalAccessException, IOException, InvocationTargetException {
                property.setInt(holder, DefaultCodecRegistry.this.integerCodec.decodePrimitive(ctx));
            }
        });
    }

    private void initLongCodec(LongCodec codec) {
        this.longCodec = codec;
        this.primitivePropertyCodecs.put(this.longCodec.getPrimitiveClass(), new CodecRegistry.PrimitivePropertyCodec(){

            @Override
            public void encodePrimitive(OutputContext ctx, Object holder, Property property) throws IllegalAccessException, IOException, InvocationTargetException {
                DefaultCodecRegistry.this.longCodec.encodePrimitive(ctx, property.getLong(holder));
            }

            @Override
            public void decodePrimitive(InputContext ctx, Object holder, Property property) throws IllegalAccessException, IOException, InvocationTargetException {
                property.setLong(holder, DefaultCodecRegistry.this.longCodec.decodePrimitive(ctx));
            }
        });
    }

    private void initFloatCodec(FloatCodec codec) {
        this.floatCodec = codec;
        this.primitivePropertyCodecs.put(this.floatCodec.getPrimitiveClass(), new CodecRegistry.PrimitivePropertyCodec(){

            @Override
            public void encodePrimitive(OutputContext ctx, Object holder, Property property) throws IllegalAccessException, IOException, InvocationTargetException {
                DefaultCodecRegistry.this.floatCodec.encodePrimitive(ctx, property.getFloat(holder));
            }

            @Override
            public void decodePrimitive(InputContext ctx, Object holder, Property property) throws IllegalAccessException, IOException, InvocationTargetException {
                property.setFloat(holder, DefaultCodecRegistry.this.floatCodec.decodePrimitive(ctx));
            }
        });
    }

    private void initDoubleCodec(DoubleCodec codec) {
        this.doubleCodec = codec;
        this.primitivePropertyCodecs.put(this.doubleCodec.getPrimitiveClass(), new CodecRegistry.PrimitivePropertyCodec(){

            @Override
            public void encodePrimitive(OutputContext ctx, Object holder, Property property) throws IllegalAccessException, IOException, InvocationTargetException {
                DefaultCodecRegistry.this.doubleCodec.encodePrimitive(ctx, property.getDouble(holder));
            }

            @Override
            public void decodePrimitive(InputContext ctx, Object holder, Property property) throws IllegalAccessException, IOException, InvocationTargetException {
                property.setDouble(holder, DefaultCodecRegistry.this.doubleCodec.decodePrimitive(ctx));
            }
        });
    }

    private void initStringCodec(StringCodec codec) {
        this.stringCodec = codec;
    }

    private void initNullCodec(NullCodec codec) {
        this.nullCodec = codec;
    }

    static {
        for (int parameterizedJmfType = 0; parameterizedJmfType < 256; ++parameterizedJmfType) {
            int jmfType = (parameterizedJmfType & 8) == 0 ? parameterizedJmfType & 7 : ((parameterizedJmfType & 0x18) == 8 ? parameterizedJmfType & 0xF : ((parameterizedJmfType & 0x38) == 24 ? parameterizedJmfType & 0x1F : ((parameterizedJmfType & 0x78) == 56 ? parameterizedJmfType & 0x3F : parameterizedJmfType)));
            DefaultCodecRegistry.UNPARAMETERIZED_JMF_TYPES[parameterizedJmfType] = jmfType;
        }
    }
}

