/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.jmf.codec.std.impl;

import java.io.IOException;
import java.io.OutputStream;
import org.granite.messaging.jmf.DumpContext;
import org.granite.messaging.jmf.InputContext;
import org.granite.messaging.jmf.OutputContext;
import org.granite.messaging.jmf.codec.std.ByteCodec;
import org.granite.messaging.jmf.codec.std.impl.AbstractStandardCodec;

public class ByteCodecImpl
extends AbstractStandardCodec<Byte>
implements ByteCodec {
    @Override
    public int getObjectType() {
        return 124;
    }

    @Override
    public Class<?> getObjectClass() {
        return Byte.class;
    }

    @Override
    public int getPrimitiveType() {
        return 123;
    }

    @Override
    public Class<?> getPrimitiveClass() {
        return Byte.TYPE;
    }

    @Override
    public void encode(OutputContext ctx, Byte v) throws IOException {
        OutputStream os = ctx.getOutputStream();
        os.write(124);
        os.write(v.intValue());
    }

    @Override
    public Byte decode(InputContext ctx, int parameterizedJmfType) throws IOException {
        return (byte)ctx.safeRead();
    }

    @Override
    public void encodePrimitive(OutputContext ctx, int v) throws IOException {
        OutputStream os = ctx.getOutputStream();
        os.write(123);
        os.write(v);
    }

    @Override
    public byte decodePrimitive(InputContext ctx) throws IOException {
        ctx.safeRead();
        return (byte)ctx.safeRead();
    }

    @Override
    public void dump(DumpContext ctx, int parameterizedJmfType) throws IOException {
        int jmfType = ctx.getSharedContext().getCodecRegistry().extractJmfType(parameterizedJmfType);
        switch (jmfType) {
            case 123: {
                ctx.indentPrintLn("byte: " + (byte)ctx.safeRead());
                break;
            }
            case 124: {
                ctx.indentPrintLn(Byte.class.getName() + ": " + (byte)ctx.safeRead());
                break;
            }
            default: {
                throw this.newBadTypeJMFEncodingException(jmfType, parameterizedJmfType);
            }
        }
    }
}

