/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.service.tide;

import java.lang.annotation.Annotation;
import java.util.Set;
import org.granite.config.GraniteConfigException;
import org.granite.messaging.service.tide.TideComponentMatcher;
import org.granite.util.TypeUtil;

public class TideComponentAnnotatedWithMatcher
implements TideComponentMatcher {
    private final boolean disabled;
    private final Class<? extends Annotation> annotationClass;

    public TideComponentAnnotatedWithMatcher(String type, boolean disabled) {
        try {
            this.annotationClass = TypeUtil.forName(type, Annotation.class);
            this.disabled = disabled;
        }
        catch (Exception e) {
            throw new GraniteConfigException("Could not instantiate instanceof matcher parent class: " + type, e);
        }
    }

    @Override
    public boolean matches(String name, Set<Class<?>> classes, Object instance, boolean disabled) {
        for (Class<?> clazz : classes) {
            if (disabled != this.disabled || !clazz.isAnnotationPresent(this.annotationClass)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "AnnotatedWith matcher: " + this.annotationClass.getName() + (this.disabled ? " (disabled)" : "");
    }
}

