/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.webapp;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import org.granite.messaging.webapp.BaseContextMap;

class ApplicationMap
extends BaseContextMap<String, Object> {
    private ServletContext servletContext = null;

    ApplicationMap(ServletContext servletContext) {
        if (servletContext == null) {
            throw new NullPointerException("servletContext is null");
        }
        this.servletContext = servletContext;
    }

    @Override
    public Object get(Object key) {
        if (!(key instanceof String)) {
            return null;
        }
        return this.servletContext.getAttribute(key.toString());
    }

    @Override
    public Object put(String key, Object value) {
        if (key == null) {
            throw new IllegalArgumentException("Key should be a non null String: " + key);
        }
        Object result = this.servletContext.getAttribute(key);
        this.servletContext.setAttribute(key, value);
        return result;
    }

    @Override
    public Object remove(Object key) {
        if (!(key instanceof String)) {
            return null;
        }
        Object result = this.servletContext.getAttribute(key.toString());
        this.servletContext.removeAttribute(key.toString());
        return result;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        HashSet<Map.Entry<String, Object>> entries = new HashSet<Map.Entry<String, Object>>();
        Enumeration e = this.servletContext.getAttributeNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            entries.add(new BaseContextMap.Entry<String, Object>(key, this.servletContext.getAttribute(key)));
        }
        return entries;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ApplicationMap)) {
            return false;
        }
        return super.equals(obj);
    }
}

