/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.data;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Entity;
import org.granite.context.GraniteContext;
import org.granite.logging.Logger;
import org.granite.messaging.amf.io.convert.Converters;
import org.granite.messaging.amf.io.util.ClassGetter;
import org.granite.messaging.service.ServiceException;
import org.granite.tide.data.Change;
import org.granite.tide.data.ChangeRef;
import org.granite.tide.data.ChangeSet;
import org.granite.tide.data.CollectionChange;
import org.granite.tide.data.CollectionChanges;
import org.granite.tide.data.TidePersistenceAdapter;
import org.granite.util.Introspector;
import org.granite.util.PropertyDescriptor;
import org.granite.util.TypeUtil;

public class ChangeSetApplier {
    private static final Logger log = Logger.getLogger(ChangeSetApplier.class);
    private TidePersistenceAdapter persistenceAdapter;

    public ChangeSetApplier(TidePersistenceAdapter persistenceAdapter) {
        this.persistenceAdapter = persistenceAdapter;
    }

    protected long getVersion(org.granite.util.Entity e) {
        if (!e.isVersioned()) {
            throw new IllegalStateException("Cannot apply change set on non versioned entity " + e.getName());
        }
        Number version = (Number)e.getVersion();
        if (version == null) {
            throw new IllegalStateException("Cannot apply changes on non persistent entity " + e.getName() + ":" + e.getIdentifier());
        }
        return version.longValue();
    }

    protected Object mergeObject(Object entity, Set<Object> cache) {
        if (entity == null) {
            return null;
        }
        ClassGetter classGetter = GraniteContext.getCurrentInstance().getGraniteConfig().getClassGetter();
        Converters converters = GraniteContext.getCurrentInstance().getGraniteConfig().getConverters();
        if (entity != null && !classGetter.isInitialized(null, null, entity)) {
            Class<?> cls = classGetter.getClass(entity);
            org.granite.util.Entity e = new org.granite.util.Entity(cls);
            return this.persistenceAdapter.find(cls, (Serializable)converters.convert(classGetter.getIdentifier(entity), e.getIdentifierType()));
        }
        if (cache.contains(entity)) {
            return entity;
        }
        if (entity instanceof ChangeRef) {
            ChangeRef ref = (ChangeRef)entity;
            try {
                Class<?> entityClass = TypeUtil.forName(ref.getClassName());
                org.granite.util.Entity e = new org.granite.util.Entity(entityClass);
                Serializable refId = (Serializable)converters.convert(ref.getId(), e.getIdentifierType());
                for (Object cached : cache) {
                    if (!cached.getClass().equals(entityClass) || !refId.equals(e.getIdentifier(cached))) continue;
                    return cached;
                }
                return this.persistenceAdapter.find(entityClass, refId);
            }
            catch (ClassNotFoundException cnfe) {
                throw new ServiceException("Could not find class " + ref.getClassName(), cnfe);
            }
        }
        cache.add(entity);
        if (entity != null && classGetter.isEntity(entity) && classGetter.isInitialized(null, null, entity)) {
            org.granite.util.Entity e = new org.granite.util.Entity(entity);
            Object id = e.getIdentifier();
            if (id != null) {
                return this.persistenceAdapter.find(entity.getClass(), (Serializable)id);
            }
            cache.add(entity);
            List<Object[]> fieldValues = classGetter.getFieldValues(entity);
            for (Object[] fieldValue : fieldValues) {
                Object newValue;
                Cloneable addedElements;
                Object value = fieldValue[1];
                Field field = (Field)fieldValue[0];
                if (value == null) continue;
                if (!classGetter.isInitialized(entity, field.getName(), value)) {
                    if (!classGetter.getClass(value).isAnnotationPresent(Entity.class)) continue;
                    try {
                        Serializable valueId = classGetter.getIdentifier(value);
                        Object newValue2 = null;
                        org.granite.util.Entity ve = new org.granite.util.Entity(field.getType());
                        for (Object cached : cache) {
                            if (!field.getType().isInstance(cached) || !valueId.equals(ve.getIdentifier(cached))) continue;
                            newValue2 = cached;
                            break;
                        }
                        if (newValue2 == null) {
                            newValue2 = this.persistenceAdapter.find(field.getType(), valueId);
                        }
                        field.set(entity, newValue2);
                    }
                    catch (IllegalAccessException e1) {
                        throw new ServiceException("Could not set entity field value on " + value.getClass() + "." + field.getName());
                    }
                }
                if (value instanceof Collection) {
                    Collection coll = (Collection)value;
                    Iterator icoll = coll.iterator();
                    addedElements = new HashSet();
                    int idx = 0;
                    while (icoll.hasNext()) {
                        Object newElement;
                        Object element = icoll.next();
                        if (element != null && (newElement = this.mergeObject(element, cache)) != element) {
                            if (coll instanceof List) {
                                ((List)coll).set(idx, newElement);
                            } else {
                                icoll.remove();
                                addedElements.add(newElement);
                            }
                        }
                        ++idx;
                    }
                    if (coll instanceof List) continue;
                    coll.addAll(addedElements);
                    continue;
                }
                if (value.getClass().isArray()) {
                    for (int idx = 0; idx < Array.getLength(value); ++idx) {
                        Object newElement;
                        Object element = Array.get(value, idx);
                        if (element == null || (newElement = this.mergeObject(element, cache)) == element) continue;
                        Array.set(value, idx, newElement);
                    }
                    continue;
                }
                if (value instanceof Map) {
                    Map map = (Map)value;
                    Iterator ime = map.entrySet().iterator();
                    addedElements = new HashMap();
                    while (ime.hasNext()) {
                        Object newKey;
                        Object key;
                        Object newVal;
                        Map.Entry me = ime.next();
                        Object val = me.getValue();
                        if (val != null && (newVal = this.mergeObject(val, cache)) != val) {
                            me.setValue(newVal);
                        }
                        if ((key = me.getKey()) == null || (newKey = this.mergeObject(key, cache)) == key) continue;
                        ime.remove();
                        addedElements.put(newKey, me.getValue());
                    }
                    map.putAll(addedElements);
                    continue;
                }
                if (!classGetter.isEntity(value) || (newValue = this.mergeObject(value, cache)) == value) continue;
                try {
                    field.set(entity, newValue);
                }
                catch (IllegalAccessException e1) {
                    throw new ServiceException("Could not set entity field value on " + value.getClass() + "." + field.getName());
                }
            }
        }
        return entity;
    }

    public Object[] applyChanges(ChangeSet changeSet) {
        HashSet<Object> cache = new HashSet<Object>();
        Object[] appliedChanges = new Object[changeSet.getChanges().length];
        for (int i = 0; i < changeSet.getChanges().length; ++i) {
            appliedChanges[i] = this.applyChange(changeSet.getChanges()[i], cache);
        }
        return appliedChanges;
    }

    private Object applyChange(Change change, Set<Object> cache) {
        Converters converters = GraniteContext.getCurrentInstance().getGraniteConfig().getConverters();
        Object appliedChange = null;
        try {
            Class<?> entityClass = TypeUtil.forName(change.getClassName());
            if (change.getId() != null) {
                org.granite.util.Entity e = new org.granite.util.Entity(entityClass);
                Type identifierType = e.getIdentifierType();
                Object entity = this.persistenceAdapter.find(entityClass, (Serializable)converters.convert(change.getId(), identifierType));
                if (entity == null) {
                    log.debug("Entity not found, maybe has already been deleted by cascading", new Object[0]);
                    return null;
                }
                e = new org.granite.util.Entity(entity);
                Long version = this.getVersion(e);
                if (change.getVersion() != null && change.getVersion().longValue() < version || change.getVersion() == null && version != null) {
                    this.persistenceAdapter.throwOptimisticLockException(entity);
                }
                appliedChange = entity;
                for (Map.Entry<String, Object> me : change.getChanges().entrySet()) {
                    try {
                        PropertyDescriptor[] propertyDescriptors = Introspector.getPropertyDescriptors(entityClass);
                        PropertyDescriptor propertyDescriptor = null;
                        for (PropertyDescriptor pd : propertyDescriptors) {
                            if (!pd.getName().equals(me.getKey())) continue;
                            propertyDescriptor = pd;
                            break;
                        }
                        if (propertyDescriptor == null) {
                            log.warn("Could not find property " + me.getKey() + " on class " + change.getClassName(), new Object[0]);
                            continue;
                        }
                        if (me.getValue() instanceof CollectionChanges) {
                            Object collection = propertyDescriptor.getReadMethod().invoke(entity, new Object[0]);
                            CollectionChanges collectionChanges = (CollectionChanges)me.getValue();
                            for (CollectionChange collectionChange : collectionChanges.getChanges()) {
                                Object value;
                                Object key;
                                Object valueType;
                                Object keyType;
                                Object value2;
                                Object elementType;
                                if (collectionChange.getType() == 1) {
                                    if (collection instanceof Set) {
                                        Type collectionType = propertyDescriptor.getReadMethod().getGenericReturnType();
                                        elementType = Object.class;
                                        if (collectionType instanceof ParameterizedType) {
                                            elementType = ((ParameterizedType)collectionType).getActualTypeArguments()[0];
                                        }
                                        value2 = converters.convert(this.mergeObject(collectionChange.getValue(), cache), (Type)elementType);
                                        ((Set)collection).add(value2);
                                        continue;
                                    }
                                    if (collection instanceof List) {
                                        Type collectionType = propertyDescriptor.getReadMethod().getGenericReturnType();
                                        elementType = Object.class;
                                        if (collectionType instanceof ParameterizedType) {
                                            elementType = ((ParameterizedType)collectionType).getActualTypeArguments()[0];
                                        }
                                        value2 = converters.convert(this.mergeObject(collectionChange.getValue(), cache), (Type)elementType);
                                        ((List)collection).add((Integer)collectionChange.getKey(), value2);
                                        continue;
                                    }
                                    if (!(collection instanceof Map)) continue;
                                    Type mapType = propertyDescriptor.getReadMethod().getGenericReturnType();
                                    keyType = Object.class;
                                    valueType = Object.class;
                                    if (mapType instanceof ParameterizedType) {
                                        keyType = ((ParameterizedType)mapType).getActualTypeArguments()[0];
                                        valueType = ((ParameterizedType)mapType).getActualTypeArguments()[1];
                                    }
                                    key = converters.convert(this.mergeObject(collectionChange.getKey(), cache), (Type)keyType);
                                    value = converters.convert(this.mergeObject(collectionChange.getValue(), cache), (Type)valueType);
                                    ((Map)collection).put(key, value);
                                    continue;
                                }
                                if (collectionChange.getType() == -1) {
                                    Boolean removed;
                                    if (collection instanceof Set) {
                                        Type collectionType = propertyDescriptor.getReadMethod().getGenericReturnType();
                                        elementType = Object.class;
                                        if (collectionType instanceof ParameterizedType) {
                                            elementType = ((ParameterizedType)collectionType).getActualTypeArguments()[0];
                                        }
                                        value2 = converters.convert(this.mergeObject(collectionChange.getValue(), cache), (Type)elementType);
                                        removed = ((Set)collection).remove(value2);
                                        cache.add(removed);
                                        continue;
                                    }
                                    if (collection instanceof List) {
                                        int index = (Integer)collectionChange.getKey();
                                        Object removed2 = ((List)collection).remove(index);
                                        cache.add(removed2);
                                        continue;
                                    }
                                    if (!(collection instanceof Map)) continue;
                                    Type mapType = propertyDescriptor.getReadMethod().getGenericReturnType();
                                    keyType = Object.class;
                                    if (mapType instanceof ParameterizedType) {
                                        keyType = ((ParameterizedType)mapType).getActualTypeArguments()[0];
                                    }
                                    Object key2 = converters.convert(this.mergeObject(collectionChange.getKey(), cache), (Type)keyType);
                                    removed = ((Map)collection).remove(key2);
                                    cache.add(removed);
                                    continue;
                                }
                                if (collectionChange.getType() != 0) continue;
                                if (collection instanceof Set) {
                                    throw new IllegalStateException("Cannot replace an indexed element on a Set, don't use setItemAt on an ArrayCollection representing a Set !");
                                }
                                if (collection instanceof List) {
                                    int index = (Integer)collectionChange.getKey();
                                    Type collectionType = propertyDescriptor.getReadMethod().getGenericReturnType();
                                    Object elementType2 = Object.class;
                                    if (collectionType instanceof ParameterizedType) {
                                        elementType2 = ((ParameterizedType)collectionType).getActualTypeArguments()[0];
                                    }
                                    Object value3 = converters.convert(this.mergeObject(collectionChange.getValue(), cache), (Type)elementType2);
                                    ((List)collection).set(index, value3);
                                    continue;
                                }
                                if (!(collection instanceof Map)) continue;
                                Type mapType = propertyDescriptor.getReadMethod().getGenericReturnType();
                                keyType = Object.class;
                                valueType = Object.class;
                                if (mapType instanceof ParameterizedType) {
                                    keyType = ((ParameterizedType)mapType).getActualTypeArguments()[0];
                                    valueType = ((ParameterizedType)mapType).getActualTypeArguments()[1];
                                }
                                key = converters.convert(this.mergeObject(collectionChange.getKey(), cache), (Type)keyType);
                                value = converters.convert(this.mergeObject(collectionChange.getValue(), cache), (Type)valueType);
                                ((Map)collection).put(key, value);
                            }
                            continue;
                        }
                        if (propertyDescriptor.getWriteMethod() != null) {
                            Object value = this.mergeObject(me.getValue(), cache);
                            value = converters.convert(value, propertyDescriptor.getWriteMethod().getGenericParameterTypes()[0]);
                            propertyDescriptor.getWriteMethod().invoke(entity, value);
                            continue;
                        }
                        log.warn("Property " + me.getKey() + " on class " + change.getClassName() + " is not writeable", new Object[0]);
                    }
                    catch (InvocationTargetException ite) {
                        throw new ServiceException("Could not set property " + me.getKey(), ite.getTargetException());
                    }
                    catch (IllegalAccessException iae) {
                        throw new ServiceException("Could not set property " + me.getKey(), iae);
                    }
                }
            }
            return appliedChange;
        }
        catch (ClassNotFoundException cnfe) {
            throw new ServiceException("Could not find class " + change.getClassName(), cnfe);
        }
    }
}

