/*
 * Decompiled with CFR 0.152.
 */
package org.granite.config;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.granite.config.ConfigurableFactory;
import org.granite.config.GraniteConfig;
import org.granite.config.GraniteConfigException;
import org.granite.messaging.amf.io.util.Property;
import org.granite.messaging.amf.io.util.externalizer.Externalizer;
import org.granite.messaging.amf.io.util.externalizer.annotation.ExternalizedBean;
import org.granite.util.TypeUtil;
import org.granite.util.XMap;

public class ExternalizerFactory
implements ConfigurableFactory<Externalizer> {
    private static final Externalizer NULL_EXTERNALIZER = new Externalizer(){
        private static final String NOT_IMPLEMENTED = "Not implemented (null externalizer)";

        @Override
        public void configure(XMap properties) {
            throw new RuntimeException(NOT_IMPLEMENTED);
        }

        @Override
        public List<Property> findOrderedFields(Class<?> clazz) {
            throw new RuntimeException(NOT_IMPLEMENTED);
        }

        @Override
        public Object newInstance(String type, ObjectInput in) throws IOException, ClassNotFoundException, InstantiationException, InvocationTargetException, IllegalAccessException {
            throw new RuntimeException(NOT_IMPLEMENTED);
        }

        @Override
        public void readExternal(Object o, ObjectInput in) throws IOException, ClassNotFoundException, IllegalAccessException {
            throw new RuntimeException(NOT_IMPLEMENTED);
        }

        @Override
        public void writeExternal(Object o, ObjectOutput out) throws IOException, IllegalAccessException {
            throw new RuntimeException(NOT_IMPLEMENTED);
        }

        @Override
        public int accept(Class<?> clazz) {
            return -1;
        }
    };
    private final ConcurrentHashMap<String, Externalizer> externalizersCache = new ConcurrentHashMap();

    @Override
    public Externalizer getNullInstance() {
        return NULL_EXTERNALIZER;
    }

    @Override
    public Externalizer getInstance(String type, GraniteConfig config) throws GraniteConfigException {
        return this.newInstance(type, config);
    }

    @Override
    public Externalizer getInstanceForBean(List<Externalizer> scannedConfigurables, Class<?> beanClass, GraniteConfig config) throws GraniteConfigException {
        Externalizer externalizer = NULL_EXTERNALIZER;
        if (!Externalizable.class.isAssignableFrom(beanClass)) {
            ExternalizedBean annotation = beanClass.getAnnotation(ExternalizedBean.class);
            Class<Externalizer> type = null;
            if (annotation != null && annotation.type() != null) {
                type = annotation.type();
            } else {
                int maxWeight = -1;
                for (Externalizer e : scannedConfigurables) {
                    int weight = e.accept(beanClass);
                    if (weight <= maxWeight) continue;
                    maxWeight = weight;
                    type = e.getClass();
                }
            }
            if (type != null) {
                externalizer = this.newInstance(type.getName(), config);
            }
        }
        return externalizer;
    }

    private Externalizer newInstance(String externalizerType, GraniteConfig config) {
        Externalizer externalizer = this.externalizersCache.get(externalizerType);
        if (externalizer == null) {
            try {
                externalizer = TypeUtil.newInstance(externalizerType, Externalizer.class);
            }
            catch (Exception e) {
                throw new GraniteConfigException("Could not instantiate externalizer: " + externalizerType, e);
            }
            Externalizer previous = this.externalizersCache.putIfAbsent(externalizerType, externalizer);
            if (previous != null) {
                externalizer = previous;
            } else {
                externalizer.configure(config.getExternalizersConfiguration());
            }
        }
        return externalizer;
    }
}

