/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity.websocket;

import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.granite.gravity.websocket.PolicyFileServer;

public class PolicyFileServerListener
implements ServletContextListener {
    private PolicyFileServer server = null;

    public void contextInitialized(ServletContextEvent sce) {
        String allow;
        this.server = new PolicyFileServer();
        String serverPort = sce.getServletContext().getInitParameter("flashPolicyFileServer-port");
        if (serverPort != null) {
            try {
                this.server.setServerPort(Integer.parseInt(serverPort));
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Incorrect port " + serverPort + " defined for flash-policy-file-server-port", e);
            }
        }
        if ((allow = sce.getServletContext().getInitParameter("flashPolicyFileServer-allowDomains")) != null) {
            String[] a = allow.split(",");
            String[] domains = new String[a.length];
            String[] ports = new String[a.length];
            for (int i = 0; i < a.length; ++i) {
                int idx = a[i].indexOf(":");
                if (idx < 0) {
                    domains[i] = a[i];
                    ports[i] = "80,443";
                    continue;
                }
                domains[i] = a[i].substring(0, idx);
                ports[i] = a[i].substring(idx + 1);
            }
            this.server.setAllowDomains(domains);
            this.server.setAllowPorts(ports);
        }
        this.server.start();
    }

    public void contextDestroyed(ServletContextEvent sce) {
        this.server.stop();
    }
}

