/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.amf.io.convert.impl;

import java.lang.reflect.Type;
import java.util.Locale;
import java.util.regex.Pattern;
import org.granite.messaging.amf.io.convert.Converter;
import org.granite.messaging.amf.io.convert.Converters;
import org.granite.messaging.amf.io.convert.IllegalConverterArgumentException;
import org.granite.messaging.amf.io.convert.Reverter;

public class String2Locale
extends Converter
implements Reverter {
    private static final Pattern SPLITTER = Pattern.compile(Pattern.quote("_"));

    public String2Locale(Converters converters) {
        super(converters);
    }

    @Override
    protected boolean internalCanConvert(Object value, Type targetType) {
        return targetType.equals(Locale.class) && (value == null || value instanceof String);
    }

    @Override
    protected Object internalConvert(Object value, Type targetType) {
        if (value == null) {
            return null;
        }
        String[] tokens = SPLITTER.split((String)value, 3);
        if (tokens.length == 1) {
            return new Locale(tokens[0]);
        }
        if (tokens.length == 2) {
            return new Locale(tokens[0], tokens[1]);
        }
        if (tokens.length == 3) {
            return new Locale(tokens[0], tokens[1], tokens[2]);
        }
        throw new IllegalConverterArgumentException((Converter)this, value, targetType, "Illegal Locale: " + value);
    }

    @Override
    public boolean canRevert(Object value) {
        return value == null || value instanceof Locale;
    }

    @Override
    public Object revert(Object value) {
        if (value != null) {
            value = value.toString();
        }
        return value;
    }
}

