/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.jmf.codec.std.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.Timestamp;
import org.granite.messaging.jmf.DumpContext;
import org.granite.messaging.jmf.InputContext;
import org.granite.messaging.jmf.OutputContext;
import org.granite.messaging.jmf.codec.std.SqlTimestampCodec;
import org.granite.messaging.jmf.codec.std.impl.AbstractStandardCodec;
import org.granite.messaging.jmf.codec.std.impl.util.LongUtil;

public class SqlTimestampCodecImpl
extends AbstractStandardCodec<Timestamp>
implements SqlTimestampCodec {
    @Override
    public int getObjectType() {
        return 250;
    }

    @Override
    public Class<?> getObjectClass() {
        return Timestamp.class;
    }

    @Override
    public void encode(OutputContext ctx, Timestamp v) throws IOException {
        OutputStream os = ctx.getOutputStream();
        os.write(250);
        LongUtil.encodeLong(ctx, v.getTime());
    }

    @Override
    public Timestamp decode(InputContext ctx, int parameterizedJmfType) throws IOException {
        return new Timestamp(LongUtil.decodeLong(ctx));
    }

    @Override
    public void dump(DumpContext ctx, int parameterizedJmfType) throws IOException {
        int jmfType = ctx.getSharedContext().getCodecRegistry().extractJmfType(parameterizedJmfType);
        switch (jmfType) {
            case 250: {
                ctx.indentPrintLn(Timestamp.class.getName() + ": " + this.decode(ctx, parameterizedJmfType));
                break;
            }
            default: {
                throw this.newBadTypeJMFEncodingException(jmfType, parameterizedJmfType);
            }
        }
    }
}

