/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.jmf.codec.std.impl;

import java.io.IOException;
import java.io.OutputStream;
import org.granite.messaging.jmf.DumpContext;
import org.granite.messaging.jmf.InputContext;
import org.granite.messaging.jmf.OutputContext;
import org.granite.messaging.jmf.codec.std.StringCodec;
import org.granite.messaging.jmf.codec.std.impl.AbstractStandardCodec;
import org.granite.messaging.jmf.codec.std.impl.util.IntegerUtil;

public class StringCodecImpl
extends AbstractStandardCodec<String>
implements StringCodec {
    protected static final int INDEX_OR_LENGTH_BYTE_COUNT_OFFSET = 4;
    protected static final int UUID_FLAG = 64;
    protected static final int UUID_LOWERCASE_FLAG = 0;
    protected static final int UUID_UPPERCASE_FLAG = 16;
    protected static final char[] LOWER_HEX = "0123456789abcdef".toCharArray();
    protected static final char[] UPPER_HEX = "0123456789ABCDEF".toCharArray();
    protected static final int[] HEX_INDICES = new int[256];

    @Override
    public int getObjectType() {
        return 4;
    }

    @Override
    public Class<?> getObjectClass() {
        return String.class;
    }

    @Override
    public void encode(OutputContext ctx, String v) throws IOException {
        OutputStream os = ctx.getOutputStream();
        if (v.length() == 0) {
            os.write(4);
            os.write(0);
            return;
        }
        int indexOfStoredString = ctx.indexOfString(v);
        if (indexOfStoredString >= 0) {
            int count = IntegerUtil.significantIntegerBytesCount0(indexOfStoredString);
            os.write(0x80 | count << 4 | 4);
            IntegerUtil.encodeInteger(ctx, indexOfStoredString, count);
        } else {
            ctx.addToStrings(v);
            int uuidCaseFlag = this.isUUID(v);
            if (uuidCaseFlag != -1) {
                this.encodeUUID(ctx, v, uuidCaseFlag);
            } else {
                byte[] bytes = v.getBytes(UTF8);
                int length = bytes.length;
                int count = IntegerUtil.significantIntegerBytesCount0(length);
                os.write(count << 4 | 4);
                IntegerUtil.encodeInteger(ctx, length, count);
                os.write(bytes, 0, length);
            }
        }
    }

    @Override
    public String decode(InputContext ctx, int parameterizedJmfType) throws IOException {
        if ((parameterizedJmfType & 0x80) != 0) {
            int index = IntegerUtil.decodeInteger(ctx, parameterizedJmfType >>> 4 & 3);
            return ctx.getString(index);
        }
        if ((parameterizedJmfType & 0x40) != 0) {
            String uid = this.decodeUUID(ctx, parameterizedJmfType);
            ctx.addToStrings(uid);
            return uid;
        }
        int length = IntegerUtil.decodeInteger(ctx, parameterizedJmfType >>> 4 & 3);
        if (length == 0) {
            return "";
        }
        byte[] bytes = new byte[length];
        ctx.safeReadFully(bytes);
        String s = new String(bytes, UTF8);
        ctx.addToStrings(s);
        return s;
    }

    @Override
    public void dump(DumpContext ctx, int parameterizedJmfType) throws IOException {
        ctx.indentPrintLn(String.class.getName() + ": \"" + this.escape(this.decode(ctx, parameterizedJmfType)) + "\"");
    }

    protected int isUUID(String v) {
        if (v.length() != 36 || v.charAt(8) != '-') {
            return -1;
        }
        int flag = -1;
        block3: for (int i = 0; i < 36; ++i) {
            char c = v.charAt(i);
            switch (i) {
                case 8: 
                case 13: 
                case 18: 
                case 23: {
                    if (c == '-') continue block3;
                    return -1;
                }
                default: {
                    if (c >= '0' && c <= '9') continue block3;
                    if (c >= 'a' && c <= 'f') {
                        if (flag == -1) {
                            flag = 0;
                            continue block3;
                        }
                        if (flag == 0) continue block3;
                        return -1;
                    }
                    if (c >= 'A' && c <= 'F') {
                        if (flag == -1) {
                            flag = 16;
                            continue block3;
                        }
                        if (flag == 16) continue block3;
                        return -1;
                    }
                    return -1;
                }
            }
        }
        if (flag == -1) {
            flag = 0;
        }
        return flag;
    }

    protected void encodeUUID(OutputContext ctx, String v, int caseFlag) throws IOException {
        OutputStream os = ctx.getOutputStream();
        os.write(caseFlag | 0x40 | 4);
        byte[] bytes = new byte[16];
        int i = 0;
        int j = 0;
        while (i < 36) {
            char c1;
            if ((c1 = v.charAt(i++)) == '-') {
                c1 = v.charAt(i++);
            }
            char c2 = v.charAt(i++);
            bytes[j++] = (byte)(HEX_INDICES[c1] << 4 | HEX_INDICES[c2]);
        }
        os.write(bytes);
    }

    protected String decodeUUID(InputContext ctx, int parameterizedJmfType) throws IOException {
        char[] hex = (parameterizedJmfType & 0x10) != 0 ? UPPER_HEX : LOWER_HEX;
        byte[] bytes = new byte[16];
        ctx.safeReadFully(bytes);
        char[] chars = new char[36];
        int i = 0;
        for (byte b : bytes) {
            if (i == 8 || i == 13 || i == 18 || i == 23) {
                chars[i++] = 45;
            }
            chars[i++] = hex[(b & 0xF0) >>> 4];
            chars[i++] = hex[b & 0xF];
        }
        return new String(chars);
    }

    static {
        for (int i = 0; i < HEX_INDICES.length; ++i) {
            StringCodecImpl.HEX_INDICES[i] = i >= 48 && i <= 57 ? i - 48 : (i >= 97 && i <= 102 ? i - 97 + 10 : (i >= 65 && i <= 70 ? i - 65 + 10 : -1));
        }
    }
}

