/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.jmf.codec.std.impl.util;

import java.io.IOException;
import java.io.OutputStream;
import org.granite.messaging.jmf.InputContext;
import org.granite.messaging.jmf.JMFEncodingException;
import org.granite.messaging.jmf.OutputContext;
import org.granite.messaging.jmf.codec.std.impl.util.LongUtil;

public class DoubleUtil {
    public static DoubleAsLong doubleAsLong04(double v) {
        long asLong = (long)v;
        if (v == (double)asLong) {
            return new DoubleAsLong(asLong, 0);
        }
        asLong = (long)(v * 100.0);
        if (v == (double)asLong / 100.0) {
            return new DoubleAsLong(asLong, 2);
        }
        if (v == (double)(asLong += (long)(asLong < 0L ? -1 : 1)) / 100.0) {
            return new DoubleAsLong(asLong, 2);
        }
        asLong = (long)(v * 10000.0);
        if (v == (double)asLong / 10000.0) {
            return new DoubleAsLong(asLong, 4);
        }
        if (v == (double)(asLong += (long)(asLong < 0L ? -1 : 1)) / 10000.0) {
            return new DoubleAsLong(asLong, 4);
        }
        return null;
    }

    public static void encodeDouble(OutputContext ctx, double v) throws IOException {
        LongUtil.encodeLong(ctx, Double.doubleToLongBits(v));
    }

    public static double decodeDouble(InputContext ctx) throws IOException {
        return Double.longBitsToDouble(LongUtil.decodeLong(ctx));
    }

    public static void encodeVariableDouble(OutputContext ctx, double v) throws IOException {
        OutputStream os = ctx.getOutputStream();
        long bits = Double.doubleToRawLongBits(v);
        if ((bits & 0x7FF0000000000000L) == 0x7FF0000000000000L) {
            os.write(127);
            if (bits == 0x7FF0000000000000L) {
                os.write(240);
            } else if (bits == -4503599627370496L) {
                os.write(241);
            } else {
                os.write(242);
            }
        } else if (bits == Long.MIN_VALUE) {
            os.write(127);
            os.write(243);
        } else {
            DoubleAsLong asLong = DoubleUtil.doubleAsLong04(v);
            if (asLong != null && asLong.longValue >= -17315143744L && asLong.longValue <= 17315143743L) {
                os.write(255);
                os.write(0xF0 | asLong.pow10);
                LongUtil.encodeVariableLong(ctx, asLong.longValue);
            } else {
                LongUtil.encodeLong(ctx, bits);
            }
        }
    }

    public static double decodeVariableDouble(InputContext ctx) throws IOException {
        int prefix = ctx.safeRead() << 8 | ctx.safeRead();
        switch (prefix) {
            case 32752: {
                return Double.POSITIVE_INFINITY;
            }
            case 32753: {
                return Double.NEGATIVE_INFINITY;
            }
            case 32754: {
                return Double.NaN;
            }
            case 32755: {
                return -0.0;
            }
        }
        if ((prefix & 0xFFF0) == 65520) {
            long asLong = LongUtil.decodeVariableLong(ctx);
            int pow10 = prefix & 0xF;
            switch (pow10) {
                case 0: {
                    return asLong;
                }
                case 2: {
                    return (double)asLong / 100.0;
                }
                case 4: {
                    return (double)asLong / 10000.0;
                }
            }
            throw new JMFEncodingException("Unsupported power of 10: " + pow10);
        }
        return Double.longBitsToDouble((long)prefix << 48 | LongUtil.decodeLong(ctx, 5));
    }

    public static class DoubleAsLong {
        public final long longValue;
        public final int pow10;

        public DoubleAsLong(long longValue, int pow10) {
            this.longValue = longValue;
            this.pow10 = pow10;
        }
    }
}

