/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.service;

import flex.messaging.messages.Message;
import org.granite.config.flex.Destination;
import org.granite.messaging.service.ServiceException;
import org.granite.messaging.service.ServiceExceptionHandler;
import org.granite.messaging.service.ServiceInvocationContext;

public abstract class AbstractServiceExceptionHandler
implements ServiceExceptionHandler {
    private static final long serialVersionUID = 1L;
    private final boolean logException;

    public AbstractServiceExceptionHandler(boolean logException) {
        this.logException = logException;
    }

    protected boolean getLogException() {
        return this.logException;
    }

    protected ServiceException getServiceException(ServiceInvocationContext context, Throwable e) {
        String method = context.getMethod() != null ? context.getMethod().toString() : "null";
        return this.getServiceException(context.getMessage(), context.getDestination(), method, e);
    }

    protected ServiceException getServiceException(Message request, Destination destination, String method, Throwable e) {
        if (e instanceof ServiceException) {
            return (ServiceException)e;
        }
        String detail = "\n- destination: " + (destination != null ? destination.getId() : "") + "\n" + "- method: " + method + "\n" + "- exception: " + e.toString() + "\n";
        return new ServiceException(this.getClass().getSimpleName() + ".Call.Failed", e.getMessage(), detail, e);
    }
}

