/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.jmf.codec.std.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import org.granite.messaging.jmf.DumpContext;
import org.granite.messaging.jmf.InputContext;
import org.granite.messaging.jmf.OutputContext;
import org.granite.messaging.jmf.codec.std.BigIntegerCodec;
import org.granite.messaging.jmf.codec.std.impl.AbstractStandardCodec;
import org.granite.messaging.jmf.codec.std.impl.util.IntegerUtil;

public class BigIntegerCodecImpl
extends AbstractStandardCodec<BigInteger>
implements BigIntegerCodec {
    protected static final int LENGTH_BYTE_COUNT_OFFSET = 6;

    @Override
    public int getObjectType() {
        return 26;
    }

    @Override
    public Class<?> getObjectClass() {
        return BigInteger.class;
    }

    @Override
    public void encode(OutputContext ctx, BigInteger v) throws IOException {
        OutputStream os = ctx.getOutputStream();
        byte[] magnitude = v.toByteArray();
        int count = IntegerUtil.significantIntegerBytesCount0(magnitude.length);
        os.write(count << 6 | 0x1A);
        IntegerUtil.encodeInteger(ctx, magnitude.length, count);
        os.write(magnitude);
    }

    @Override
    public BigInteger decode(InputContext ctx, int parameterizedJmfType) throws IOException {
        int magnitudeLength = IntegerUtil.decodeInteger(ctx, parameterizedJmfType >>> 6);
        byte[] magnitude = new byte[magnitudeLength];
        ctx.safeReadFully(magnitude);
        BigInteger v = new BigInteger(magnitude);
        if (BigInteger.ZERO.equals(v)) {
            v = BigInteger.ZERO;
        } else if (BigInteger.ONE.equals(v)) {
            v = BigInteger.ONE;
        } else if (BigInteger.TEN.equals(v)) {
            v = BigInteger.TEN;
        }
        return v;
    }

    @Override
    public void dump(DumpContext ctx, int parameterizedJmfType) throws IOException {
        int jmfType = ctx.getSharedContext().getCodecRegistry().extractJmfType(parameterizedJmfType);
        if (jmfType != 26) {
            throw this.newBadTypeJMFEncodingException(jmfType, parameterizedJmfType);
        }
        ctx.indentPrintLn(BigInteger.class.getName() + ": " + this.decode(ctx, parameterizedJmfType));
    }
}

