/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.service;

import flex.messaging.messages.RemotingMessage;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.granite.clustering.TransientReference;
import org.granite.config.GraniteConfig;
import org.granite.config.flex.Destination;
import org.granite.context.GraniteContext;
import org.granite.logging.Logger;
import org.granite.messaging.service.ServiceException;
import org.granite.messaging.service.ServiceExceptionHandler;
import org.granite.messaging.service.ServiceFactory;
import org.granite.messaging.service.ServiceInvocationContext;
import org.granite.messaging.service.ServiceInvocationListener;
import org.granite.messaging.service.security.RemotingDestinationSecurizer;

@TransientReference
public abstract class ServiceInvoker<T extends ServiceFactory> {
    private static final Logger log = Logger.getLogger(ServiceInvoker.class);
    protected final List<ServiceInvocationListener> invocationListeners;
    protected final Destination destination;
    protected final T factory;
    protected Object invokee = null;
    private ServiceExceptionHandler serviceExceptionHandler;

    protected ServiceInvoker(Destination destination, T factory) throws ServiceException {
        this.destination = destination;
        this.factory = factory;
        this.serviceExceptionHandler = ((ServiceFactory)factory).getServiceExceptionHandler();
        ServiceInvocationListener invocationListener = ((GraniteConfig)GraniteContext.getCurrentInstance().getGraniteConfig()).getInvocationListener();
        if (invocationListener != null) {
            this.invocationListeners = new ArrayList<ServiceInvocationListener>();
            this.invocationListeners.add(invocationListener);
        } else {
            this.invocationListeners = null;
        }
    }

    protected Object adjustInvokee(RemotingMessage request, String methodName, Object[] args) throws ServiceException {
        return this.invokee;
    }

    protected Object[] beforeMethodSearch(Object invokee, String methodName, Object[] args) {
        return new Object[]{methodName, args};
    }

    protected void beforeInvocation(ServiceInvocationContext context) {
    }

    protected boolean retryInvocation(ServiceInvocationContext context, Throwable t) {
        return false;
    }

    protected void afterInvocationError(ServiceInvocationContext context, Throwable error) {
    }

    protected Object afterInvocation(ServiceInvocationContext context, Object result) {
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object invoke(RemotingMessage request) throws ServiceException {
        GraniteConfig config = (GraniteConfig)GraniteContext.getCurrentInstance().getGraniteConfig();
        String methodName = request.getOperation();
        Object[] args = (Object[])request.getBody();
        Object invokee = this.adjustInvokee(request, methodName, args);
        Object[] call = this.beforeMethodSearch(invokee, methodName, args);
        methodName = (String)call[0];
        args = (Object[])call[1];
        if (this.invocationListeners != null) {
            for (ServiceInvocationListener invocationListener : this.invocationListeners) {
                args = invocationListener.beforeMethodSearch(invokee, methodName, args);
            }
        }
        log.debug(">> Trying to find method: %s%s in %s", methodName, args, invokee != null ? invokee.getClass() : "");
        ServiceInvocationContext invocationContext = null;
        try {
            invocationContext = config.getMethodMatcher().findServiceMethod(request, this.destination, invokee, methodName, args);
        }
        catch (NoSuchMethodException e) {
            throw this.serviceExceptionHandler.handleNoSuchMethodException(request, this.destination, invokee, methodName, args, e);
        }
        try {
            this.beforeInvocation(invocationContext);
            if (this.invocationListeners != null) {
                for (ServiceInvocationListener invocationListener : this.invocationListeners) {
                    invocationListener.beforeInvocation(invocationContext);
                }
            }
        }
        catch (Exception error) {
            this.handleInvocationError(invocationContext, error);
        }
        log.debug(">> Invoking method: %s with ", invocationContext.getMethod(), args);
        Throwable error = null;
        Object result = null;
        try {
            if (this.destination.getSecurizer() instanceof RemotingDestinationSecurizer) {
                ((RemotingDestinationSecurizer)this.destination.getSecurizer()).canExecute(invocationContext);
            }
            boolean retry = false;
            try {
                result = config.hasSecurityService() && config.getSecurityService().acceptsContext() ? config.getSecurityService().authorize(invocationContext) : invocationContext.invoke();
            }
            catch (Exception e) {
                if (this.retryInvocation(invocationContext, e instanceof InvocationTargetException ? e.getCause() : e)) {
                    retry = true;
                }
                throw e;
            }
            if (retry) {
                result = config.hasSecurityService() ? config.getSecurityService().authorize(invocationContext) : invocationContext.invoke();
            }
        }
        catch (InvocationTargetException e) {
            error = e.getTargetException();
        }
        catch (Throwable e) {
            error = e;
        }
        finally {
            if (error != null) {
                this.handleInvocationError(invocationContext, error);
            }
        }
        result = this.afterInvocation(invocationContext, result);
        if (this.invocationListeners != null) {
            for (ServiceInvocationListener invocationListener : this.invocationListeners) {
                result = invocationListener.afterInvocation(invocationContext, result);
            }
        }
        log.debug("<< Returning result: %s", result);
        return result;
    }

    private void handleInvocationError(ServiceInvocationContext invocationContext, Throwable error) throws ServiceException {
        this.afterInvocationError(invocationContext, error);
        if (this.invocationListeners != null) {
            for (ServiceInvocationListener invocationListener : this.invocationListeners) {
                invocationListener.afterInvocationError(invocationContext, error);
            }
        }
        if (error instanceof ServiceException) {
            throw (ServiceException)error;
        }
        throw this.serviceExceptionHandler.handleInvocationException(invocationContext, error);
    }
}

