/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.data;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javassist.util.proxy.MethodFilter;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyFactory;
import javassist.util.proxy.ProxyObject;
import org.granite.messaging.amf.io.convert.Converter;
import org.granite.messaging.amf.io.convert.Converters;
import org.granite.tide.data.ChangeSet;
import org.granite.tide.data.ChangeSetProxy;
import org.granite.util.TypeUtil;

public class ChangeSetConverter
extends Converter {
    private ConcurrentMap<Class<?>, Class<?>> proxyClasses = new ConcurrentHashMap();
    private static final MethodFilter FINALIZE_FILTER = new MethodFilter(){

        public boolean isHandled(Method m) {
            return m.getParameterTypes().length > 0 || !m.getName().equals("finalize");
        }
    };

    public ChangeSetConverter(Converters converters) {
        super(converters);
    }

    @Override
    protected boolean internalCanConvert(Object value, Type targetType) {
        if (value instanceof ChangeSet && targetType instanceof Class) {
            if (((ChangeSet)value).getChanges() == null || ((ChangeSet)value).getChanges().length == 0) {
                throw new IllegalArgumentException("Incoming ChangeSet objects must contain at least one Change");
            }
            String className = ((ChangeSet)value).getChanges()[0].getClassName();
            try {
                Class<?> clazz = TypeUtil.forName(className);
                return ((Class)targetType).isAssignableFrom(clazz);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Cannot find class for ChangeSet argument " + className);
            }
        }
        return false;
    }

    @Override
    protected Object internalConvert(Object value, Type targetType) {
        ChangeSet changeSet = (ChangeSet)value;
        String className = changeSet.getChanges()[0].getClassName();
        try {
            Class<?> clazz = TypeUtil.forName(className);
            Class proxyClass = (Class)this.proxyClasses.get(clazz);
            if (proxyClass == null) {
                ProxyFactory proxyFactory = new ProxyFactory();
                proxyFactory.setFilter(FINALIZE_FILTER);
                proxyFactory.setSuperclass(clazz);
                proxyFactory.setInterfaces(new Class[]{ChangeSetProxy.class});
                proxyClass = proxyFactory.createClass();
                this.proxyClasses.put(clazz, proxyClass);
            }
            ProxyObject proxyObject = (ProxyObject)proxyClass.newInstance();
            proxyObject.setHandler((MethodHandler)new ChangeSetProxyHandler(proxyObject, changeSet));
            return proxyObject;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot build proxy for Change argument " + className);
        }
    }

    private static class ChangeSetProxyHandler
    implements MethodHandler {
        private final Object proxyObject;
        private final ChangeSet changeSet;

        public ChangeSetProxyHandler(ProxyObject proxyObject, ChangeSet changeSet) {
            this.proxyObject = proxyObject;
            this.changeSet = changeSet;
        }

        public Object invoke(Object object, Method method, Method method1, Object[] args) throws Exception {
            String name = method.getName();
            if ("toString".equals(name)) {
                return this.changeSet.getChanges()[0].getClassName() + "@" + System.identityHashCode(object);
            }
            if ("equals".equals(name)) {
                return this.proxyObject == object;
            }
            if ("hashCode".equals(name)) {
                return System.identityHashCode(object);
            }
            if ("getChangeSetProxyData".equals(name) && method.getParameterTypes().length == 0) {
                return this.changeSet;
            }
            return null;
        }
    }
}

