/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.data;

import javax.persistence.PostPersist;
import javax.persistence.PostRemove;
import javax.persistence.PostUpdate;
import org.granite.tide.data.DataContext;
import org.granite.tide.data.ExcludeFromDataPublish;

public class DataPublishListener {
    @PostPersist
    public void onPostPersist(Object entity) {
        if (DataPublishListener.handleExclude(entity)) {
            return;
        }
        DataContext.addUpdate(DataContext.EntityUpdateType.PERSIST, entity, entity);
    }

    @PostRemove
    public void onPostRemove(Object entity) {
        if (DataPublishListener.handleExclude(entity)) {
            return;
        }
        DataContext.addUpdate(DataContext.EntityUpdateType.REMOVE, entity, entity);
    }

    @PostUpdate
    public void onPostUpdate(Object entity) {
        if (DataPublishListener.handleExclude(entity)) {
            return;
        }
        DataContext.addUpdate(DataContext.EntityUpdateType.UPDATE, entity, entity);
    }

    public static boolean handleExclude(Object entity) {
        if (entity == null || DataContext.get() == null) {
            return true;
        }
        if (!entity.getClass().isAnnotationPresent(ExcludeFromDataPublish.class)) {
            return false;
        }
        ExcludeFromDataPublish exclude = entity.getClass().getAnnotation(ExcludeFromDataPublish.class);
        if (exclude.value() == ExcludeFromDataPublish.ExcludeMode.CHANGES) {
            DataContext.addUpdate(DataContext.EntityUpdateType.REFRESH, entity.getClass(), entity.getClass());
        }
        return true;
    }
}

