/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.pushtocloud;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.neo4j.commandline.admin.AdminCommand;
import org.neo4j.commandline.admin.CommandFailed;
import org.neo4j.commandline.admin.IncorrectUsage;
import org.neo4j.commandline.admin.OutsideWorld;
import org.neo4j.commandline.arguments.Arguments;
import org.neo4j.commandline.arguments.MandatoryNamedArg;
import org.neo4j.commandline.arguments.NamedArgument;
import org.neo4j.commandline.arguments.OptionalNamedArg;
import org.neo4j.commandline.arguments.common.Database;
import org.neo4j.helpers.Args;

public class PushToCloudCommand
implements AdminCommand {
    static final String ARG_DATABASE = "database";
    static final String ARG_BOLT_URI = "bolt-uri";
    static final String ARG_DUMP = "dump";
    static final String ARG_DUMP_TO = "dump-to";
    static final String ARG_VERBOSE = "verbose";
    static final String ARG_OVERWRITE = "overwrite";
    static final String ARG_USERNAME = "username";
    static final String ARG_PASSWORD = "password";
    static final String ENV_USERNAME = "ONGDB_USERNAME";
    static final String ENV_PASSWORD = "ONGDB_PASSWORD";
    static final Arguments arguments = new Arguments().withDatabase().withArgument((NamedArgument)new OptionalNamedArg("dump", "/path/to/my-ongdb-database-dump-file", null, "Path to an existing database dump for upload. This arugment cannot be used together with --database.")).withArgument((NamedArgument)new OptionalNamedArg("dump-to", "/path/to/dump-file-to-be-created", null, "Target path for dump file. Used in combination with the --database argument.")).withArgument((NamedArgument)new MandatoryNamedArg("bolt-uri", "bolt+routing://mydatabaseid.databases.neo4j.io", "Bolt URI of target database")).withArgument((NamedArgument)new OptionalNamedArg("verbose", "true/false", null, "Enable verbose output.")).withArgument((NamedArgument)new OptionalNamedArg("username", "ongdb", null, "Optional: Username of the target database to push this database to. Prompt will ask for username if not provided. Alternatively ONGDB_USERNAME environment variable can be used.")).withArgument((NamedArgument)new OptionalNamedArg("password", "mYs3cr3tPa$$w0rd", null, "Optional: Password of the target database to push this database to. Prompt will ask for password if not provided. Alternatively ONGDB_PASSWORD environment variable can be used.")).withArgument((NamedArgument)new OptionalNamedArg("overwrite", "true/false", "false", "Optional: Overwrite the data in the target database."));
    private final Path homeDir;
    private final Path configDir;
    private final OutsideWorld outsideWorld;
    private final Copier copier;
    private final DumpCreator dumpCreator;

    public PushToCloudCommand(Path homeDir, Path configDir, OutsideWorld outsideWorld, Copier copier, DumpCreator dumpCreator) {
        this.homeDir = homeDir;
        this.configDir = configDir;
        this.outsideWorld = outsideWorld;
        this.copier = copier;
        this.dumpCreator = dumpCreator;
    }

    public void execute(String[] args) throws IncorrectUsage, CommandFailed {
        Args arguments = Args.parse((String[])args);
        boolean verbose = arguments.getBoolean(ARG_VERBOSE);
        try {
            String passwordFromArg = arguments.get(ARG_PASSWORD);
            String username = arguments.get(ARG_USERNAME);
            String usernameFromEnv = System.getenv(ENV_USERNAME);
            String passwordFromEnv = System.getenv(ENV_PASSWORD);
            if (username == null) {
                username = usernameFromEnv != null ? usernameFromEnv : this.outsideWorld.promptLine("Neo4j Aura database username (default: neo4j): ", new Object[0]);
            }
            if (username == null || "".equals(username)) {
                username = "ongdb";
            }
            char[] password = passwordFromArg != null ? passwordFromArg.toCharArray() : (passwordFromEnv != null ? passwordFromEnv.toCharArray() : this.outsideWorld.promptPassword(String.format("Neo4j Aura database password for %s: ", username), new Object[0]));
            String boltURI = arguments.get(ARG_BOLT_URI);
            if (boltURI == null || "".equals(boltURI)) {
                boltURI = this.outsideWorld.promptLine("Neo4j Aura database Bolt URI: ", new Object[0]);
            }
            if (boltURI == null || "".equals(boltURI)) {
                throw new IncorrectUsage("Please provide a Neo4j Aura Bolt URI of the target location to push the database to, using the --bolt-uri argument.");
            }
            String confirmationViaArgument = arguments.get(ARG_OVERWRITE, "false", "true");
            String consoleURL = this.buildConsoleURI(boltURI);
            String bearerToken = this.copier.authenticate(verbose, consoleURL, username, password, "true".equals(confirmationViaArgument));
            Path source = this.initiateSource(arguments);
            boolean deleteDump = arguments.get(ARG_DUMP) == null;
            this.copier.copy(verbose, consoleURL, boltURI, source, deleteDump, bearerToken);
        }
        catch (Exception e) {
            if (verbose) {
                this.outsideWorld.printStacktrace(e);
            }
            throw e;
        }
    }

    private String buildConsoleURI(String boltURI) throws IncorrectUsage {
        Pattern pattern = Pattern.compile("(?:bolt(?:\\+routing)?|neo4j(?:\\+s|\\+ssc)?)://([^-]+)(-(.+))?.databases.neo4j.io$");
        Matcher matcher = pattern.matcher(boltURI);
        if (!matcher.matches()) {
            throw new IncorrectUsage("Invalid Bolt URI '" + boltURI + "'");
        }
        String databaseId = matcher.group(1);
        String environment = matcher.group(2);
        return String.format("https://console%s.neo4j.io/v1/databases/%s", environment == null ? "" : environment, databaseId);
    }

    private Path initiateSource(Args arguments) throws IncorrectUsage, CommandFailed {
        String to;
        Path dumpFile;
        String dump = arguments.get(ARG_DUMP);
        String database = arguments.get(ARG_DATABASE);
        if (dump != null && database != null) {
            throw new IncorrectUsage("Provide either a dump or database name, not both");
        }
        if (dump != null) {
            Path path = Paths.get(dump, new String[0]);
            if (!Files.exists(path, new LinkOption[0])) {
                throw new CommandFailed(String.format("The provided dump '%s' file doesn't exist", path));
            }
            return path;
        }
        if (database == null) {
            database = new Database().defaultValue();
            this.outsideWorld.stdOutLine("Selecting default database '" + database + "'");
        }
        Path path = dumpFile = (to = arguments.get(ARG_DUMP_TO)) != null ? Paths.get(to, new String[0]) : this.homeDir.resolve("dump-of-" + database + "-" + System.currentTimeMillis());
        if (Files.exists(dumpFile, new LinkOption[0])) {
            throw new CommandFailed(String.format("The provided dump-to target '%s' file already exists", dumpFile));
        }
        this.dumpCreator.dumpDatabase(database, dumpFile);
        return dumpFile;
    }

    public static interface DumpCreator {
        public void dumpDatabase(String var1, Path var2) throws CommandFailed, IncorrectUsage;
    }

    public static interface Copier {
        public String authenticate(boolean var1, String var2, String var3, char[] var4, boolean var5) throws CommandFailed;

        public void copy(boolean var1, String var2, String var3, Path var4, boolean var5, String var6) throws CommandFailed;
    }
}

